#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CLevel.h"


void CLevel::count_items(CMapObjects *obs)
{
    total_fries=obs->count_fries();
    total_cheeses=obs->count_cheeses();
}  

void CLevel::splash_level(BITMAP *bmp, FONT *f, int y)
{
    textprintf_centre_ex(bmp,f,320,y,makecol(255,255,0),-1,"%s",level_name);
}

char* CLevel::ret_song_filename(void)
{

       return song_name;    
}    

void CLevel::set_up_level(CMap *map, CMapObjects *obs ,CObjectSet *os, CTileSet *ts, DATAFILE *d, CTile *blank, CEnims *enims, CCinematic *ingameCin)
{

    ts->init(); //creates the tile set object
    ts->load_tile_set(tileset_name);  //loads the tile set using the given data
    
    //loads the object set. The object set holds a prototype for every object in the game
    os->load_object_set(objectset_name);

    map->load_map(map_name,ts,blank,d,os,obs,ingameCin);
    enims->find_enims(obs);

    //count_items();
    total_fries=obs->count_fries();
    total_cheeses=obs->count_cheeses();
    //only count the fries in the level if it has never been played before
    /*if(played_before==false)
        {

        fries_left=total_fries;
        }

    played_before=true;    */
}

void CLevel::create_level(char *_map_name, char *_level_name, char *_tileset_name, char *_objectset_name, char *_song_name, 
                          int _world_num, int _iFriesNeeded, int _iCheeseNeeded,
                          int _map_pos_x, int _map_pos_y)
{
    map_name = new char[strlen(_map_name)+1];
    strcpy(map_name,_map_name);
    
    level_name = new char[strlen(_level_name)+1];
    strcpy(level_name,_level_name);
    
    tileset_name = new char[strlen(_tileset_name)+1];
    strcpy(tileset_name,_tileset_name);
    
    objectset_name = new char[strlen(_objectset_name)+1];
    strcpy(objectset_name,_objectset_name);
    
    song_name = new char[strlen(_song_name)+1];
    strcpy(song_name,_song_name);    
    
    iFriesNeeded = _iFriesNeeded;
    iCheeseNeeded = _iCheeseNeeded;
    
    map_pos_x = _map_pos_x;
    map_pos_y = _map_pos_y;
    
    exist=true;
    world_num = _world_num;
    
    
}

void CLevel::init(void)
{
    exist=false;
    played_before=false;
    //fries_left=0;
    total_fries=0;
    total_cheeses=0;
    
    map_pos_x=0;
    map_pos_y=0;

}
