#include "Standards.h"

#ifndef ccinematic_def
#define ccinematic_def

#include "CDialog.h"
//#include "CPlayer.h"

#define MAX_ACTORS      100
#define MAX_TEXTBOXES   10
#define MAX_ACTIONS     1000

#define CIN_FINISHED    -1
#define CIN_RUNNING     0

class CPlayer;


typedef struct
{
    //the condition that causes this command to execute
    char action[25];
    //parameters
    int p1;
    float p2,p3,p4;
    bool exist;
}CinematicCommand;

typedef struct
{
    BITMAP *pic,*pic2;
    float x,y;
    float dx,dy;
    int destx,desty;
    bool flipped;
    bool visible;
    float scale, dscale,destscale;
    int alpha, dalpha, destalpha;
    
}Actor;

typedef struct
{
    BITMAP *pic;        //the pic to draw in the top left corner of the textbox
    int dialogNum;
    bool visible;
    float x,y;
    float dx,dy;
    int destx,desty;
    int width,height;
    RGB bgc,textc;
    FONT *font;
    int textoffsetx,textoffsety;

}Textbox;

class CCinematic
{
private:
    Actor actor[MAX_ACTORS];    //array of actors
    Textbox textbox[MAX_TEXTBOXES];
    char filename[60];
    DATAFILE *data, *fonts, *sounds;
    CinematicCommand command[MAX_ACTIONS];
    int iNumCommands;
    int iCurCommand;

    char sDatafile[100];    //datafile
    char sFontsDatafile[100];
    char sSoundsDatafile[100];
    
    int iNumPics;
    
    char sDialog[100];      //dialog filename
    CDialog dialog;
    
    int wait,notextwait;
    bool bWaitForKey;
    RGB bgColour;
    
    bool on,loaded;
    int hitEnterColour;
    
    bool disallow_skip_scene;
    bool move_game_during_cin;
    
public:
    CCinematic(void);
    CCinematic(char *filename);
    ~CCinematic(void);
    
    void draw(BITMAP *backgr);
    int move(CPlayer *player, int s_x, int s_y);        //returns true when finished
    int executeCommand(CinematicCommand &c, CPlayer *player, int s_x, int s_y);
    
    void unload(void);
    void init(char *filename);
    void init_blank(void);
    
    void start(void)    {on=true;}
    bool isOn(void) {return on;}
    void end(void);
    
    bool getMoveDuringCin(void) {return move_game_during_cin;}

};    


#endif
