#ifndef ccharacter_def
#define ccharacter_def


#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CObject.h"
#include "CParts.h"
#include "CAnim.h"
#include "CTile.h"
#include "CTileSet.h"

#include "CObjectSet.h"
#include "CMapObject.h"
#include "CMapObjects.h"
#include "CForeground.h"
#include "CMap.h"
#include "CProjectile.h"
#include "CProjectiles.h"



#define MAX_ABILITIES   20

#define AB_DUCKJUMP 0
#define AB_CHARGE1  1

#define OFF -1

class CMapObjects;

class CRevengeScript;
#include "CRevengeScript.h"

typedef struct
{
    bool ability[MAX_ABILITIES];
} TSkills;

class CCharacter : public CMapObject
{
protected:
    float odx,ody;
    float pdx,pdy;  //the movement of any platforms

    DATAFILE *sounds;

    float max_speed;


    int life;
    int max_life;

    bool in_water;
    bool touching_platform;
    short int landing;
    float jump_power;
    
    float fTileFriction;
    bool ducked;
    bool head_touching;
    
    TSkills skills;
    int charging_state, charging_time_left;

    float jump_height, norm_jump_height;
    bool dying;
    
    int new_screen_x,new_screen_y;  //for overriding the camera position in cinematics
    
public:
    float x_accel, y_accel;
    int startX,startY;
    int key_value;      //which key was last pressed (eg LEFT or RIGHT)
    //bool flamed_anim_on;
    int web_left;
    int jumped;
    int start_jump;
    
    void setTouchingGround(bool state);
    
    void init_c(void);      //init character
    //void create_c(BITMAP *_pic, DATAFILE *d, int _type, float _x, float _y);
    void create_c(ob _obInfo, DATAFILE *d, DATAFILE *_sounds, float _x, float _y, int _life, CCinematic *_ingameCin);
    void create_c(CMapObject *ob);

    void move(CMap *map, CMapObjects *objects, CParts *parts,float s_x, float s_y);

    void key_left(void);
    void key_right(void);
    void key_up(void);
    void key_down(void);
    void not_key_down(void);
    
    void not_left_or_right(void);
    void apply_friction(float modifier=1);
    float ret_x(void);
    float ret_y(void);
    bool check_down(CMap *map, CMapObjects *objects, CParts *parts);
    bool check_up(CMap *map);
    void check_left(CMap *map);
    void check_right(CMap *map);
    void set_movement_to_object(CMapObject *ob);
    void change_dir(void);
    int check_col_with_character(CCharacter *c, CParts *parts, CDialog *dialog);
    void life_down(int n, CParts *parts);
    int return_life(void);
    int return_max_life(void);
    int check_col_with_objects(CMapObjects *obs, CParts *parts,CDialog *dialog);

    bool ret_dying(void) {return dying;}

    void start_pivot(Point pivot);

    void set_web_left(int n);
    void adjust_web_length(int dir);
    void draw_p(BITMAP *backgr, int s_x, int s_y);
    
    int check_col_with_projs(CProjectiles *projs);
    
    SAMPLE *ret_sample(int num);
    float ret_dx(void) {return dx;}
    float ret_dy(void) {return dy;}
    void restore_life(void) {life=max_life;}
    
    int ret_new_screen_x(void) {return new_screen_x;}
    int ret_new_screen_y(void) {return new_screen_y;}
    void set_new_screen_pos(int x, int y){new_screen_x=x; new_screen_y=y;}
    
    void reset_to_start(void);
    void play_dying(void);
    
    void set_max_speed(float _max_speed) {max_speed = _max_speed;}
    
    void reset(void);
    
    void startJump(float power);
    void moveJump(void);    
    bool moveLeft(CMap *map);       //returns true if it hit something
    bool moveRight(CMap *map);     //returns true if it hit something
    void moveUp(CMap *map);
    void moveDown(CMap *map, CMapObjects *objects, CParts *parts);
    void checkColWithPlatforms(CMapObjects *objects);
    
    void startCharge1(void);
    void stopCharge1(void);
    void stopCharging(void);
    
    void moveEnim(void);
    bool retDucked(void) {return ducked;}
    TSkills* retSkills(void) {return &skills;}

};



#endif
