#include <allegro.h>
#include <string.h>
#include <math.h>
#include "aldumb.h"
#include "standards.h"
#include "rotk2.h"
#include "sounds.h"

#include "CAnim.h"


void CAnim::destroy(void)
{
    if(data)
    {
        //unload_datafile(data);
        
       /* if(hardware_accel==true)
        {
            for(int n=0 ; n<number_of_frames-1 ; n++)
                destroy_bitmap(frames[n]);
        }*/
    }
}

BITMAP* CAnim::return_current_frame(void)
{
    if(hardware_accel==true)
        return frames[current_frame];
    else
        return (BITMAP*)data[current_frame].dat;
}

BITMAP* CAnim::return_frame(int n)
{
    if(n>=0 && n<number_of_frames )
    {
        if(hardware_accel==true)
            return frames[n];
        else
            return (BITMAP*)data[n].dat;
    }
    return NULL;
}

int CAnim::move(void)
{
    int ret=-1;     //-1 means playing normally
    if(stopped==false)
    {
        if(countdown>0)
            countdown--;
        else
        {
            if(current_frame<=p2)
                current_frame++;
            countdown=frame_wait;
        }
        if(current_frame>p2)
        {
            if(np1!=-1 && np2!=-1)  //there are new anim bounds waiting
            {
                p1 = np1;
                p2 = np2;
                np1=-1; np2=-1;
            }
        
            ret=1;      //1 means its at the end of the animation
            
            if(looping==true)
                current_frame=p1;
            else
                current_frame=p2;
        }
    }
    return ret;
}

void CAnim::draw(BITMAP *backgr, float x, float y)
{
    if(exist==true)
    {
        if(hardware_accel==true)
        {
            //FOR THE VIDEO ACCEL
            draw_sprite(backgr,frames[current_frame],(int)x,(int)y);
        }
        else
            draw_sprite(backgr,(BITMAP*)data[current_frame].dat,(int)x,(int)y);
    }
}

int CAnim::ret_first_w(void)
{
    if(exist==true)
    {
        return ((BITMAP*)data[current_frame].dat)->w;
    }
}

int CAnim::ret_first_h(void)
{
    if(exist==true)
    {
        return ((BITMAP*)data[current_frame].dat)->h;
    }
}

int CAnim::ret_widest(void)
{
    return widest;
}

void CAnim::reset_anim(void) 
{
    p1=0; 
    p2=0; 
    current_frame=0;
    stopped=true;
}

void CAnim::create(char *filename)
{
    char data_name[50];

    FILE *fp=fopen(filename,"r");

    if(fp)
    {
        fscanf(fp,"%d ",&number_of_frames);
        fscanf(fp,"%d ",&frame_wait);
        fscanf(fp,"%s ",data_name);
        fscanf(fp,"%d %d",&p1, &p2);    //the frames to play between by default
        
        data=load_datafile(data_name);
        //number_of_frames=0;

    

//FOR WORKING WITH VIDEO ACCEL

if(hardware_accel==true)
{
        while(data[number_of_frames].dat)
            number_of_frames++;
            
        frames = new(BITMAP*)[number_of_frames];
        for(int n=0 ; n<number_of_frames ; n++)
        {
            frames[n] = create_video_bitmap(((BITMAP*)data[n].dat)->w,((BITMAP*)data[n].dat)->h);
            blit((BITMAP*)data[n].dat,frames[n],0,0,0,0,frames[n]->w,frames[n]->h);
        }
}

        countdown=frame_wait;
        current_frame=p1;

        exist=true;
    }

    widest=0;
    for(int n=0 ; n<number_of_frames ; n++)
    {
        if( ((BITMAP*)data[n].dat)->w > widest)
            widest = ((BITMAP*)data[n].dat)->w;
    }

    fclose(fp);
}

void CAnim::set_bounds(int _p1, int _p2)
{
    if(_p1!=-1)
        p1=_p1;
    if(_p2!=-1)
        p2=_p2;
}

//sets the bounds to play between when the current anim cycle is finsihed
void CAnim::set_new_bounds(int _p1, int _p2)
{
    //if(_p1!=-1)
        np1=_p1;
    //if(_p2!=-1)
        np2=_p2;
}

CAnim::CAnim(void)
{
    current_frame=0;
}

void CAnim::init(void)
{
    exist=false;
    stopped=false;
    looping=true;
    p1=0; p2=0; np1=-1; np2=-1;
    readyforanim=true;
    widest=0;
    current_frame=0;
}

CAnim::~CAnim(void)
{
}
