/////////////////////////////////////////////////////////////////////
// BinPong by Andrew Pike (www.fifsoft.com)
// v1.0

#include <stdio.h>
#include <dos.h>
#include <time.h>
#include <allegro.h>
#include "pongdat.h"

#ifdef __MSDOS__
#define BP_WINDOWS_MODE 0
#else
#define BP_WINDOWS_MODE 1
#endif

#define DEBUG 0

volatile int speed_counter = 0;
void increment_speed_counter()
{
   speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter);

class cBinPong
{
private:
   BITMAP *bk;
   DATAFILE *pongdat;

   int Map[10][8];

   // Game Vars

   int bx, by;      // Ball..
   float bx1, by1;
   int bangle, bdir;

   int px;          // ..and the paddle
   float px1;

   int act_score, cur_score;
   int lives;

   int mn;
   char message[200];
   int level;

   int other, other2, sleft;
   int tx, tbx, ty;
   int c1, c2;

public:
   cBinPong(void);
   ~cBinPong(void);
   int Init(void);
   int SetVideo(void);
   void Intro(void);
   int Start(void);

   void NewMap(void);

   void LoadHiScore(void);
   void SaveHiScore(void);

   void Draw(void);
   void Calc(void);

   long int HiScore;

	struct RGB *p;
};

void PlaySnd(SAMPLE *snd);
int SndFx;

/////////////////////////////////////////////////////////////////////
// Main

#if BP_WINDOWS_MODE
int RunGame(void)
#else
int main(void)
#endif
{
   cBinPong *BinPong;

#if !BP_WINDOWS_MODE
   printf("Welcome to BinPong..\n");
#endif
   
	allegro_init();
   install_keyboard();
   install_timer();
   reserve_voices(4,4);
   if (install_sound(DIGI_AUTODETECT, MIDI_NONE,"hi")!=0)
      SndFx=0;
   else
      SndFx=1;

   LOCK_VARIABLE(speed_counter);
   LOCK_FUNCTION(increment_speed_counter);

   install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));

   // Create
   BinPong=new cBinPong;

   // Init
   if (!BinPong->Init())
      return 1;
   if (!BinPong->SetVideo())
      return 1;

   // Intro
   BinPong->Intro();

   // Start Game
   while (BinPong->Start())
      ;

   // The End.
   delete BinPong;

   allegro_exit();
#if !BP_WINDOWS_MODE
   printf("You have played another tasteless game by FIFSOFT\n");
   printf("www.fifsoft.com\n");
#endif
	return 0;
}

/////////////////////////////////////////////////////////////////////
// PlaySnd

void PlaySnd(SAMPLE *snd)
{
   if (SndFx)
      play_sample(snd, 255, 128, 1000, FALSE);
}

/////////////////////////////////////////////////////////////////////
// cBinPong

cBinPong::cBinPong(void)
{
   bk=NULL;
   pongdat=NULL;
}

/////////////////////////////////////////////////////////////////////
// ~cBinPong

cBinPong::~cBinPong(void)
{
   if (bk)
      destroy_bitmap(bk);
   if (pongdat)
      unload_datafile(pongdat);
}

/////////////////////////////////////////////////////////////////////
// Init

int cBinPong::Init(void)
{
   time_t t;

   bk=create_bitmap(320,200);
   if (!bk)
   {
#if !BP_WINDOWS_MODE
      printf("Error creating bitmap. (bk)\n");
#endif
      return 0;
   }

   pongdat=load_datafile("pongdat.dat");
   if (!pongdat)
   {
#if !BP_WINDOWS_MODE
      printf("Error loading datafile PONGDAT.DAT.\n");
#endif
      return 0;
   }

   LoadHiScore();

   srand((unsigned) time(&t));

   return 1;
}

/////////////////////////////////////////////////////////////////////
// LoadHiScore

void cBinPong::LoadHiScore(void)
{
   FILE *fp;

   fp=fopen("bin.cfg","rb");
   if (fp!=NULL)
   {
      fread(&HiScore,4,1,fp);
      fclose(fp);
   }
   else
      HiScore=1000;
}

/////////////////////////////////////////////////////////////////////
// SaveHiScore

void cBinPong::SaveHiScore(void)
{
   FILE *fp;

   fp=fopen("bin.cfg","wb");
   if (fp!=NULL)
   {
      fwrite(&HiScore,4,1,fp);
      fclose(fp);
   }
}

/////////////////////////////////////////////////////////////////////
// SetVideo

int cBinPong::SetVideo(void)
{
#if BP_WINDOWS_MODE
   if (set_gfx_mode(GFX_AUTODETECT, 320, 200, 0, 0))
#else
   if (set_gfx_mode(GFX_VGA, 320, 200, 0, 0))
#endif
   {
#if !BP_WINDOWS_MODE
      printf("Problem with GFX_VGA video.\n");
#endif
      return 0;
   }

   return 1;
}

/////////////////////////////////////////////////////////////////////
// Intro

void cBinPong::Intro(void)
{
	p=(struct RGB*)pongdat[TITLEPAL].dat;
   set_palette(p);
   blit((BITMAP*)pongdat[TITLE].dat, screen, 0,0,0,0, 320,200);
   clear_keybuf();
   readkey();
	p=(struct RGB*)pongdat[THEPAL].dat;
}

/////////////////////////////////////////////////////////////////////
// Start

int cBinPong::Start(void)
{
   char k;

   set_palette(p);

   // InIt!!!

   px=145;
   bx=140;
   by=60;
   bangle=0;
   bdir=1;

   bx1=0;
   by1=2;
   px1=0;

   NewMap();

   act_score=0;
   cur_score=0;
   lives=10;
   text_mode(-1);
   mn=1;
   level=1;
   sprintf(message,"Level %d",level);
   speed_counter=0;

   // LoOp!!!

   while (!key[KEY_ESC])
   {
      while(speed_counter>0)
      {
         Calc();
         speed_counter--;
      }
      Draw();

      if (lives<=0)
         break;
   }

   PlaySnd((SAMPLE*)pongdat[SND_END].dat);

   clear_keybuf();
   rectfill(screen,60,30,260,100,14);
   rect(screen,60,30,260,100,0);

//   textprintf(screen,font,130,40,0,"Game Over");
//   textprintf(screen,font,115,50,0,"Your score: %d",act_score);
//   textprintf(screen,font,120,60,0,"Level: %d",level);
//   textprintf(screen,font,105,80,0,"Play again? Y/N");

   textout_centre(screen, font, "Game Over", 160, 40, 0);
   sprintf(message,"Your score: %d", act_score);
   textout_centre(screen, font, message, 160, 50, 0);
   sprintf(message,"Level: %d",level);
   textout_centre(screen, font, message, 160, 60, 0);
   textout_centre(screen, font, "Play again? Y/N", 160, 80, 0);

   if (act_score>HiScore)
   {
      HiScore=act_score;
      SaveHiScore();
   }

   clear_keybuf();
   k=readkey();
   while (k!='Y' && k!='y' && k!='n' && k!='N')
      k=readkey();
   if (k=='Y' || k=='y')
      return 1;

   return 0;
}

/////////////////////////////////////////////////////////////////////
// NewMap

void cBinPong::NewMap(void)
{
   int c1, c2;

   for (c1=0;c1<10;c1++)
      for (c2=0;c2<8;c2++)
         Map[c1][c2]=0;

   for (c1=0;c1<20;c1++)
   {
      Map[(rand()%10)][(rand()%8)]=1+(rand()%14);
   }

   Map[9][0]=0;
}

/////////////////////////////////////////////////////////////////////
// Draw

void cBinPong::Draw(void)
{
   int rangle;

      //**// DrAw!!! ///////////////////////////////

      blit((BITMAP*)pongdat[BACKGROUND].dat, bk, 0,0,0,0, 320,200);

      // Squares

      sleft=0;
      for (c1=0;c1<10;c1++)
      {
         for (c2=0;c2<8;c2++)
         {
            if (Map[c1][c2])
            {
               tx=c1*32;
               ty=c2*16;
               rect(bk, tx+2, ty+2, tx+32, ty+16, Map[c1][c2]);

//               rectfill(bk, c1*32, c2*16, (c1+1)*32, (c2+1)*16, Map[c1][c2]);
//               draw_sprite(bk, (BITMAP*)pongdat[STAR].dat, c1*32, c2*16);
            }
         }
      }

      // Paddle
//      draw_sprite(bk, (BITMAP*)pongdat[PADDLE].dat, px, 180);
      draw_sprite(bk, (BITMAP*)pongdat[PADDLE].dat, px-7, 156);

      // Ball
      rangle=(int)(((float)(bangle-90)/360)*256);
      rotate_sprite(bk, (BITMAP*)pongdat[BALL].dat, bx-10, by-10, itofix(rangle));
//      draw_sprite(bk, (BITMAP*)pongdat[BALL].dat, bx-20, by-20);

#if DEBUG
      putpixel(bk, bx+20, by+20, 10);
      putpixel(bk, bx, by, 10);
      putpixel(bk, bx+40, by, 10);
      putpixel(bk, bx+40, by+40, 10);
      putpixel(bk, bx, by+40, 10);
#endif

      // Text
#if DEBUG
      textprintf(bk, font, 2, 2, 14, "ball=%.1f,%.1f", bx1, by1);
      textprintf(bk, font, 2, 12, 14, "paddle=%.1f", px1);
      textprintf(bk, font, 2, 22, 14, "tbx=%d tx=%d other=%d other2=%d", tbx, tx, other, other2);
#endif

      if (mn>0)
         textout_centre(bk, font, message, 160, 95, 14);

      textprintf(bk, font, 2, 2, 14, "Score %d", cur_score);
      if (act_score>cur_score)
         cur_score++;

      textprintf(bk, font, 2, 12, 14, "Hi    %ld", HiScore);

      for (c1=0;c1<lives;c1++)
      {
         draw_sprite(bk, (BITMAP*)pongdat[STAR].dat, (c1*18)+2, 22);
      }

      blit(bk, screen, 0,0,0,0, 320,200);
}

/////////////////////////////////////////////////////////////////////
// Calc

void cBinPong::Calc(void)
{
      //**// CaLc!!! ///////////////////////////////

      // Paddle

      if (key[KEY_LEFT] && px1>-7 && px>0)
         px1--;
      if (key[KEY_RIGHT] && px1<7 && px<270)
         px1++;

      if (px1>0)
         px1-=0.5;
      if (px1<0)
         px1+=0.5;

      if (px1!=0)
         px+=(int)px1;

      // Ball

      sleft=0;
      for (c1=0;c1<10;c1++)
      {
         for (c2=0;c2<8;c2++)
         {
            if (Map[c1][c2])
            {
               tx=(c1*32)+2;
               ty=(c2*16)+2;

               // Left Side of object

//               if (tx<bx+40 && tx>bx && bx1>0 && ty+16<by+40 && ty>by)
               if (tx<bx+40 && tx>bx && bx1>0 && by<ty+16 && by+40>ty)
               {
                  Map[c1][c2]=0;
                  bx1=-bx1;
               }

               // Right Side of object

//               if (tx+32<bx+40 && tx+32>bx && bx1<0 && ty+16<by+40 && ty>by)
               if (tx+32<bx+40 && tx+32>bx && bx1<0 && by<ty+16 && by+40>ty)
               {
                  Map[c1][c2]=0;
                  bx1=-bx1;
               }

               // Top of object

//               if (ty<by+40 && ty>by && by1>0 && tx+32<bx+40 && tx>bx)
               if (ty<by+40 && ty>by && by1>0 && bx<tx+32 && bx+40>tx)
               {
                  Map[c1][c2]=0;
                  by1=-by1;
               }

               // Bottom of object

//               if (ty+16<by+40 && ty+16>by && by1<0 && tx+32<bx+40 && tx>bx)
               if (ty+16<by+40 && ty+16>by && by1<0 && bx<tx+32 && bx+40>tx)
               {
                  Map[c1][c2]=0;
                  by1=-by1;
               }

               if (Map[c1][c2]==0)
               {
                  act_score+=25;
                  PlaySnd((SAMPLE*)pongdat[SND_HIT].dat);
               }
               else
                  sleft++;
            }
         }
      }

      if (bdir==1)
         bangle+=5;
      else
         bangle-=5;

      if (bangle<0)
         bangle=360;
      else if (bangle>360)
         bangle=0;

      if (bx1!=0)
         bx+=(int)bx1;
      if (by1!=0)
         by+=(int)by1;

      if (by>180)
      {
         bx=140;
         by=60;
         bx1=0;
         by1=2;
         lives--;
         PlaySnd((SAMPLE*)pongdat[SND_MISS].dat);
      }

      if (bx>280 && bx1>0)
      {
         bx1=-bx1;
         PlaySnd((SAMPLE*)pongdat[SND_WALL].dat);
      }
      if (bx<0 && bx1<0)
      {
         bx1=-bx1;
         PlaySnd((SAMPLE*)pongdat[SND_WALL].dat);
      }
      if (by<0 && by1<0)
      {
         by1=-by1;
         PlaySnd((SAMPLE*)pongdat[SND_WALL].dat);
      }

      if (by>140 && bx+25>px && bx<px+40 && by1>=0)
      {
         PlaySnd((SAMPLE*)pongdat[SND_BOUNCE].dat);
         bdir=-bdir;
         tbx=bx;
         other=bx;
         other2=px;
         if (tbx+15<=px)
            tbx=px-14;
         if (tbx>=px+25)
            tbx=px+24;

         by1=-by1;
         tx=(((tbx+20)-px)-25)/3;
         bx1=tx;

         if (tx>=8)
            tx=7;
         if (tx<=-8)
            tx=-7;

         if (tx>0)
            by1=-(4-(tx-4));
         else if (tx<0)
            by1=-(4+(tx+4));
         else if (tx==0)
            by1=-8;
      }

      if (sleft==0)
      {
         mn=1;
         level++;
         sprintf(message,"Level %d",level);
         NewMap();
      }

      if (mn>0)
      {
         mn++;
         if (mn>100)
            mn=0;
      }

      // Key

      if (key[KEY_P])
      {
         textout_centre(screen,font,"PAUSE",160,110,15);
         clear_keybuf();
         readkey();
      }

      if (key[KEY_S])
      {
         save_pcx("out.pcx",screen,p);
      }
}
