/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "gengrap.h"
#include "clip.h"

void slowpoly(float *x, float *y, float *z, float *u, float *v, int flag, TEXTURE *tex)
{
	float	ul, vl, zl, xl, ydifl;
	float	uladd, vladd, zladd, xladd;
	float	ur, vr, zr, xr, ydifr;
	float	uradd, vradd, zradd, xradd;
	float	topval, bottomval, scy, tz;
	float	lineu, linev, linez, lineuadd, linevadd, linezadd, len;
	int	sy, test, target, end, top, bottom, vertr, vertl, linelen;
	unsigned char	*ptr2;
	unsigned long pptr;
	float	*dptr;

	acquire_bitmap(boardonly->image);
	bmp_select(boardonly->image);
	top = 0;
	topval = y[0];

	if(y[1] < y[0])
	{
		top = 1;
		topval = y[1];
	}

	if(y[2] < y[top])
	{
		top = 2;
		topval = y[2];
	}

	bottom = 0;
	bottomval = y[0];

	if(y[1] > y[0])
	{
		bottom = 1;
		bottomval = y[1];
	}

	if(y[2] > y[bottom])
	{
		bottom = 2;
		bottomval = y[2];
	}

	xl = xr = x[top];
	zl = zr = 1.0f    / z[top];
	ul = ur = u[top]  * zl;
	vl = vr = v[top]  * zl;
	scy     = y[top];
	sy      = (int)(scy);

	vertl = top + 1;
	vertr = top - 1;

	valid_range(vertl);
	valid_range(vertr);

	ydifl  = y[vertl] - scy;
	if(ydifl)
	{
		ydifl  = 1.0f / ydifl;
		zladd  = 1.0f / z[vertl];

		uladd  = ((u[vertl] * zladd) - ul) * ydifl;
		vladd  = ((v[vertl] * zladd) - vl) * ydifl;
		zladd  = (zladd              - zl) * ydifl;
		xladd  = (x[vertl]           - xl) * ydifl;
	}
	else
	{
		xl = x[vertl];
		zl = 1.0f / z[vertl];
		ul = u[vertl] * zl;
		vl = v[vertl] * zl;

		uladd  = 
		vladd  = 
		zladd  = 
		xladd  = 0;
	}
	
	target = (int)(y[vertl]);

	ydifr  = y[vertr] - scy;
	
	if(ydifr)
	{
		ydifr  = 1.0f / ydifr;
		zradd  = 1.0f / z[vertr];

		uradd  = ((u[vertr] * zradd) - ur) * ydifr;
		vradd  = ((v[vertr] * zradd) - vr) * ydifr;
		zradd  = (zradd              - zr) * ydifr;
		xradd  = (x[vertr]           - xr) * ydifr;
	}
	else
	{
		xr = x[vertr];
		zr = 1.0f / z[vertr];
		ur = u[vertr] *zr;
		vr = v[vertr] *zr;

		uradd  = 
		vradd  = 
		zradd  = 
		xradd  = 0;
	}

	test = (int)(y[vertr]);

	if(test < target)
		target = test;

	end = (int)(y[bottom]);

	while(sy < end)
	{
		while(sy < target)
		{
			if(xl < xr)
			{
				lineu = ul;
				linev = vl;
				linez = zl;

				len = 1 + xr - xl;

				lineuadd = (ur - ul);
				linevadd = (vr - vl);
				linezadd = (zr - zl);

				pptr = bmp_write_line(boardonly->image, sy);
				pptr += (int)(xl);
				ptr2 = &mouseover->line[sy][(int)(xl)];
				dptr = &boardonly->depth[(sy << SHIFT1) + (sy << SHIFT2) + (int)(xl)];
			}
			else
			{
				lineu = ur;
				linev = vr;
				linez = zr;

				len = 1 + xl - xr;

				lineuadd = (ul - ur);
				linevadd = (vl - vr);
				linezadd = (zl - zr);

				//ptr  = &boardonly->image->line[sy][(int)(xr)];
				pptr = bmp_write_line(boardonly->image, sy);
				pptr += (int)(xr);
				ptr2 = &mouseover->line[sy][(int)(xr)];
				dptr = &boardonly->depth[(sy << SHIFT1) + (sy << SHIFT2) + (int)(xr)];
			}

			if(len)
			{
				linelen	= (int)(len);
				len		= 1.0f / len;

				lineuadd *= len;
				linevadd *= len;
				linezadd *= len;

				while(linelen--)
				{
					if(linez >= *dptr)
					{
						tz = 1.0f / linez;

						if(flag != NOTSQUARE)
							*ptr2 = flag;

						bmp_write8(pptr, tex->line[(int)(linev*tz)&255][(int)(lineu*tz)&255]);
						*dptr = linez;
					}

					pptr++;
					ptr2++;
					dptr++;

					lineu += lineuadd;
					linev += linevadd;
					linez += linezadd;
				}
			}

			xl += xladd;
			vl += vladd;
			ul += uladd;
			zl += zladd;

			xr += xradd;
			vr += vradd;
			ur += uradd;
			zr += zradd;
			bmp_unwrite_line(boardonly->image);
			sy++;
		}

		if(target != end)
		{
			target = end;

			if(vertr == bottom)
			{
				xl = x[vertl];
				zl = 1.0f / z[vertl];
				ul = u[vertl] * zl;
				vl = v[vertl] * zl;

				ydifl  = y[bottom] - y[vertl];

				if(ydifl)
				{
					ydifl = 1.0f / ydifl;
					zladd = 1.0f / z[bottom];

					uladd  = ((u[bottom] * zladd) - ul) * ydifl;
					vladd  = ((v[bottom] * zladd) - vl) * ydifl;
					zladd  = (zladd               - zl) * ydifl;
					xladd  = (x[bottom]           - xl) * ydifl;
				}
			}
			else
			{
				xr = x[vertr];
				zr = 1.0f / z[vertr];
				ur = u[vertr] * zr;
				vr = v[vertr] * zr;

				ydifr  = y[bottom] - y[vertr];

				if(ydifr)
				{
					ydifr = 1.0f / ydifr;
					zradd = 1.0f / z[bottom];

					uradd  = ((u[bottom] * zradd) - ur) * ydifr;
					vradd  = ((v[bottom] * zradd) - vr) * ydifr;
					zradd  = (zradd               - zr) * ydifr;
					xradd  = (x[bottom]           - xr) * ydifr;
				}
			}
		}
	}
	release_bitmap(boardonly->image);
}

void doslowpoly(POLY *polygon)
{
	float x[3], y[3], z[3], u[3], v[3];
	VERTEX **lvert, *dvert;
	POLYDATA *ldata;

	if(check_reverse(	polygon->verts[0]->wx, polygon->verts[0]->wy, polygon->verts[0]->wz,
				polygon->verts[1]->wx, polygon->verts[1]->wy, polygon->verts[1]->wz,
				polygon->verts[2]->wx, polygon->verts[2]->wy, polygon->verts[2]->wz) < 0)
	{
		if(	polygon->verts[0]->awkward == FALSE &&
			polygon->verts[1]->awkward == FALSE &&
			polygon->verts[2]->awkward == FALSE)
		{
			lvert = &polygon->verts[0];
			ldata = &polygon->datas[0];
			dvert = *lvert;
			x[0] = dvert->sx;
			y[0] = dvert->sy;
			z[0] = dvert->wz;
			u[0] = ldata->u;
			v[0] = ldata->v;

			lvert++;
			ldata++;
			dvert = *lvert;
			x[1] = dvert->sx;
			y[1] = dvert->sy;
			z[1] = dvert->wz;
			u[1] = ldata->u;
			v[1] = ldata->v;

			lvert++;
			ldata++;
			dvert = *lvert;
			x[2] = dvert->sx;
			y[2] = dvert->sy;
			z[2] = dvert->wz;
			u[2] = ldata->u;
			v[2] = ldata->v;

			slowpoly(x, y, z, u, v, polygon->datas[0].c, polygon->tex);
		}
		else
			clipslowpoly(polygon);
	}
}

void renderscene(void)
{
	int count, x, y;
	unsigned long rptr;
	float *dptr;
	BITMAP *logo;

	acquire_bitmap(boardonly->image);
	bmp_select(boardonly->image);
	logo = globdata[SLOGO].dat;

	draw_sprite(boardonly->image, logo, WIDTH-logo->w, HEIGHT-logo->h);
	for(y = HEIGHT-logo->h; y < HEIGHT; y++)
	{
		rptr = bmp_read_line(boardonly->image, y);
		rptr += WIDTH-logo->w;
		dptr = &boardonly->depth[(y << SHIFT1) + (y << SHIFT2) + (WIDTH-logo->w)];

		for(x = WIDTH-logo->w; x < WIDTH; x++)
		{
			if(bmp_read8(rptr))
			{
				*dptr = 1;
			}

			dptr++;
			rptr++;
		}

		bmp_unwrite_line(boardonly->image);
	}
	count = map.numverts;

	while(count--)
	{
		apply_matrix_f(&map.cam->vision,	 map.verts[count].x,   map.verts[count].y,   map.verts[count].z,
								&map.verts[count].wx, &map.verts[count].wy, &map.verts[count].wz);

		if(	(check_against_plane(&map.verts[count], &cplanes[0]) > 0) &&
			(check_against_plane(&map.verts[count], &cplanes[1]) > 0) &&
			(check_against_plane(&map.verts[count], &cplanes[2]) > 0) &&
			(check_against_plane(&map.verts[count], &cplanes[3]) > 0) &&
			(check_against_plane(&map.verts[count], &cplanes[4]) > 0))
		{
			persp_project_f(	 map.verts[count].wx,  map.verts[count].wy,  map.verts[count].wz,
						&map.verts[count].sx, &map.verts[count].sy);

			map.verts[count].awkward = FALSE;
		}
		else
			map.verts[count].awkward = TRUE;
	}

	count = map.numpolys;

	while(count--)
		doslowpoly(&map.polys[count]);
	release_bitmap(boardonly->image);
}
