/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"

int mod_prob_blob(void *chrmdl)
{
	return 9;
}

int mod_prob_normal(void *chrmdl)
{
	float tempval;
	int chaosdif, chaosrat;
	CHARACTER_MODEL *mdl;

	mdl = (CHARACTER_MODEL *)chrmdl;
	chaosrat = ptr_chaos_rating(mdl);

	chaosdif = 0;

	if((chaoslaw < 0 && chaosrat < 0) || (chaoslaw > 0 && chaosrat > 0))
	{
		chaosdif = abs(chaoslaw) - abs(chaosrat);
     
		if(chaosdif < 0)
			chaosdif = 0;

		if(chaosdif > 5)
			chaosdif = 5;
	}

	if(chaosrat == 0)
		chaosdif = 3;


	tempval = (float)(93 -	(5  *  ptr_attack_rating(mdl)	) -
					(5  *  ptr_defense_rating(mdl)	) -
					(2  *  ptr_mount(mdl)		) -
					(2  *  ptr_flying(mdl)		) -
					(2  *  ptr_undead(mdl)		) +
					(10  *  chaosdif				)) / 9.6f;

	if(tempval < 1)
		tempval = 1;

	if(tempval > 10)
		tempval = 10;

	return (int)tempval;
}

int mod_prob_hundred(void *chrmdl)
{
	return 10;
}

int probability(int x)
{
	return allchars[x].probfunc(&allchars[x]);
}
