/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "logic.h"
#include "movefunc.h"
#include "gengrap.h"
#include "human.h"
#include "compfunc.h"

void move_from(int sqx, int sqy, float moves, int diags, int last, CHARACTER *me)
{
	int pos;
   
	pos = xy(sqx, sqy);

	if(diags == 2)
	{
		moves--;
		diags = 0;
	}
        
	if(	((board[pos].chr == NULL || !(board[pos].chr->dead & LMASK)) || board[pos].chr == me) &&
		moves >= board[pos].dist)
	{
		board[pos].check = ONTO;
		board[pos].diags = diags;
		board[pos].dist = moves;
		board[pos].last = last;

		moves--;

		if(moves >= 0)
		{
			if(sqx + 1 < bwidth)
			{
				move_from(sqx+1, sqy, moves, diags, pos, me);

				if(sqy + 1 < bheight)
					move_from(sqx+1, sqy+1, moves, diags+1, pos, me);
           
				if(sqy - 1 >= 0)
					move_from(sqx+1, sqy-1, moves, diags+1, pos, me);
			}

			if(sqx - 1 >= 0)
			{
				move_from(sqx-1, sqy, moves, diags, pos, me);

				if(sqy + 1 < bheight)
					move_from(sqx-1, sqy+1, moves, diags+1, pos, me);
           
				if(sqy - 1 >= 0)
					move_from(sqx-1, sqy-1, moves, diags+1, pos, me);
			}

			if(sqy + 1 < bheight)
				move_from(sqx, sqy+1, moves, diags, pos, me);
        
			if(sqy - 1 >= 0)
				move_from(sqx, sqy-1, moves, diags, pos, me);
		}
	}
}

void mod_move_search_squares_fly(CHARACTER *chr)
{
	int count, difx, dify, pos;

	pos = xy(chr->sqx, chr->sqy);

	count = numbsquares;
	while(count--)
		if(board[count].chr != NULL)
			if((board[count].chr->dead & LMASK) && ((board[count].chr->owner & 127) != (chr->owner & 127)))
				board[count].chr->moves = check_engaged_with(chr, count);

	count = numbsquares;
	while(count--)
	{
		board[count].check = 0;
		difx = board[count].sq_x - chr->sqx;
		dify = board[count].sq_y - chr->sqy;
      
		if((sqroot[difx*difx + dify*dify] <= (float)(chr->moves) + 0.5f))
		{
			board[count].dist	= chr->moves - (int)sqroot[difx*difx + dify*dify];
			board[count].last	= pos;

			board[count].check	= ONTO;

			if(board[count].chr != NULL)
				if((board[count].chr->owner & 127) != (chr->owner & 127) && (board[count].chr->dead&LMASK))
					board[count].check = ATTACK;
		}
	}

	count = numbsquares;
	while(count--)
	{
		if(board[count].chr != NULL)
			if((board[count].chr->dead & LMASK) && (board[count].chr->owner & 127) != (chr->owner & 127) && (abs(board[count].sq_x - chr->sqx) <= 1) && (abs(board[count].sq_y - chr->sqy) <= 1))
				board[count].check = ATTACK;
	}
}

void mod_move_search_squares_walk(CHARACTER *chr)
{
	int count, pos;

	pos = xy(chr->sqx, chr->sqy);

	count = numbsquares;
	while(count--)
		if(board[count].chr != NULL)
			if((board[count].chr->dead & LMASK) && ((board[count].chr->owner & 127) != (chr->owner & 127)))
				board[count].chr->moves = check_engaged_with(chr, count);

	count = numbsquares;
	while(count--)
	{
		board[count].check = 0;
		board[count].dist = 0;
	}
	move_from(chr->sqx, chr->sqy, chr->moves, chr->diags, pos, chr);

	count = numbsquares;
	while(count--)
	{
		if(board[count].chr != NULL)
			if((board[count].chr->dead & LMASK) && (board[count].chr->owner & 127) != (chr->owner & 127) && (abs(board[count].sq_x - chr->sqx) <= 1) && (abs(board[count].sq_y - chr->sqy) <= 1))
				board[count].check = ATTACK;
	}
}

void mod_move_fillin_rest(CHARACTER *chr)
{
	CHARACTER *cchr;
	int pos;
	cchr = &person[wizard[chr->owner & 127]];
	while(cchr)
	{
		if(cchr->dead & LMASK && !ptr_static(cchr->model))
		{
			pos = xy(cchr->sqx, cchr->sqy);

			if(cchr->dead & LMASK)
			{
				if(cchr->moves)
					board[pos].check = TEAMEN;
				else
					board[pos].check = TEAMTI;
			}
		}

		cchr = cchr->next;
	}
}

int mod_move_attack(int sqx, int sqy, int sqid)
{
	if(!(mover->attacked & 1))
	{
		attack(mover, mouse_on, FALSE);
		mover->attacked |= 1;
		mover->moves = 0;
		clear_checks();
		mover->model->setup_move(mover);
		mod_move_fillin_rest(mover);
		//mod_move_change_creature(mover->sqx, mover->sqy, xy(mover->sqx, mover->sqy));
	}

	return 0;
}

int mod_move_change_creature(int sqx, int sqy, int sqid)
{
	CHARACTER *chr;
	//int pos;

	mover = chr = board[sqid].chr;
	point_camera_at(mover);
	fix_light();
	draw_other_players();
	draw_other_creations(mover);
	clear_checks();
	
	clear_functable();
	functable[TEAMTI] =
	functable[TEAMEN] = mod_move_change_creature;
	
	chr->model->setup_move(chr);
	mod_move_fillin_rest(chr);

	board[sqid].check = CURRENT;
	
	return 0;
}

int mod_move_creature(int sqx, int sqy, int sqid)
{
	play_sample(globdata[Bleep].dat, 255, 127, 1000, FALSE);
	move_model(sqx, sqy, mover, TRUE);
	fix_light();
	clear_checks();
	mover->model->setup_move(mover);
	mod_move_fillin_rest(mover);
	//mod_move_change_creature(sqx, sqy, sqid);
	
	return 0;
}

int mod_move_setup_walker(void *chr)
{
	mod_move_search_squares_walk((CHARACTER *)chr);
	functable[ATTACK]	= mod_move_attack;
	functable[GREEN]	= mod_move_creature;
	functable[BLUE]	=
	functable[SPECKEY]	= NULL;
	return 0;
}

int mod_move_setup_fly(void *chr)
{
	mod_move_search_squares_fly((CHARACTER *)chr);
	functable[ATTACK]	= mod_move_attack;
	functable[GREEN]	= mod_move_creature;
	functable[BLUE]	=
	functable[SPECKEY]	= NULL;
	return 0;
}

void mod_move_humanmain(void)
{
	mod_move_change_creature(mover->sqx, mover->sqy, xy(mover->sqx, mover->sqy));
	do_boardview(NULL);
}

void check_attack(CHARACTER *chr)
{
	#define check_square(x,y) {pos=xy(x,y);if(board[pos].chr != NULL){ if(board[pos].chr->dead&LMASK && (board[pos].chr->owner&127)!=currentwiz) cpos = pos;}}
	int pos, cpos;

	cpos = -1;
	if(mover->sqx - 1 >= 0)
	{
		check_square(mover->sqx-1, mover->sqy);

		if(mover->sqy - 1 >= 0)
			check_square(mover->sqx-1, mover->sqy-1);

		if(mover->sqy + 1 < bheight)
			check_square(mover->sqx-1, mover->sqy+1);
	}

	if(mover->sqx + 1 < bwidth)
	{
		check_square(mover->sqx+1, mover->sqy);

		if(mover->sqy - 1 >= 0)
			check_square(mover->sqx+1, mover->sqy-1);

		if(mover->sqy + 1 < bheight)
			check_square(mover->sqx+1, mover->sqy+1);
	}

	if(mover->sqy - 1 >= 0)
		check_square(mover->sqx, mover->sqy-1);

	if(mover->sqy + 1 < bheight)
		check_square(mover->sqx, mover->sqy+1);

	if(cpos != -1)
	{
		attack(mover, board[cpos].chr, FALSE);
	}

//	return 0;
	#undef check_square
}

int mod_move_compmove_stage2_hard(void *chr)
{
	int lscore, lone, c;
	c = numbsquares;
	lone = lscore = -1;
	while(c--)
	{
		if(board[c].check == ONTO)
		{
			if((board[c].data > lscore || lscore == -1) && rand()%3)
			{
				lscore = board[c].data;
				lone = c;
			}
		}
	}

	if(lone != -1 && lscore > 0 && lscore != board[xy(mover->sqx, mover->sqy)].data)
	{
		play_sample(globdata[Bleep].dat, 255, 127, 1000, FALSE);
		move_model(board[lone].sq_x, board[lone].sq_y, mover, TRUE);
		check_attack(mover);
	}

	return 0;
}

int mod_move_compmove_stage2_coward(void *chr)
{
	int lscore, lone, c;
	c = numbsquares;
	lone = -1;
	lscore = 0;
	while(c--)
	{
		if(board[c].check == ONTO)
		{
			if((board[c].data < lscore || !lscore) && rand()%3)
			{
				lscore = board[c].data;
				lone = c;
			}
		}
	}

	if(lone != -1 && lscore != board[xy(mover->sqx, mover->sqy)].data)
	{
		play_sample(globdata[Bleep].dat, 255, 127, 1000, FALSE);
		move_model(board[lone].sq_x, board[lone].sq_y, mover, TRUE);
		check_attack(mover);
	}

	return 0;
}

int mod_move_compmove_walker(void *chr)
{
	mover = (CHARACTER *)chr;
	mod_move_search_squares_walk((CHARACTER *)chr);
	mod_move_fillin_rest((CHARACTER *)chr);
	if(mover->owner & 128)
		mod_move_compmove_stage2_coward(chr);
	else
		mod_move_compmove_stage2_hard(chr);

	return 0;
}

int mod_move_compmove_fly(void *chr)
{
	mover = (CHARACTER *)chr;
	mod_move_search_squares_fly((CHARACTER *)chr);
	mod_move_fillin_rest((CHARACTER *)chr);
	mod_move_compmove_stage2_hard(chr);

	return 0;
}

void mod_move_compmain(void)
{
	CHARACTER *cchr;
	int wizcount, sqcount;

	sqcount = numbsquares;
	while(sqcount--)
	{
		board[sqcount].data = 0;
	}

	wizcount = numwizards;
	while(wizcount--)
	{
		cchr = &person[wizard[wizcount]];
		if(wizcount != currentwiz)
		{
			plot_movement_circle(7, 31, cchr->sqx, cchr->sqy, 1);
			while(cchr)
			{
				if(cchr->dead & LMASK)
					cchr->model->taint(cchr);
				cchr = cchr->next;
			}
		}
		else
		{
			while(cchr)
			{
				if(cchr->dead & LMASK)
					cchr->model->untaint(cchr);
				cchr = cchr->next;
			}
		}
	}

	fix_light();
	draw_other_players();
	cchr = &person[wizard[currentwiz]];
	while(cchr)
	{
		if(cchr->dead & LMASK && !ptr_static(cchr->model))
		{
			clear_checks();
			draw_other_creations(cchr);
			cchr->model->computer_move(cchr);
		}
		cchr = cchr->next;
	}
}