/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "gengrap.h"
#include "main.h"
#include "logic.h"
#include "chfileio.h"
#include "probfunc.h"

void illusion_animation(CHARACTER *defender)
{
	int realcwiz;
	CAMERA deadview;
	CHARACTER *omover, *chr;

	fix_light();

	omover = mover;
	mover = defender;

	backup_camera();
                           
	deadview.x = mover->x;
	deadview.y = mover->y + 60;
	deadview.z = mover->z + 10;
	deadview.inx = 0;
	deadview.iny = -1;
	deadview.inz = 0;
	deadview.upx = 0;
	deadview.upy = 0;
	deadview.upz = 1;
	deadview.fov = 60;
	set_up_camera(&deadview);
	set_camera(&deadview, 1);
   
	realcwiz = currentwiz;
	currentwiz = defender->owner & 127;
	draw_other_players();
	draw_other_creations(mover);
	
	while(defender->y < 60)
	{
		defender->y += 10;
		draw_realtime_scene();
	}
     
	chr = &person[wizard[currentwiz]];
	while(chr->next != defender)
		chr = chr->next;

	board[xy(defender->sqx, defender->sqy)].chr = defender->square;
	chr->next = chr->next->next;

	revert_to_last_camera(1);
	currentwiz = realcwiz;
	mover = omover;
	draw_other_players();
	draw_other_creations(mover);
}

void dead_animation(CHARACTER *attacker, CHARACTER *defender)
{
	int count, realcwiz;
	float vectx, vecty, vectz, targy, addang;
	int bounces;
	CAMERA deadview;
	CHARACTER *omover;

	fix_light();

	omover = mover;
	mover = defender;

	if(attacker)
	{
		vectx = 2*(mover->x - attacker->x);
		vecty = 2;
		vectz = 2*(mover->z - attacker->z);
	}
	else
	{
		vectx = 2*(mover->x - omover->x);
		vecty = 2;
		vectz = 2*(mover->z - omover->z);
	}

	backup_camera();
                           
	deadview.x = mover->x + vectx;
	deadview.y = mover->y + vecty;
	deadview.z = mover->z + vectz;
	deadview.inx = -vectx;
	deadview.iny = -vecty;
	deadview.inz = -vectz;
	deadview.upx = 0;
	deadview.upy = 1;
	deadview.upz = 0;
	deadview.fov = 60;
	set_up_camera(&deadview);
	set_camera(&deadview, 1);
   
	realcwiz = currentwiz;
	currentwiz = defender->owner & 127;
	draw_other_players();
	draw_other_creations(mover);
	count = 64;
	bounces = 3;

	vecty = 0;
	addang = 1;
	count = defender->model->numverts;
	count--;
	targy = defender->model->verts[count].y;
	while(count--)
		if(defender->model->verts[count].y > targy)
			targy = defender->model->verts[count].y;

	targy = defender->y - targy;

	while(bounces)
	{
		defender->y += vecty;
		defender->angle += addang;
		vecty -= 0.2;
		addang *= 1.2;
		
		if(defender->y <= targy && vecty < 0)
		{
			bounces--;
			vecty = -vecty;
			vecty *= 0.8;
		}
		
		draw_realtime_scene();
	}
     
	revert_to_last_camera(1);
	currentwiz = realcwiz;
	//draw_other_players();
	//draw_other_creations(mover);

	defender->dead &= ~LMASK;

	if((defender->owner & 128))
		kill_wizard(defender->owner & 127);

	defender->y = board[xy(defender->sqx, defender->sqy)].y;

	mover = omover;
	draw_other_players();
	draw_other_creations(mover);
}

int cast_creature(int sqx, int sqy, int sqid, int id, int force)
{
	int count;
	float vectx, vecty, vectz;
	char ret;
	PALETTE white;
	CAMERA castcam;

	count = 256;
	while(count--)
		white[count].r = white[count].g = white[count].b = 63;

	switch(rand()%4)
	{
		case 1 :
			vectx = 2*(mover->x - board[sqid].x);
			vecty = 2*(mover->y - board[sqid].y) - 10;
			vectz = 2*(mover->z - board[sqid].z);
                           
			castcam.x = mover->x - vectz;
			castcam.y = mover->y - vecty;
			castcam.z = mover->z + vectx;
			castcam.inx = vectz;
			castcam.iny = vecty;
			castcam.inz = -vectx;
			castcam.upx = 0;
			castcam.upy = 1;
			castcam.upz = 0;
			castcam.fov = 60;
			set_up_camera(&castcam);
			set_camera(&castcam, 1);
		break;

		case 2 :
			vectx = 5*(mover->x - board[sqid].x);
			vecty = 5*(mover->y - board[sqid].y) + 20;
			vectz = 5*(mover->z - board[sqid].z);

			castcam.x = mover->x + vectx;
			castcam.y = mover->y + vecty;
			castcam.z = mover->z + vectz;
			castcam.inx = -vectx;
			castcam.iny = -vecty;
			castcam.inz = -vectz;
			castcam.upx = 0;
			castcam.upy = 1;
			castcam.upz = 0;
			castcam.fov = 60;
			set_up_camera(&castcam);
			set_camera(&castcam, 1);
		break;

		case 3 :
			vectx = 3*(mover->x - board[sqid].x);
			vecty = 3*(mover->y - board[sqid].y);
			vectz = 3*(mover->z - board[sqid].z);

			castcam.x = mover->x - vectx;
			castcam.y = mover->y - vecty;
			castcam.z = mover->z - vectz;
			castcam.inx = vectx;
			castcam.iny = vecty;
			castcam.inz = vectz;
			castcam.upx = 0;
			castcam.upy = 1;
			castcam.upz = 0;
			castcam.fov = 60;
			set_up_camera(&castcam);
			set_camera(&castcam, 1);
		break;
	}

	fix_light();

	draw_other_players();
	draw_other_creations(mover);
	draw_realtime_scene();

	play_sample(globdata[Cast].dat, 255, 127, 1000, FALSE);

	fade_from(mainpal, white, 10);

	count = rand()%10;
   
	if(count <= probability(id) || force)
	{
		id = load_character((unsigned char)id);
		give_model_to_wizard(id, currentwiz);
		place_model(sqx, sqy, &person[id]);
		person[id].owner = currentwiz;
		draw_other_creations(mover);

		mcolour = 175;
		sprintf(message, "Spell Succeeds");
		pauser = 1;
		ret = ptr_chaos_rating(person[id].model);
	}
	else
	{
		mcolour = 79;
		sprintf(message, "Spell Fails");
		pauser = 1;
		ret    = 0;
	}

	draw_realtime_scene();
	fade_from(white, mainpal, 1);
	message[0] = 0;

	return ret;
}

int cast_shot(int sqx, int sqy, int sqid, int type)
{
	int defscore, hardness, dif, tval;

	pauser = 1;

	switch(type)
	{
		case 3 :
			while(pauser < 128)
			{
				draw_realtime_scene();
				zline3d(view, mover->x, mover->y, mover->z, 64, board[sqid].x + (rand()%5), board[sqid].y + (rand()%5), board[sqid].z + (rand()%5), 111);
			}
		break;
	}

	if(ptr_can_shoot(mover->model))
		hardness = ptr_attack_rating(mover->model);
	else
		hardness = board[xy(mover->sqx, mover->sqy)].dist;

	defscore = (rand()%( ptr_defense_rating(board[sqid].chr->model) )+1)*2;

	if(defscore < hardness)
	{
		dif = hardness - defscore;

		if((board[sqid].chr->dead & LMASK) > dif)
		{
			tval = board[sqid].chr->dead & LMASK;
			tval -= dif;
			board[sqid].chr->dead &= ~LMASK;
			board[sqid].chr->dead += tval;
		}
		else
			dead_animation(mover, board[sqid].chr);
	}

	return 0;
}

int gr_move_to(int *start, int *end, CHARACTER *chr)
{
	float addx, addy, addz, sqx, sqy;
	int count, ret;

	ret = 1;

	if(*end != *start)
	{
		count = board[*end].last;
     
		if(gr_move_to(start, &count, chr))
		{
			sqx = board[*start].sq_x;
			sqy = board[*start].sq_y;

			if	(!check_eng_pos(chr, sqx-1, sqy+1) &&
				!check_eng_pos(chr, sqx-1, sqy)   &&
				!check_eng_pos(chr, sqx-1, sqy-1) &&
				!check_eng_pos(chr, sqx,   sqy-1) &&

				!check_eng_pos(chr, sqx+1, sqy-1) &&
				!check_eng_pos(chr, sqx+1, sqy)   &&
				!check_eng_pos(chr, sqx+1, sqy+1) &&
				!check_eng_pos(chr, sqx,   sqy+1) )
			{
				addx = (board[*end].x - chr->x) / 8.0f;
				addy = (board[*end].y - chr->y) / 8.0f;
				addz = (board[*end].z - chr->z) / 8.0f;

				chr->angle = get_angle(addx, addy, addz);

				count = 8;

				while(count--)
				{
					chr->x += addx;
					chr->y += addy;
					chr->z += addz;

					draw_realtime_scene();
				}

				*start = *end;
			}
			else
			{
				*end = *start;

				ret = 0;
			}
		}
		else
		{
			mcolour = 47;
			sprintf(message, "Engaged to Enemy");
			pauser = 1;
			chr->moves = 0;

			*end = count;

			ret = 0;
		}
	}

	return ret;
}
