/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "human.h"
#include "castfunc.h"
#include "movefunc.h"
#include "probfunc.h"
#include "compfunc.h"
#include "chfileio.h"
#include "fastgrap.h"
#include "gengrap.h"
#include "init.h"
#include "logic.h"
#include <string.h>

#define INFOKEY_PRESSED (1 << 30)
#define SPECKEY_PRESSED (1 << 29)
                                       
void add_3dwizard(int passer)
{
	add_player(&person[passer], view, LIT);
//	textprintf(view->image, font, 160, 20, 47, "%0.2f", fpsadjust);
	add_frame();
   
	person[passer].angle += fpsadjust;

	if(person[passer].angle > 255)
		person[passer].angle -= 256;
}

int handle_2d_menu(int passer, void(* func3d)(int passer), char testclick, int textx, int texty, int textlen, int *pos, char *text, FONT *lfont, int flimit, char checkspecial, char checkinfo, char allowright)
{
	int  bkey, fcount;
	int leave;

	leave = 0;

	if(pos)
		text[*pos] = '\0';
	fcount = 0;

	while(!leave)
	{
		clear_shot(view);
		blit(backup->image, view->image, 0, 0, 0, 0, WIDTH, HEIGHT);
      
		if(text)
		{
			textout_centre(view->image, lfont, text, textx, texty, 47);
         
			if(keypressed())
			{
				bkey = readkey();

				if((bkey >> 8) == KEY_BACKSPACE)
				{
					if(*pos > 0)
						(*pos)--;
				}
				else
					if((bkey >> 8) != KEY_ENTER)
					{
						text[*pos] = bkey & 255;

						if(*pos < textlen)
							(*pos)++;
					}
                
				text[*pos] = '\0';

				if(key[KEY_ENTER])
					leave = 1;
			}
		}
        
		if(key[KEY_S] && checkspecial && mouseover->line[mouse_y][mouse_x])
			leave = mouseover->line[mouse_y][mouse_x] | SPECKEY_PRESSED;
        
		if((key[KEY_ENTER] || key[KEY_I] || mouse_b & 4) && mouseover->line[mouse_y][mouse_x] && checkinfo)
			leave = mouseover->line[mouse_y][mouse_x] | INFOKEY_PRESSED;
      
		if(func3d)
			func3d(passer);

		if((mouse_b&1) && fcount > flimit)
		{
			if(!testclick)
				leave = 1;
			else
				if(mouseover->line[mouse_y][mouse_x])
					leave = mouseover->line[mouse_y][mouse_x];
		}

		if((mouse_b&2) && allowright)
		{
			leave = -1;
		}

		if(!leave)
		{
			draw_sprite(view->image, globdata[MPtr].dat, mouse_x, mouse_y);
			show_buffer();
			fcount++;
		}
	}

	return leave;
}

int menu(char *title, char *names[], int num, FONT *fnt, int bcol)
{
	int hheight, hwidth, add, current, pos, result, ppos;
	unsigned char finish;
   
	acquire_bitmap(backup->image);
	circrectfill(backup->image, 10, 10, WIDTH-10, HEIGHT-10, 10, bcol);

	hheight = text_height(fnt) >> 1;
	textout_centre(backup->image, fnt, title, WIDTH >>1, 10, 47);

	add = ((HEIGHT-hheight-(10+hheight)) << 16) / (num+1);
	pos = ((10+hheight) << 16) + add;

	for(current = 0; current < num; current++)
	{
		ppos = pos >> 16;

		hwidth = (text_length(fnt, names[current]) >> 1) + 5;
		textout_centre(backup->image, fnt, names[current], WIDTH>>1, ppos-hheight, 42);
		pos += add;
	}

	finish = FALSE;
	release_bitmap(backup->image);

	do{
		blit(backup->image, view->image, 0, 0, 0, 0, WIDTH, HEIGHT);

		if(mouse_b & 1)
		{
			pos = ((10+hheight) << 16) + add;

			for(current = 0; current < num; current++)
			{
				ppos = pos >> 16;
				hwidth = (text_length(fnt, names[current]) >> 1) + 5;

				if(mouse_x < (WIDTH>>1) + hwidth && mouse_x > (WIDTH>>1) - hwidth &&
				mouse_y < ppos+hheight+2 && mouse_y > ppos-hheight-2)
				{
					finish = TRUE;
					result = current;
					textout_centre(view->image, fnt, names[current], WIDTH>>1, ppos-hheight, 67);
					current = num;
				}

				pos += add;
			}
		}
        
		draw_sprite(view->image, globdata[MPtr].dat, mouse_x, mouse_y);
		blit(view->image, scr, 0, 0, 0, 0, WIDTH, HEIGHT);

	}while(!finish);

	do{}while(mouse_b);

	play_sample(globdata[MenuSelect].dat, 255, 127, 1000, FALSE);
   
	return result;
}

void printspell(BITMAP *pbmp, int x, int y, int num, int col, int *locspells, int *numbers, FONT *fnt)
{
	int prob;
	char specstr[25];

	prob=probability(locspells[num+1]);
   
	if(chaos_rating(allchars[numbers[num]]) < 0)
	{
		sprintf(specstr, "* %s (%d)", allchars[numbers[num]].name, prob*10);
		textout_centre(pbmp, fnt, specstr, x, y, col+prob);
		rectfill(mouseover, x-(text_length(fnt, specstr) >> 1), y, x+(text_length(fnt, specstr) >> 1),y + text_height(fnt), num+1);
	}
	else
		if(chaos_rating(allchars[numbers[num]]) > 0)
		{
			sprintf(specstr, "^ %s (%d)", allchars[numbers[num]].name, prob*10);
			textout_centre(pbmp, fnt, specstr, x, y, col+prob);
			rectfill(mouseover, x-(text_length(fnt, specstr) >> 1), y, x+(text_length(fnt, specstr) >> 1),y + text_height(fnt), num+1);
		}
		else
		{
			sprintf(specstr, "- %s (%d)", allchars[numbers[num]].name, prob*10);
			textout_centre(pbmp, fnt, specstr, x, y, col+prob);
			rectfill(mouseover, x-(text_length(fnt, specstr) >> 1), y, x+(text_length(fnt, specstr) >> 1),y + text_height(fnt), num+1);
		}
}


void info_screen(CHARACTER_MODEL *chrm)
{
	char string1[90], string2[90];
	int height, pos, chaos;
	FONT *fnt;
	BITMAP *bmp1, *bmp2;

	bmp1 = create_bitmap(WIDTH, HEIGHT);
	bmp2 = create_bitmap(WIDTH, HEIGHT);

	fnt = globdata[gothicL].dat;
	height = text_height(fnt);

	clear(bmp1);
	circrectfill(bmp1, 10, 10, WIDTH-10, HEIGHT-10, 10, 151);

	sprintf(string1, "~~%s~~", chrm->name);
	textout_centre(bmp1, fnt, string1, WIDTH >>1, 10, 47);

	chaos = ptr_chaos_rating(chrm);
	if(chaos == 0)
		sprintf(string1, "(neutral)");

	if(chaos < 0)
		sprintf(string1, "(chaos: %d)", 0-chaos);

	if(chaos > 0)
		sprintf(string1, "(law: %d)", chaos);
		
	sprintf(string2, "%s", string1);

	pos = 10 + (height << 1);

	switch(returntype(chrm))
	{
		case PERSON :
			if(ptr_undead(chrm))
				sprintf(string1, "%s Undead", string2);
			sprintf(string2, "%s", string1);

			if(ptr_flying(chrm))
			{
				if(strlen(string1))
					sprintf(string1, "%s Flying", string2);
				else
					sprintf(string1, "Flying");
			}
			sprintf(string2, "%s", string1);
   
			if(ptr_mount(chrm))
			{
				if(strlen(string1))
					sprintf(string1, "%s Mount", string2);
				else
					sprintf(string1, "Mount");
			}
			sprintf(string2, "%s", string1);

			textout_centre(bmp1, fnt, string1, WIDTH >>1, pos, 44);
			pos += (height << 1) + height;

			sprintf(string1, "Attack rating: %d ~ Defense rating: %d", ptr_attack_rating(chrm), ptr_defense_rating(chrm));
			textout_centre(bmp1, fnt, string1, WIDTH >>1, pos, 44);
			pos += height;

			sprintf(string1, "Movement rating: %d ~ Magic Resistance: %d", ptr_movement_rating(chrm), ptr_magic_resistance(chrm));
			textout_centre(bmp1, fnt, string1, WIDTH >>1, pos, 44);
			pos += height;

			sprintf(string1, "Manoeuvre rating: %d", ptr_manoeuvre_rating(chrm));
			textout_centre(bmp1, fnt, string1, WIDTH >>1, pos, 44);
			pos += (height << 1) + height;

			if(ptr_can_shoot(chrm))
			{
				switch(ptr_shot_type(chrm))
				{
					case 0 : sprintf(string2, "Projectile: rock");  break;
					case 1 : sprintf(string2, "Projectile: fire");  break;
					case 2 : sprintf(string2, "Projectile: arrow"); break;
				}

				sprintf(string1, "%s ~ Range : %d", string2, ptr_shot_distance(chrm));
			}
			else
				sprintf(string1, "No projectile");

			textout_centre(bmp1, fnt, string1, WIDTH >>1, pos, 44);
			pos += (height << 1) + height;
         
			break;

		case BEAM :
			sprintf(string1, "Range : %d", ptr_movement_rating(chrm));
			textout_centre(bmp1, fnt, string1, WIDTH >> 1, (HEIGHT >> 1)-height, 44);
         
			sprintf(string1, "Power : %d", ptr_attack_rating(chrm));
			textout_centre(bmp1, fnt, string1, WIDTH >> 1, HEIGHT >> 1, 44);
		break;
	}
   
	textout_centre(bmp1, fnt, "Any button to exit", WIDTH >>1, pos, 47);
   
	while(keypressed() || mouse_b) {clear_keybuf();};
   
	while(!keypressed() && !mouse_b)
	{
		blit(bmp1, bmp2, 0, 0, 0, 0, WIDTH, HEIGHT);
		draw_sprite(bmp2, globdata[MPtr].dat, mouse_x, mouse_y);
		blit(bmp2, scr, 0, 0, 0, 0, WIDTH, HEIGHT);
	}

	clear_keybuf();

	while(keypressed() || mouse_b) {clear_keybuf();};
	destroy_bitmap(bmp1);
	destroy_bitmap(bmp2);
}

/*int simple_question(char *text, FONT *user, BITMAP *bmp, int bcolour, int tcolour)
{
   int width, height;
   char leave;
   BITMAP *backup;

   leave = FALSE;
   backup = create_bitmap(SCREEN_W, SCREEN_H);
   blit(bmp, backup, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
   width = (text_length(user, text) >> 1) + 10;
   height = text_height(user);

   while(!leave)
     {
      blit(backup, bmp, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
      circrectfill(bmp, (SCREEN_W >> 1) - width, (SCREEN_H >> 1) - height-4, (SCREEN_W >> 1) + width, SCREEN_H >> 1, 10, tcolour);
      circrectfill(bmp, (SCREEN_W >> 1) - width, SCREEN_H >> 1, (SCREEN_W >> 1) + width, (SCREEN_H >> 1) + height +4, 10, bcolour);
      rectfill(bmp, (SCREEN_W >> 1) - width, (SCREEN_H >> 1) - 6, (SCREEN_W >> 1) + width, SCREEN_H >> 1, tcolour);
      rectfill(bmp, (SCREEN_W >> 1) - width, (SCREEN_H >> 1) , (SCREEN_W >> 1) + width, (SCREEN_H >> 1) + 6, bcolour);
      textout_centre(bmp, user, text, SCREEN_W >> 1, (SCREEN_H >> 1) - height - 2, 47);
      textout_centre(bmp, user, "YES", (SCREEN_W >> 1) - (width >> 1), (SCREEN_H >> 1) + 2, 42);
      textout_centre(bmp, user, "NO", (SCREEN_W >> 1) + (width >> 1), (SCREEN_H >> 1) + 2, 42);
      
      if(mouse_b && mouse_x > (SCREEN_W >> 1) - width && mouse_x < (SCREEN_W >> 1) + width && mouse_y > (SCREEN_H >> 1) && mouse_y < (SCREEN_H >> 1) + 2 + height)
        {
         if(mouse_x > SCREEN_W >> 1)
           {
            leave = 2;
            textout_centre(bmp, user, "NO", (SCREEN_W >> 1) + (width >> 1), (SCREEN_H >> 1) + 2, 47);
           }
         else
           {
            leave = 1;
            textout_centre(bmp, user, "YES", (SCREEN_W >> 1) - (width >> 1), (SCREEN_H >> 1) + 2, 47);
           }
        }
        
      draw_sprite(bmp, globdata[MPtr].dat, mouse_x, mouse_y);
      blit(bmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
     }

   while(mouse_b)
     {
     }

   return leave;
}*/

int chose_wizard(int num, int basechar)
{
	FILE *stream;
	float oldx, oldy, oldz;
	int curwiz, pos;
	float mul;
	int tpos;
	char fname[25], leave, last, comp;
	int tx, cx, cy;
	char compstatus[14];
   
	//initial 3d setup
	curwiz = basechar;
	sprintf(fname, "wizard/%d.chr", curwiz);
	if((stream = fopen(fname, "rb")))
	{
		free(person[wizard[num]].model->polys);
		free(person[wizard[num]].model->verts);
		read_3dmodel(stream, person[wizard[num]].model);
		person[wizard[num]].dead = 1;
		setup_ready(&person[wizard[num]]);
		fclose(stream);
	}
   
	oldx = person[wizard[num]].x;
	oldy = person[wizard[num]].y;
	oldz = person[wizard[num]].z;
	person[wizard[num]].x = 0;
	person[wizard[num]].y = 0;
	person[wizard[num]].z = -10;
	person[wizard[num]].angle = 0;
	pos = 0;
   
	//screen setup
	clear(backup->image);
	clear(mouseover);
   
	mul = 640.0f / (float)WIDTH;
	set_projection_viewport(10*mul, 10*mul, 352*mul, 220*mul);
	tpos = 10*mul;
   
	//non-interactive text
	rect(backup->image, 10*mul, 10*mul, 362*mul, 230*mul, 47);
	textout_centre(backup->image, globdata[LFONT].dat, "Choose Wizard", 480*mul, tpos, 47);
	tpos += text_height(globdata[LFONT].dat);
	textprintf_centre(backup->image, globdata[LFONT].dat, 480*mul, tpos, 47, "Player %d", num+1);
	tpos += text_height(globdata[LFONT].dat) << 1;

	//computer : yes/no
	cy = 240 * mul;
	cx = (WIDTH >> 1) - (text_length(globdata[LFONT].dat, "Computer? Yes") >> 1);
	rectfill(mouseover, cx, cy, cx+text_length(globdata[LFONT].dat, "Computer? Yes"), cy+text_height(globdata[LFONT].dat), 4);

	//left & right buttons
	circrectfill(backup->image, 10*mul, 280*mul, 310*mul, 320*mul, 5, 32);
	circrectfill(mouseover,     10*mul, 280*mul, 310*mul, 320*mul, 5, 2);
	textout_centre(backup->image, globdata[LFONT].dat, "<<", 160*mul, 300*mul - (text_height(globdata[LFONT].dat) >> 1), 47);
   
	circrectfill(backup->image, 330*mul, 280*mul, 630*mul, 320*mul, 5, 32);
	circrectfill(mouseover,     330*mul, 280*mul, 630*mul, 320*mul, 5, 3);
	textout_centre(backup->image, globdata[LFONT].dat, ">>", 480*mul, 300*mul - (text_height(globdata[LFONT].dat) >> 1), 47);

	//name box
	circrectfill(backup->image, 10*mul, 330*mul, 10*mul + text_length(globdata[MFONT].dat, " Name : "), 330*mul + text_height(globdata[MFONT].dat), 2, RED+15);
	textout(backup->image, globdata[MFONT].dat, " Name : ", 10*mul, 330*mul, 47);
	tx = 20*mul + text_length(globdata[MFONT].dat, " Name : ");
	circrectfill(backup->image, tx, 330*mul, 630*mul, 330*mul + text_height(globdata[MFONT].dat), 3, RRED+15);
	tx = (int)(tx + (630*mul)) >> 1;
   
	//done button
	circrectfill(backup->image,  320*mul - (text_length(globdata[LFONT].dat, " DONE ") >> 1), 370*mul, 320*mul + (text_length(globdata[LFONT].dat, " DONE ") >> 1), 370*mul + text_height(globdata[LFONT].dat), 5, 32);
	circrectfill(mouseover,      320*mul - (text_length(globdata[LFONT].dat, " DONE ") >> 1), 370*mul, 320*mul + (text_length(globdata[LFONT].dat, " DONE ") >> 1), 370*mul + text_height(globdata[LFONT].dat), 5, 1);
	textout_centre(backup->image, globdata[LFONT].dat, "DONE", 320*mul, 370*mul, 47);
	tpos += text_height(globdata[LFONT].dat);
   
	leave = 0;
	comp = 0;
   
	while(!leave)
	{
		rectfill(backup->image, cx, cy, cx+text_length(globdata[LFONT].dat, "Computer? Yes"), cy+text_height(globdata[LFONT].dat), 0);
		if(comp)
			sprintf(compstatus, "Computer? Yes");
		else
			sprintf(compstatus, "Computer? No");

		textout(backup->image, globdata[LFONT].dat, compstatus, cx, cy, 47);

		stream = NULL;

		switch(handle_2d_menu(wizard[num], add_3dwizard, 1, tx, 330*mul, 19, &pos, person[wizard[num]].model->name, globdata[MFONT].dat, 5, 0, 0, 0))
		{
			case 1 :
				leave = 1;
			break;

			case 2 :
				curwiz --;

				if(curwiz < 1)
					curwiz = 1;
                   
				sprintf(fname, "wizard/%d.chr", curwiz);
				stream = fopen(fname, "rb");
				last = 2;
			break;

			case 3 :
				curwiz++;
				sprintf(fname, "wizard/%d.chr", curwiz);
				stream = fopen(fname, "rb");

				if(!stream)
				{
					curwiz--;
					sprintf(fname, "wizard/%d.chr", curwiz);
					stream = fopen(fname, "rb");
				}
			break;

			case 4 :
				comp = (comp + 1) & 1;
			break;
		}

		if(stream)
		{
			free(person[wizard[num]].model->polys);
			free(person[wizard[num]].model->verts);

			read_3dmodel(stream, person[wizard[num]].model);
			person[wizard[num]].dead = 1;
			setup_ready(&person[wizard[num]]);
			fclose(stream);
		}
	}

	if(person[wizard[num]].model->name[0] == '\0')
		sprintf(person[wizard[num]].model->name, "Player %d", num+1);
     
	clear_keybuf();
	while(keypressed())
	{
	}

	person[wizard[num]].model->flags = 0;
	person[wizard[num]].model->ratings = (((rand()%5)+1) << 4) + ((rand()%5) + 1);
	person[wizard[num]].model->movement = 1 << 3;
	person[wizard[num]].model->resist = 3 << 4;
	person[wizard[num]].model->projectile = 0;
	person[wizard[num]].dead = (person[wizard[num]].model->ratings) & 15;
	do{}while(mouse_b);
	set_projection_viewport(0, 0, WIDTH-1, HEIGHT-1);

	switch(comp)
	{
		default :
			players[num].prefunc	= human_premovement;
			players[num].castfunc	= mod_cast_humanmain;
			players[num].movefunc	= mod_move_humanmain;
		break;

		case 1 :
			players[num].prefunc	= computer_premovement;
			players[num].castfunc	= mod_cast_compmain;
			players[num].movefunc	= mod_move_compmain;
		break;

/*      case 1 : //YES
        switch(complev)
          {
           case 1 :
             players[num].prefunc  = stupid_comp_premovement;
             players[num].castfunc = stupid_comp_casting;
             players[num].movefunc = stupid_comp_movement;
           break;

           case 2 :
             players[num].prefunc  = mediocre_comp_premovement;
             players[num].castfunc = stupid_comp_casting;
             players[num].movefunc = stupid_comp_movement;
           break;
           
           case 3 :
             players[num].prefunc  = mediocre_comp_premovement;
             players[num].castfunc = mediocre_comp_casting;
             players[num].movefunc = stupid_comp_movement;
           break;

           case 4 :
             players[num].prefunc  = mediocre_comp_premovement;
             players[num].castfunc = mediocre_comp_casting;
             players[num].movefunc = mediocre_comp_movement;
           break;

           case 5 :
             players[num].prefunc  = clever_comp_premovement;
             players[num].castfunc = mediocre_comp_casting;
             players[num].movefunc = mediocre_comp_movement;
           break;

           case 6 :
             players[num].prefunc  = clever_comp_premovement;
             players[num].castfunc = clever_comp_casting;
             players[num].movefunc = mediocre_comp_movement;
           break;

           case 7 :
             players[num].prefunc  = clever_comp_premovement;
             players[num].castfunc = mediocre_comp_casting;
             players[num].movefunc = clever_comp_movement;
           break;

           case 8 :
             players[num].prefunc  = clever_comp_premovement;
             players[num].castfunc = clever_comp_casting;
             players[num].movefunc = clever_comp_movement;
           break;


          }*/
	break;
	}
	
	play_sample(globdata[MenuSelect].dat, 255, 127, 1000, FALSE);

	person[wizard[num]].x = oldx;
	person[wizard[num]].y = oldy;
	person[wizard[num]].z = oldz;
	
	return curwiz;
}

unsigned char spellselect(char *title, char *names[], int *numbers, int num, FONT *fnt, int *locspells, int bcol)
{
	int add, cur1, cur2;
	int pos, result, ppos, x1, x2, onum;
	char illustext[14], leave, illus;
	BITMAP *oldmouseover;

	oldmouseover = create_bitmap(WIDTH, HEIGHT);
	blit(mouseover, oldmouseover, 0, 0, 0, 0, WIDTH, HEIGHT);
	clear(backup->image);
	clear(mouseover);

	circrectfill(backup->image, 10, 10, WIDTH-10, HEIGHT-10, 10, bcol);
	illus = 0;
   
	x1 = WIDTH >> 2;
	x2 = x1 + (WIDTH >> 1);

	textout_centre(backup->image, fnt, title, WIDTH >>1, 10, 47);

	add = ((HEIGHT-10-text_height(fnt)) << 17) / 21; //18 = num+2
	pos = (10 << 16) + add;
   
	onum = num;
	num >>= 1;
	cur2 = num;

	for(cur1 = 0; cur1 < num; cur1++)
	{
		ppos = pos >> 16;

		printspell(backup->image, x1, ppos, cur1, 37, locspells, numbers, fnt);
		printspell(backup->image, x2, ppos, cur2, 37, locspells, numbers, fnt);
      
		pos += add;
		cur2++;
	}

	if(onum&1)
	{
		ppos = pos >> 16;
		printspell(backup->image, x2, ppos, cur2, 37, locspells, numbers, fnt);
		cur2++;
	}

	cur2++;

	textprintf_centre(backup->image, fnt, WIDTH>>1, HEIGHT-10-text_height(fnt)-(text_height(fnt) >> 1), 74, "Right mouse button for NONE");

	rectfill(mouseover, (WIDTH >> 1) - (text_length(fnt, "Illusion? Yes") >> 1), HEIGHT-8-text_height(fnt)-(text_height(fnt) << 1), (WIDTH >> 1) + (text_length(fnt, "Illusion? Yes") >> 1), HEIGHT-8-text_height(fnt)-text_height(fnt), cur2);

	blit(backup->image, view->image, 0, 0, 0, 0, WIDTH, HEIGHT);

	leave = 0;

	while(!leave)
	{
		if(illus)
			sprintf(illustext, "Illusion? Yes");
		else
			sprintf(illustext, "Illusion? No");

		rectfill(backup->image, (WIDTH >> 1) - (text_length(fnt, "Illusion? Yes") >> 1), HEIGHT-8-text_height(fnt)-(text_height(fnt) << 1), (WIDTH >> 1) + (text_length(fnt, "Illusion? Yes") >> 1), HEIGHT-8-text_height(fnt)-text_height(fnt), bcol);
		textout_centre(backup->image, fnt, illustext, WIDTH >> 1, HEIGHT-8-text_height(fnt)-(text_height(fnt) << 1), 47);

		result = handle_2d_menu(0, NULL, 1, 0, 0, 0, NULL, NULL, NULL, 5, 0, 1, 1);

		if(result < 0)
			leave = 1;
		else
		{
			if(result & INFOKEY_PRESSED)
				info_screen(&allchars[numbers[(result & ~INFOKEY_PRESSED)-1]]);
			else
			{
				if(result == cur2)
					illus = (illus +1)&1;
				else
					leave = 1;
			}
		}
	}

	if(result < 0)
	{
		result = 255;
	}
	else
	{
		result--;
		ppos = result;
      
		if(result >= num) // is in right hand column
		{
			x1 = x2;
			ppos = result - num;
		}

		ppos = (((ppos+1) * add) >> 16) + 10;

		printspell(scr, x1, ppos, result, 64, locspells, numbers, fnt);
		draw_sprite(scr, globdata[MPtr].dat, mouse_x, mouse_y);

		wait_for_mouse_free();
		play_sample(globdata[MenuSelect].dat, 255, 127, 1000, FALSE);
		blit(oldmouseover, mouseover, 0, 0, 0, 0, WIDTH, HEIGHT);

		result |= (illus << 7);
	}
        
	return result;
}
