/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "fastgrap.h"
#include "gengrap.h"
#include "logic.h"
#include "movefunc.h"
#include "menus.h"
#include "init.h"
#include "brfileio.h"
#include "chfileio.h"
#include <stdlib.h>

unsigned char base, badd;

void draw_realtime_scene(void)
{
	int count;
	int sqnum, height, pos;
	FONT *user;
	char text[55];

	if(!pauser)
		message[0] = 0;
   
	user = globdata[gothicM].dat;
	height = text_height(user);
     
	if(!(pauser & 7))
	{
		for(count = 16; count < 32; count++)
		{
			mainpal[count].r = mainpal[count].g = 0;
			mainpal[count].b = (base + count - 16)&63;
		}

		switch(rand()%3)
		{
			case 0 :
				for(count = 192; count < 208; count++)
				{
					mainpal[count].r = 255 - count;
					mainpal[count].g = mainpal[count].b = 0;
				}
			break;

			case 1 :
				for(count = 192; count < 208; count++)
				{
					mainpal[count].g = 255 - count;
					mainpal[count].r = mainpal[count].b = 0;
				}
			break;

			case 2 :
				for(count = 192; count < 208; count++)
				{
					mainpal[count].b = 255 - count;
					mainpal[count].g = mainpal[count].r = 0;
				}
			break;
		}
     
		base += badd;

		if(base > 47 || base < 1)
			badd = -badd;

		set_palette(mainpal);
	}

	sqnum = mouseover->line[mouse_y][mouse_x];

	mouse_xy = sqnum;
	mouse_sqx = board[sqnum].sq_x;
	mouse_sqy = board[sqnum].sq_y;
	mouse_on  = board[sqnum].chr;
        
	person[cursornum].x = board[sqnum].x;
	person[cursornum].y = board[sqnum].y;
	person[cursornum].z = board[sqnum].z;

	acquire_bitmap(view->image);

	add_player(mover, view, LIT);

	add_player(&person[cursornum], view, STATED);

	count = numbsquares;
	while(count--)
		if(board[count].check)
		{
			if(board[count].check < 16)
			{
				pos = board[count].last;
				zline3d(view, board[pos].x, board[pos].y, board[pos].z, board[count].check << 4, board[count].x, board[count].y, board[count].z, (board[count].check << 4)+15);
			}
			else
				draw_pyramid(board[count].x, board[count].y, board[count].z, board[count].check);
		}
       
	sprintf(text, "%s's move", person[wizard[currentwiz]].model->name);
	textout(view->image, user, text, WIDTH - text_length(user, text), 0, 79);
   
	sprintf(text, "Selected : %s", mover->model->name);
	textout(view->image, user, text, WIDTH - text_length(user, text), height, 111);
	sprintf(text, "Moves : %d", mover->moves);
	textout(view->image, user, text, WIDTH - text_length(user, text), height << 1, 111);

	if(board[sqnum].chr != NULL)
	{
		if((board[sqnum].chr->owner & 128) != WIZARD)
		{
			if(!(board[sqnum].chr->dead & LMASK))
				sprintf(text, "%s (dead)", board[sqnum].chr->model->name);
			else
				sprintf(text, "%s (%s)", board[sqnum].chr->model->name, person[wizard[board[sqnum].chr->owner]].model->name);
		}
		else
			sprintf(text, "%s", board[sqnum].chr->model->name);

		textout(view->image, user, text, 0, 0, 47);
	}
	else
		textout(view->image, user, "Empty Square", 0, 0, 35);


	draw_sprite(view->image, mptr, mouse_x, mouse_y);

	if(message[0] != 0)
		textout(view->image, user, message, 0, HEIGHT-height, mcolour);

//	textprintf_centre(view->image, font, 320, 392, 47, "FPS : %0.2f", fps);
	show_buffer();
   
	if(key[KEY_F12])
		save_pcx("snap.pcx", view->image, mainpal);
     
	copy_buffer(backup, view);
	release_bitmap(view->image);

	if(key[KEY_ESC])
	{
		globleave = TRUE;
		winner = 10;
	}

	person[cursornum].angle -= 5 * fpsadjust;
	pyramid.angle += fpsadjust;

	ang_range(person[cursornum].angle);
	ang_range(pyramid.angle);
	add_frame();
}

void shot(CHARACTER *shooter, char range, char hardness)
{
	//if range is passed as non-0, type is assumed to be bolt
	//
	//otherwise, settings are read from character
	int x, y, count, xdif, ydif, pos, number;

	fix_light();

	set_camera(&map.camera[0], 0);
	set_palette(mainpal);
	mover = shooter;
	draw_other_players();
	draw_other_creations(mover);
   
	x = shooter->sqx;
	y = shooter->sqy;
	pos = xy(x,y);
   
	if(range > 0)
		board[pos].data = 3;
	else
	{
//		board[pos].data     = ptr_shot_type(shooter->model);
		board[pos].data = 3;
		range    = ptr_shot_distance(shooter->model);
		hardness = (ptr_attack_rating(shooter->model) << 2) /3;
	}
    
	board[pos].dist = hardness;
   
	number = 0;

	functable[TEAMTI] = NULL;
	//functable[RRED >> 4] = cmod_human_shootme;
   
	count = numbsquares;
	while(count--)
	{
		board[count].check = 0;
      
		if(board[count].chr != NULL)
			if(board[count].chr->dead & LMASK)
			{
				if((board[count].chr->owner & 127) == currentwiz)
					board[count].check = TEAMTI;
				else
				{
					xdif = board[count].sq_x - x;
					ydif = board[count].sq_y - y;

					if(sqroot[xdif*xdif + ydif*ydif] < range)
						if(line_of_sight(shooter, count))
						{
							board[count].check = (RRED >> 4);
							number++;
							board[count].last  = pos;
						}
				}
			}
	}

	if(number)
		do_boardview(NULL);
	else
	{
		mcolour = 47;
		sprintf(message, "No Enemies in Range");
		pauser = 1;
	}

//	search_squares(shooter);
}


void premovement(void)
{
	int wiz, count, change;
	unsigned char selected[8];
	PALETTE inverse;

	wiz = 256;
	while(wiz--)
	{
		inverse[wiz].r = mainpal[wiz].r >> 1;
		inverse[wiz].g = mainpal[wiz].g >> 1;
		inverse[wiz].b = mainpal[wiz].b >> 1;
	}

	change = 0;

	for(wiz = 0; wiz < numwizards; wiz++)
		if((person[wizard[wiz]].dead & LMASK))
		{
			currentwiz = wiz;
			mover = &person[wizard[wiz]];
			players[wiz].prefunc(wiz, selected, &inverse);
		}
	else
		selected[wiz] = 255;

	set_palette(mainpal);
     
	for(wiz = 0; wiz < numwizards; wiz++)
		if((person[wizard[wiz]].dead & LMASK))
			if(selected[wiz] != 255)
			{
				currentwiz = wiz;
				mover = &person[wizard[wiz]];
				mcolour = 47;
				sprintf(message, "Casting %s", allchars[spells[wiz][selected[wiz] & 127]].name);
				pauser = 1;
   
				seed_fpsadjuster();
				players[wiz].castfunc(wiz, selected, &change);
				seed_fpsadjuster();
				selected[wiz]&=127;

				if(selected[wiz] != 1)
				{
					for(count = selected[wiz]; count < spells[wiz][0]; count++)
						spells[wiz][count] = spells[wiz][count+1];
             
					spells[wiz][0]--;
				}
			}       
	
	if(abs(chaoslaw) > 2)
		chaoslaw += change / (abs(chaoslaw)-2);
	else
		chaoslaw += change;
}

void movement(void)
{
	int wiz, count;
	int flag;
	CHARACTER *cchr;

	olightx = lightx;
	olighty = lighty;
	olightz = lightz;
   
	for(wiz = 0; wiz < numwizards; wiz++)
		if(person[wizard[wiz]].dead & LMASK)
		{
			cchr = &person[wizard[wiz]];
			while(cchr)
			{
				if(cchr->dead & LMASK)
					cchr->model->keepalive(cchr);

				cchr = cchr->next;
			}
					
			//reset light & checks
			fix_light();
			clear_checks();
        
			//do the normal movement setup thing
			start_move(wiz);

			//call that players movefunc
			seed_fpsadjuster();
			players[wiz].movefunc();
        
			flag = 0;
			count = numwizards;
			
			while(count--)
				if(person[wizard[count]].dead & LMASK)
					flag++;

			if(flag == 1)
				winner = wiz+1;

			if(flag == 0)
				winner = 11;
        
			if(winner)
				wiz = 10;
		}
     
	fix_light();
}

void startup(void)
{
	char *menu1[] = {"2", "3", "4", "5", "6", "7", "8"};
	char *menu2[] = {"1", "2", "3", "4", "5", "6", "7", "8"};
	PALETTE white;
	int count, wizno, retval;
	CAMERA wizardview;
        
        fpsadjust = 1;
	message[0] = 0;
	retval = begin();

	switch(retval)
	{
		case 5 :
			printf("Error setting graphics mode!\n\n");
			exit(1);
		break;

		case 3 :
			printf("You need a mouse and correct mouse driver to play this game\n\n");
			exit(1);
		break;

		case 2 :
		case 1 :
			printf("Undetermined initialisation error %d\n\n", retval);
			exit(1);
		break;
	}
     
	base = 0;
	badd = 1;
                  
	count = 256;
	while(count--)
		white[count].r = white[count].g = white[count].b = 63;
     
	set_palette(globdata[SOFTPAL].dat);
	stretch_blit(globdata[SOFTLOGO].dat, scr, 0, 0, ((BITMAP *)globdata[SOFTLOGO].dat)->w, ((BITMAP *)globdata[SOFTLOGO].dat)->h, 0, 0, WIDTH, HEIGHT);
	rest(200);
	play_sample(globdata[TitleSound].dat, 255, 127, 1000, FALSE);
	while(!keypressed() && !mouse_b) {}
	
	fade_from(globdata[SOFTPAL].dat, white, 5);
	stretch_blit(globdata[TITLE].dat, scr, 0, 0, ((BITMAP *)globdata[TITLE].dat)->w, ((BITMAP *)globdata[TITLE].dat)->h, 0, 0, WIDTH, HEIGHT);
	fade_from(white, globdata[TITLEPAL].dat, 3);	
	while(!keypressed() && !mouse_b) {}
	
	fade_out(3);
   
	rectfill(scr, 0, 0, WIDTH, HEIGHT, 208);

	load_board(0);
	set_palette(mainpal);

	cursornum = load_character(0);
	person[cursornum].dead = 1;

	clear(backup->image);
	clear_board();
	init_wizards(menu("How many players?", menu1, 7, globdata[LFONT].dat, 35) + 2);
	complev = menu("Level of Computer Opponents?", menu2,8, globdata[LFONT].dat, 35) + 1;

	set_light_vector(0, 0, 1);

	wizno = 1;
   
	wizardview.x = 0;
	wizardview.y = 0;
	wizardview.z = -20;
	wizardview.inx = 0;
	wizardview.iny = 0;
	wizardview.inz = 1;
	wizardview.upx = 0;
	wizardview.upy = 1;
	wizardview.upz = 0;
	wizardview.fov = 60;
	set_up_camera(&wizardview);
	set_camera(&wizardview, 1);
        
        seed_fpsadjuster();
	for(count=0;count<numwizards;count++)
		wizno = chose_wizard(count, wizno);
     
	play_midi(map.song, 1);

	set_light_vector(-1, 0, 1);
	set_mouse_range(0, 0, WIDTH-2, HEIGHT-2);
   
	fps = frames = 0;
}

char *credit_titles[] =
{
	"Programming :",
	"Help :",
	"2d Art :",
	"3d Art :",
	"Art Manipulation :",
	"Digital Sounds :",
	"MIDI Music :",
	"Start Sound :",
	NULL
};

char *credit_names[] =
{
	"Thomas Harte",
	"Grzegorz Adam Hankiewicz",
	"Jay Hughes",
	"Thomas Harte / Neil Attrill / Kirstin Croney",
	"Thomas Harte / Kirstin Croney",
	"Stolen (from Chaos)",
	"Matt Wales",
	"Jay Hughes"
};

int main(void)
{
	char **title, **name;
	int y;

	startup();
   
	globleave = FALSE;
   
	set_camera(&map.camera[0], 1);

	do{
		premovement();
		movement();
	}while(!winner);

	clear(screen);
	clear_keybuf();

//	set_gfx_mode(GFX_TEXT, 80, 25, 0, 0);
	y = 0;
	textprintf(screen, globdata[gothicM].dat, 0, 0, 47, "Thanks for playing Anarchy (%s %s)",
						(winner == 11) ? "Drawn" : (winner == 10) ? "Abandoned" : person[wizard[winner-1]].model->name,
						((winner == 11) || (winner == 10)) ? "game" : "won");
                                                
	y += text_height(globdata[gothicM].dat) << 1;
	textprintf(screen, globdata[gothicM].dat, 40, y, 47, "(c) 1999 SoftySoft");
	y += text_height(globdata[gothicM].dat) << 1;

	title = credit_titles;
	name = credit_names;
	while(*title)
	{
		textprintf(screen, globdata[gothicM].dat, 0, y, 47, "%s", *title++);
		textprintf(screen, globdata[gothicM].dat, 192, y, 47, "%s", *name++);
		y += text_height(globdata[gothicM].dat)+2;
	}

	y += text_height(globdata[gothicM].dat) << 1;
	textprintf_centre(screen, globdata[gothicM].dat, 320, y, 47, "\"As long as they are not profiting, I don't mind people 'updating'");
	y += text_height(globdata[gothicM].dat)+2;
	textprintf_centre(screen, globdata[gothicM].dat, 320, y, 47, "my games\" - Julian Gollop");
        
	textprintf_centre(screen, font, 320, 392, 42, "Press any key to exit");
/*	textprintf(screen, font, 40, 40, 47, "Programming : Thomas Harte");
	textprintf(screen, font, 40, 48, 47, "Help : Grzegorz Adam Hankiewicz");
	textprintf(screen, font, 40, 56, 47, "2d Art : Jay Hughes");
	textprintf(screen, font, 40, 64, 47, "3d Art : Thomas Harte / Neil Attrill / Kirstin Croney");
	textprintf(screen, font, 40, 72, 47, "Art Manipulation : Thomas Harte / Kirstin Croney");
	textprintf(screen, font, 40, 80, 47, "Digital Sounds : Thomas Harte / Neil Attrill / Kirstin Croney");
	textprintf(screen, font, 40, 88, 47, "Art Manipulation : Thomas Harte / Kirstin Croney");*/

	while(!keypressed());
/*	printf("Thanks for playing Anarchy ");
   
	if(winner == 11)
		printf("(Drawn game),");

	if(winner == 10)
		printf("(Abandoned game),");

	if(winner <= numwizards)
		printf("(%s won),", person[wizard[winner-1]].model->name);
     
	printf("\n\n\t(c) 1999 SoftySoft");
	printf("\n\n\tProgramming\t: Thomas Harte");
	printf("\n\tPort|ing/ability: Grzegorz Adam Hankiewicz");
	printf("\n\t2d Art\t\t: Jay Hughes");
	printf("\n\t3d Art\t\t: Thomas Harte / Neil Attrill / Kirstin Croney");
	printf("\n\tArt Manipulation: Thomas Harte / Kirstin Croney");

	printf("\n\tGirls\t\t: Kirstin Croney");
//	printf("\n\tFewest mentions\t: Neil Attrill / Jay Hughes");
	printf("\n\tDigital Sounds\t: Stolen (from Chaos, hence : Julian Gollop)");
	printf("\n\tStart Sound\t: Jay Hughes");
	printf("\n\tMIDI Music\t: Matt Wales");
	printf("\n\tZ80 guidance\t: Robert Baker / Ian Collier / Pera Putnik / Maz Spork");
	printf("\n\tThe Dude\t: Flurby Jim");
	printf("\n\tMentioned by\t: PC Zone");
	printf("\n\n\tBased on 'Chaos', (c) and written by Julian Gollop, 1984");
	printf("\n\n\t\"As long as they are not profiting, I don't mind people 'updating'\n\tmy games\" - Julian Gollop via PC Zone");*/
//	printf("Thanks for playing Anarchy,\n\t(c)1999 SoftySoft \n\nBased on 'Chaos' by Julian Gollop - (c) 1984 for the ZX Spectrum\n");

//	printf("\n\n");
/*	printf("%d characters found :\n\n", numcharacters-9);

	count = numcharacters;
	while(count-- > 9)
		printf("%s, ", allchars[count].name);

	count = (rand()%(numcharacters-9)) + 9;

	printf("\n\nTest stats for %s\n\n", allchars[count].name);
	printf("\tUndead : %d, Flying : %d, Mount : %d, Spawning : %d\n", allchars[count].flags >> 7, (allchars[count].flags >> 6)&1, (allchars[count].flags >> 5)&1, (allchars[count].flags >> 1)&1);
	printf("\tLaw (positive = lawful, count = neutral, negative = chaotic) : %d\n", (int)((allchars[count].flags >> 2)&7) - 2);
	printf("\tCombat : %d, Defense : %d\n", allchars[count].ratings >> 4, allchars[count].ratings&15);
	printf("\tRange : %d, Manoeuvre : %d, Magic Resistance : %d\n", allchars[count].movement >> 3, allchars[count].resist >> 4, allchars[count].resist&15);
	printf("\tProjectile : %d, Range : %d, Type : ", allchars[count].projectile >> 7, (allchars[count].projectile >> 2)&31);

	switch(allchars[count].projectile&3)
	{
		case 0 : printf("rock\n");  break;
		case 1 : printf("fire\n");  break;
		case 2 : printf("arrow\n"); break;
	}*/

	return 0;
}

END_OF_MAIN();