/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "chfileio.h"
#include "misc3d.h"
#include "movefunc.h"
#include "chfileio.h"
#include <math.h>

#ifndef PI
#define PI 3.141592654
#endif

char returntype(CHARACTER_MODEL *chrm)
{
	switch(ptr_growth_type(chrm))
	{
		default:
		case 0 :
			if(ptr_can_shoot(chrm) && ptr_shot_type(chrm) == 3)
				return BEAM;

		return PERSON;
                
		case 1 :
		return BLOB;
                
		case 2 :
		return FOREST;
	}
}

int check_engaged_with(CHARACTER *mover, int pos)
{
	int rand1, rand2;

	if(board[pos].chr != NULL)
	{
		if((board[pos].chr->dead & LMASK))
		{
			rand1 = rand()%ptr_manoeuvre_rating(mover->model);
			rand2 = rand()%ptr_manoeuvre_rating(board[pos].chr->model);
         
			if(rand1 > rand2)
				return 1;
		}
	}
	
	return 0;
}

void place_model(int x, int y, CHARACTER *chr)
{
	int pos;
   
	pos = xy(x, y);
	chr->x = board[pos].x;
	chr->y = board[pos].y;
	chr->z = board[pos].z;
	chr->sqx = x;
	chr->sqy = y;

	chr->square = board[pos].chr;
	board[pos].chr = chr;
}

float get_angle(float addx, float addy, float addz)
{
	float angcos, angle;
   
	angcos = addz / sqrt(addx*addx + addy*addy + addz*addz);
	angle = (128 * acos(angcos)) / PI;

	if(addx < 0)
		angle = 256 - angle;

	angle += 128;
      
	ang_range(angle);

	return angle;
}

int check_eng_pos(CHARACTER *innocent, int x, int y)
{
	int pos, ret;

	ret = 0;
   
	if(x >= 0 && y >= 0 && x < bwidth && y < bheight)
	{
		pos = xy(x,y);
   
		if(board[pos].chr != NULL)
			if((board[pos].chr->dead & LMASK) && (board[pos].chr->owner & 127) != (innocent->owner & 127) && board[pos].chr->moves)
				ret = 1;
	}

	return ret;
}

int move_model(int x, int y, CHARACTER *chr, int animate)
{
	int pos, tpos, start;
	int ret;

	ret = 1;

	tpos = xy(x, y);
	pos = xy(chr->sqx, chr->sqy);
	chr->moves = board[tpos].dist;
	chr->diags = board[tpos].diags;

	start = pos;

	if(animate)
		if(!gr_move_to(&pos, &tpos, chr))
		{
			mcolour = 47;
			sprintf(message, "Engaged to Enemy");
			pauser = 1;
			chr->moves = 0;
			ret = 0;
		}

	x = board[tpos].sq_x;
	y = board[tpos].sq_y;
   
	board[start].chr = chr->square;
	place_model(x, y, chr);
	//search_squares(chr);

	return ret;
}

void give_model_to_wizard(int modelnum, int wizardnum)
{
	CHARACTER *chr;

	chr = &person[wizard[wizardnum]];

	while(chr->next != NULL)
		chr = chr->next;

	chr->next = &person[modelnum];
}

void init_wizards(int num)
{
	int count, count2, startid;

	wizard = malloc(sizeof(int)*num);
	spells = malloc(sizeof(int *)*num);
	numwizards = num;
	currentwiz = 0;

	count = num;
	while(count--)
	{
		spells[count] = malloc(sizeof(int)* 17);
		spells[count][0] = 16;
		wizard[count] = load_character((unsigned char)(count+1));
		person[wizard[count]].owner = 128;
		person[wizard[count]].owner |= count;
		person[wizard[count]].angle = 0;

		count2 = 16;
		while(count2--)
			spells[count][count2+1] = (rand()%(numcharacters-EXTRAMODS))+EXTRAMODS;

		spells[count][1] = 9;
	}

	switch(num)
	{
		default :
		case 2 :
			startid = 0;
		break;

		case 3 :
			startid = 2;
		break;

		case 4 :
			startid = 5;
		break;

		case 5 :
			startid = 9;
		break;

		case 6 :
			startid = 14;
		break;

		case 7 :
			startid = 20;
		break;

		case 8 :
			startid = 27;
		break;

	}

	for(count = 0; count < num; count ++)
	{
		place_model(starts[startid].x, starts[startid].y, &person[wizard[count]]);
                person[wizard[count]].angle = get_angle(board[bwidth>>1].x - starts[startid].x, board[bheight>>1].y - starts[startid].y, 0);
		startid++;
	}
}

void start_move(int wiznum)
{
	CHARACTER *chr;
	int count, pos;

	count = numbsquares;
	while(count--)
		board[count].check = 0;
     
	currentwiz = wiznum;
	chr = &person[wizard[wiznum]];

	while(chr != NULL)
	{
		chr->moves = ptr_movement_rating(chr->model);
		chr->diags = 0;
		chr->attacked = 0;
		pos = xy(chr->sqx, chr->sqy);
		board[pos].check = RED;
		chr = chr->next;
	}

	mover = &person[wizard[wiznum]];
}

void clear_board(void)
{
	int count;
	
	count = numbsquares;
	while(count--)
		board[count].chr = NULL;
}


void kill_wizard(int num)
{
	CHARACTER *chr, *searcher, *lsearcher;
	int pos;

	chr = &person[wizard[num]];

	do
	{
		pos = xy(chr->sqx, chr->sqy);
		searcher = board[pos].chr;

		if(searcher == chr)
		{
			board[pos].chr = chr->square;
		}
		else
		{
			while(searcher != chr)
			{
				lsearcher = searcher;
				searcher = searcher->square;
			}

			lsearcher = searcher->square;
		}
        
		chr = chr->next;
	}
	while(chr != NULL);
}

char attack(CHARACTER *attacker, CHARACTER *defender, char override)
{
	int attscore, defscore, dif, xdif, ydif;
	char ret, tval;

	if(!ptr_undead(attacker->model) && ptr_undead(defender->model))
		return 4;
	else
	{
		ret = 3;

		xdif = attacker->sqx - defender->sqx;
		ydif = attacker->sqy - defender->sqy;

		if( (abs(xdif) <= 1 && abs(ydif) <= 1) || (ptr_flying(attacker->model) && sqroot[xdif*xdif + ydif*ydif] <= (float)attacker->moves + 0.5f) || override)
		{
			attscore = (rand()%(  ptr_attack_rating(attacker->model) )+1)*3;
			defscore = (rand()%( ptr_defense_rating(defender->model) )+1)*2;

			attacker->moves = 0;
			attacker->attacked |= 1;

			ret = 2;

			if(attscore > defscore)
			{
				dif = attscore - defscore;

				if((defender->dead & LMASK) > dif)
				{
					tval = defender->dead & LMASK;
					tval -= dif;
					defender->dead &= ~LMASK;
					defender->dead += tval;
					ret = 1;
				}
				else
				{
					dead_animation(attacker, defender);
					move_model(defender->sqx, defender->sqy, attacker, FALSE);
					ret = 0;
				}
			}
		}
	}

//	search_squares(attacker);

	mcolour = 47;
	pauser = 1;
	switch(ret)
	{
		case 4 :
			sprintf(message, "Cannot Attack Undead");
		break;

		case 3 :
			sprintf(message, "Out of Range");
		break;

		case 2 :
			sprintf(message, "Attacked");
		break;

		case 1 :
			sprintf(message, "Attacked (hurt)");
		break;

		case 0 :
			sprintf(message, "Attacked (won)");
		break;
	}
     
	return ret;
}

char line_of_sight(CHARACTER *shooter, int pos)
{
	float addx, addy, addz, inx, iny, inz, endx, endy, endz, dist;
	int sqx, sqy, xdif, ydif, idist, lowdif, lowone, count2, newdif;
	char ret;

	sqx = board[pos].sq_x;
	sqy = board[pos].sq_y;

	xdif = shooter->sqx - sqx;
	ydif = shooter->sqy - sqy;

	dist = sqroot[xdif*xdif + ydif*ydif];

	inx = shooter->x;
	iny = shooter->y;
	inz = shooter->z;

	endx = board[pos].x;
	endy = board[pos].y;
	endz = board[pos].z;

	addx = (endx - inx) / dist;
	addy = (endy - iny) / dist;
	addz = (endz - inz) / dist;

	idist = I(dist);

	ret = TRUE;
	while(idist--)
	{
		lowone = numbsquares-1;
		lowdif =	(board[lowone].x - inx)*(board[lowone].x - inx) +
				(board[lowone].y - iny)*(board[lowone].y - iny) +
				(board[lowone].z - inz)*(board[lowone].z - inz);

		count2 = lowone;
		while(count2--)
		{
			newdif =	(board[count2].x - inx)*(board[count2].x - inx) +
					(board[count2].y - iny)*(board[count2].y - iny) +
					(board[count2].z - inz)*(board[count2].z - inz);

			if(newdif < lowdif)
			{
				lowdif = newdif;
				lowone = count2;
			}
		}
        
		if(	fabs(board[lowone].x - inx) < 5 && fabs(board[lowone].y - iny) < 5 &&
			fabs(board[lowone].z - inz) < 5)
			if(board[lowone].chr != NULL)
				if((board[lowone].chr->dead & LMASK) && board[lowone].chr != shooter)
					ret = FALSE;

		inx += addx;
		iny += addy;
		inz += addz;
	}

	return ret;
}

