/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "clip.h"
#include "chfileio.h"
#include "brfileio.h"
#include <time.h>
#include <string.h>

void increment_wait(void)
{
	pauser++;
}

END_OF_FUNCTION(increment_wait);

#ifdef WIN32
#ifndef CDS_FULLSCREEN
#define CDS_FULLSCREEN 4
#endif

char FindLowestFootprint(void)
{
	DEVMODE	devMode, bestMode;
	int		modeExist;
	int		modeSwitch;
	int		closeMode = 0;
	int		i, lowArea, Area;
	int		lowW, lowH, lowBPP;

	//first try 320x240x8

	EnumDisplaySettings(NULL, closeMode, &devMode);
	devMode.dmBitsPerPel = 8;
	devMode.dmPelsWidth  = 320;
	devMode.dmPelsHeight = 240;
	devMode.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
	modeSwitch = ChangeDisplaySettings(&devMode, CDS_FULLSCREEN);
	if(modeSwitch == DISP_CHANGE_SUCCESSFUL)
		return 0;

	devMode.dmFields = DM_BITSPERPEL;
	modeSwitch = ChangeDisplaySettings(&devMode, CDS_FULLSCREEN);
	
	devMode.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT;
	modeSwitch = ChangeDisplaySettings(&devMode, CDS_FULLSCREEN);
	if(modeSwitch == DISP_CHANGE_SUCCESSFUL)
		return 0;

	lowArea = GetSystemMetrics(SM_CXFULLSCREEN) * GetSystemMetrics(SM_CYFULLSCREEN) * 32;
	
	//notice that GetSystemMetrics will not report bits per pixel, but that 32 is the highest
	//possibility. If it is not actually the value for the current screen, then it will at least
	//be replaced by the correct value at some point during our enumeration
	//
	//I'm so confident of this, I leave bestMode, lowW, lowH and lowBPP undefined for now

	for (i=0; ;i++)
	{
		modeExist = EnumDisplaySettings(NULL, i, &devMode);

		if (!modeExist)
			break;

		Area = devMode.dmBitsPerPel * devMode.dmPelsWidth * devMode.dmPelsHeight;

		if (Area < lowArea)
		{
			lowArea = Area;
			bestMode = devMode;
			closeMode = i;
			lowBPP = devMode.dmBitsPerPel;
			lowW = devMode.dmPelsWidth;
			lowH = devMode.dmPelsHeight;
		}
	}

	modeSwitch = ChangeDisplaySettings(&bestMode, CDS_FULLSCREEN);

	if (modeSwitch==DISP_CHANGE_SUCCESSFUL)
		return 0;


	EnumDisplaySettings(NULL, closeMode, &devMode);
	devMode.dmBitsPerPel = lowBPP;
	devMode.dmPelsWidth  = lowW;
	devMode.dmPelsHeight = lowH;
	devMode.dmFields = DM_BITSPERPEL | DM_PELSWIDTH | DM_PELSHEIGHT;
	modeSwitch = ChangeDisplaySettings(&devMode, CDS_FULLSCREEN);
	if(modeSwitch == DISP_CHANGE_SUCCESSFUL)
		return 0;


	devMode.dmFields = DM_BITSPERPEL;
	modeSwitch = ChangeDisplaySettings(&devMode, CDS_FULLSCREEN);

	devMode.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT;
	modeSwitch = ChangeDisplaySettings(&devMode, CDS_FULLSCREEN);

	if(modeSwitch == DISP_CHANGE_SUCCESSFUL)
		return 0;

	return -1;
}
#endif

SHOT *allocate_shot(void)
{
	SHOT *temp;

	temp = malloc(sizeof(SHOT));
	temp->image = NULL;
        
	if(gfx_capabilities & GFX_HW_VRAM_BLIT)
	{
		temp->image = create_video_bitmap(WIDTH, HEIGHT);
	}

	if(!temp->image)
	{
		temp->image = create_bitmap(WIDTH, HEIGHT);
	}
	temp->depth = malloc(sizeof(float)*SIZE);

	return temp;
}

void clear_shot(SHOT *temp)
{
	clear(temp->image);
	memset(temp->depth, 0, SIZE*sizeof(float));
}

void free_shot(SHOT *worker)
{
	free(worker->depth);

//	if(!is_video_bitmap(worker->image))
		destroy_bitmap(worker->image);

	free(worker);
}

void end(void)
{
	int count;

	free_shot(view);
	free_shot(backup);
	free_shot(others);
	free_shot(boardonly);
	free(wizard);
	free(spells);

	destroy_bitmap(mouseover);

	if(map.numverts)
		free(map.verts);

	if(map.numpolys)
		free(map.polys);

	if(board != NULL)
	{
		free(board);
		free(sqroot);
	}

	if(map.numtexs)
	{
		count = map.numtexs;

		while(count--)
			destroy_bitmap(map.textures[count]);

		free(map.textures);
	}

	free(person);

	if(numcharacters)
	{
		count = numcharacters;

		while(count--)
		{
			free(allchars[count].polys);
			free(allchars[count].verts);
		}

		free(allchars);
	}

	if(functable)
		free(functable);

	if(starts)
		free(starts);

	free(pyramid_model.verts);
	free(pyramid_model.polys);

	unload_datafile(globdata);
}

void setup_sprites(void)
{
	mptr = NULL;

	if(gfx_capabilities & GFX_HW_VRAM_BLIT_MASKED)
	{
		mptr = create_video_bitmap(((BITMAP *)globdata[MPtr].dat)->w, ((BITMAP *)globdata[MPtr].dat)->h);

		if(mptr)
		{
			blit(globdata[MPtr].dat, mptr, 0, 0, 0, 0, mptr->w, mptr->h);
		}
	}

	if(!mptr)
		mptr = globdata[MPtr].dat;
}

int begin(void)
{
	int ret;
	FILE *stream;

	ret = 0;
	functable = NULL;

	allegro_init();
	
	if(install_timer())
		return 2;
		
	if(install_keyboard())
		return 1;

	if(install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL))
		return 4;

	#ifdef WIN32
	FindLowestFootprint();
	#endif
                 
	if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, WIDTH, HEIGHT, 0, 0))
		return 5;
		
	set_window_title("Anarchy - by Thomas Harte / SoftySoft");

	if(install_mouse() == -1)
		return 3;
		
	scr = create_video_bitmap(WIDTH, HEIGHT);
	show_video_bitmap(scr);
	board = NULL;

	chaoslaw = 0;

	functable = malloc(sizeof(func_ptr)*257); //one for each pallette colour + one for the SPECIAL key
                  
	map.numpolys = map.numverts = 0;

	view      = allocate_shot();
	backup    = allocate_shot();
	boardonly = allocate_shot();
	others    = allocate_shot();

	mouseover = create_bitmap(SCREEN_W, SCREEN_H);
	set_projection_viewport(0, 0, WIDTH-1, HEIGHT-1);
	text_mode(-1);
                  
	find_plane_equation(	+10, +10, +1,
							-10, +10, +1,
							-10, -10, +1,
							&cplanes[0]); //FRONT

	find_plane_equation(	-100, -100, +100,
							+10,  -10,  +10,
							-10,  -10,  +10,
							&cplanes[1]); //TOP

	find_plane_equation( 	-10,  10,  10,
							+10,  10,  10,
							-100, 100, 100,
							&cplanes[2]); //BOTTOM

	find_plane_equation(	100, 100, 100,
							10,  10,  10,
							10, -10,  10,
							&cplanes[3]); //RIGHT

	find_plane_equation(	-100, -100, 100,
							-10,  -10,  10,
							-10,   10,  10,
							&cplanes[4]); //LEFT

	numpeople = 0;

	numcharacters = 0;
	load_creatures();
                  
	srand(time(NULL));

	if(!(globdata = load_datafile("data.dat")))
		exit(99);

	pyramid_model.numverts = 4;
	pyramid_model.verts    = malloc(sizeof(VERTEX)*4);

	pyramid_model.verts[0].x = 0;
	pyramid_model.verts[0].y = -4;
	pyramid_model.verts[0].z = 5;

	pyramid_model.verts[1].x = 4.330127019;
	pyramid_model.verts[1].y = -4;
	pyramid_model.verts[1].z = -2.5;

	pyramid_model.verts[2].x = -4.330127019;
	pyramid_model.verts[2].y = -4;
	pyramid_model.verts[2].z = -2.5;

	pyramid_model.verts[3].x = 0;
	pyramid_model.verts[3].y = -5; //-6
	pyramid_model.verts[3].z = 0;
                     
	pyramid_model.numpolys = 4;
	pyramid_model.polys = malloc(sizeof(POLY)*4);
                  
	pyramid_model.polys[0].verts[2] = &pyramid_model.verts[0];
	pyramid_model.polys[0].verts[1] = &pyramid_model.verts[1];
	pyramid_model.polys[0].verts[0] = &pyramid_model.verts[2];

	pyramid_model.polys[1].verts[2] = &pyramid_model.verts[0];
	pyramid_model.polys[1].verts[1] = &pyramid_model.verts[3];
	pyramid_model.polys[1].verts[0] = &pyramid_model.verts[1];

	pyramid_model.polys[2].verts[2] = &pyramid_model.verts[1];
	pyramid_model.polys[2].verts[1] = &pyramid_model.verts[3];
	pyramid_model.polys[2].verts[0] = &pyramid_model.verts[2];

	pyramid_model.polys[3].verts[2] = &pyramid_model.verts[2];
	pyramid_model.polys[3].verts[1] = &pyramid_model.verts[3];
	pyramid_model.polys[3].verts[0] = &pyramid_model.verts[0];

	pyramid.model = &pyramid_model;
	pyramid.angle = 0;
	pyramid.dead = 1;
	setup_ready(&pyramid);
        
	stream = fopen("special/grave.chr", "rb");
	read_3dmodel(stream, &grave_model);
	fclose(stream);
	setup_ready_model(&grave_model);

	winner = 0;
	LOCK_VARIABLE(pauser);
	LOCK_FUNCTION(increment_wait);

	install_int_ex(increment_wait, BPS_TO_TIMER(256));
	setup_sprites();

	atexit(end);

	return 0;
}
