/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "menus.h"
#include "gengrap.h"
#include "misc3d.h"

void human_premovement(int wiz, unsigned char *selected, PALETTE *inverse)
{
	char *options[] = {"Select Spell", "Examine Board", "Continue Game"};
	char conse[20], title[50], leave;
	char *newlist[16];
	int count, codes[16];
   
	leave = FALSE;
	set_palette(mainpal);
      
	sprintf(conse, "Neutral");
   
	if(chaoslaw < 0)
		sprintf(conse, "Chaos : %d", 0-chaoslaw);
	if(chaoslaw > 0)
		sprintf(conse, "Law : %d", chaoslaw);

	sprintf(title, "(board %s), %s select :", conse, person[wizard[wiz]].model->name);
	selected[wiz] = 255;

	while(!leave)
	{
		clear(backup->image);
           
		switch(menu(title, options, 3, globdata[LFONT].dat, 163))
		{
			case 0 :
				count = spells[wiz][0];
                   
				while(count--)
				{
					codes[count] = spells[wiz][count+1];
					newlist[count] = allchars[spells[wiz][count+1]].name;
				}
                        
				selected[wiz] = spellselect(title, newlist, codes, spells[wiz][0], globdata[LFONT].dat, spells[wiz], 87);

				if(selected[wiz] != 255)
					selected[wiz]++;
			break;

			case 1 :
				clear_checks();
				clear_functable();
				functable[0] = NULL;
				mover = &person[wizard[wiz]];
				draw_other_players();
				draw_other_creations(mover);
				do_boardview(NULL);
			break;

			case 2 :
				leave = TRUE;
				set_palette(*inverse);
			break;
		}
	}
}

int do_c_disbelieve(int id, int wiznum, int x, int y)
{
	return 0;
}

int disbelieve(int sqx, int sqy, int sqid)
{
	if(board[sqid].chr->dead & 128)
	{
		dead_animation(board[sqid].chr, NULL);
	}
	return 0;
}

int do_disbelieve(int id, int wiznum)
{
	int c;
	
	clear_checks();
	clear_functable();


	c = numbsquares;
	while(c--)
		if(board[c].chr)
		{
			if((board[c].chr->owner & 127) != wiznum)
				board[c].check = ATTACK;
		}
	functable[ATTACK] = disbelieve;

	mover = &person[wizard[wiznum]];
	draw_other_players();
	draw_other_creations(mover);
	do_boardview(NULL);
	return 0;
}

void point_camera_at(CHARACTER *chr)
{
	char force;
   
	force = 0;

	if(map.cam->movable)
	{
		map.cam->inx = chr->x - map.cam->x;
		map.cam->iny = chr->y - map.cam->y;
		map.cam->inz = chr->z - map.cam->z;
              
		set_up_camera(map.cam);
		force = 1;
	}
     
	set_camera(map.cam, force);
}

void cmod_setup_squares(void *chrm)
{
}