/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "clip.h"
#include "fastgrap.h"
#include "slowgrap.h"
#include "init.h"
#include "main.h"
#include "menus.h"
#include "human.h"
#include <math.h>
#include <string.h>

void zline3d(SHOT *view, float x1, float y1, float z1, int colour1, float x2, float y2, float z2, int colour2)
{
	float check1, check2, ratio, zadd, *dptr;
	int pcount, intx1, intx2, inty1, inty2, xdif, ydif, sy, cadd;
	int iadd;
	char draw;

	apply_matrix_f(&map.cam->vision,  x1,  y1,  z1, &x1, &y1, &z1);
	apply_matrix_f(&map.cam->vision,  x2,  y2,  z2, &x2, &y2, &z2);

	pcount = 5;
	draw = TRUE;

	while(pcount-- && draw)
	{
		check1 = check_against_planexyz(x1, y1, z1, &cplanes[pcount]);
		check2 = check_against_planexyz(x2, y2, z2, &cplanes[pcount]);

		if(check1 < 0.0f && check2 < 0.0f)
			draw = FALSE;

		if(check1 < 0.0f && check2 >= 0.0f)
		{
			ratio	= calc_intersection(x2, y2, z2, x1, y1, z1, &cplanes[pcount]);
			x1		= midway(x2, x1, ratio);
			y1		= midway(y2, y1, ratio);
			z1		= midway(z2, z1, ratio);
		}

		if(check2 < 0.0f && check1 >= 0.0f)
		{
			ratio	= calc_intersection(x1, y1, z1, x2, y2, z2, &cplanes[pcount]);
			x2		= midway(x1, x2, ratio);
			y2		= midway(y1, y2, ratio);
			z2		= midway(z1, z2, ratio);
		}
	}

	persp_project_f(x1, y1, z1, &x1, &y1);
	z1 = 1.0f / z1;
	persp_project_f(x2, y2, z2, &x2, &y2);
	z2 = 1.0f / z2;

	intx1 = I(x1) << 16;
	inty1 = I(y1) << 16;
	intx2 = I(x2) << 16;
	inty2 = I(y2) << 16;

	colour1 <<= 16;
	colour2 <<= 16;

	xdif = intx2 - intx1;
	ydif = inty2 - inty1;

	if(abs(xdif) > abs(ydif))
	{
		//run along x
		if(xdif < 0)
		{
			zadd = z1;		z1		= z2;		z2		= zadd;
			iadd = intx1;	intx1	= intx2;	intx2	= iadd;
			iadd = inty1;	inty1	= inty2;	inty2	= iadd;
			cadd = colour1; colour1	= colour2;	colour2	= cadd;
			xdif = -xdif;
		}

		xdif >>= 16;
		intx1 >>= 16;
      
		cadd = (colour2 - colour1) / xdif;
		iadd = (inty2-inty1) / xdif;
		zadd = (z2-z1) / (float)xdif;

		while(xdif--)
		{
			sy = inty1 >> 16;
			dptr = &view->depth[(sy << SHIFT1) + (sy << SHIFT2) + intx1];

			if(z1 >= *dptr)
			{
				view->image->line[sy][intx1] = colour1 >> 16;
				*dptr = z1;
			}

			intx1	++;
			inty1	+= iadd;
			z1		+= zadd;
			colour1	+= cadd;
		}
	}
	else
	{
		//run along y
		if(ydif < 0)
		{
			zadd = z1;		z1		= z2;		z2		= zadd;
			iadd = intx1;	intx1	= intx2;	intx2	= iadd;
			iadd = inty1;	inty1	= inty2;	inty2	= iadd;
			cadd = colour1;	colour1	= colour2;	colour2	= cadd;
			ydif = -ydif;
		}

		ydif >>= 16;
		inty1 >>= 16;

		cadd = (colour2 - colour1) / ydif;
		iadd = (intx2-intx1) / ydif;
		zadd = (z2-z1) / (float)ydif;

		while(ydif--)
		{
			sy = intx1 >> 16;
			dptr = &view->depth[(inty1 << SHIFT1) + (inty1 << SHIFT2) + sy];

			if(z1 >= *dptr)
			{
				view->image->line[inty1][sy] = colour1 >> 16;
				*dptr = z1;
			}

			inty1	++;
			intx1	+= iadd;
			z1		+= zadd;
			colour1	+= cadd;
		}
	}
}

void circrectfill(BITMAP *bmp, int x1, int y1, int x2, int y2, int width, int colour)
{
	int inx1, iny1, inx2, iny2;

	inx1 = x1+width;
	iny1 = y1+width;
	inx2 = x2-width;
	iny2 = y2-width;

	rectfill( bmp, inx1,   y1, inx2,   y2, colour );
	rectfill( bmp,   x1, iny1, inx1, iny2, colour );
	rectfill( bmp, inx2, iny1,   x2, iny2, colour );

	circlefill( bmp, inx1, iny1, width, colour);
	circlefill( bmp, inx1, iny2, width, colour);
	circlefill( bmp, inx2, iny1, width, colour);
	circlefill( bmp, inx2, iny2, width, colour);
}

float check_reverse(	float x0, float y0, float z0,
						float x1, float y1, float z1,
						float x2, float y2, float z2)
{
	return	x2 * ((z0 * y1) - (y0 * z1)) +
			y2 * ((x0 * z1) - (z0 * x1)) +
			z2 * ((y0 * x1) - (x0 * y1));
}

void set_light_vector(float vectx, float vecty, float vectz)
{
	float multiplier;

	multiplier = 1.0f / sqrt(vectx*vectx + vecty*vecty + vectz*vectz);

	lightx = multiplier*vectx;
	lighty = multiplier*vecty;
	lightz = multiplier*vectz;

	olightx = lightx;
	olighty = lighty;
	olightz = lightz;
}

void add_wizard_plus_creations(SHOT *camera, int number)
{
	CHARACTER *chr;

	chr = &person[number];

	do
	{
		add_player(chr, camera, LIT);
		chr = chr->next;
	}
	while(chr != NULL);
}

void draw_other_players(void)
{
	int count;

	copy_buffer(boardonly, others);
	count = numwizards;

	while(count--)
		if(count != currentwiz && (person[wizard[count]].dead & LMASK))
			add_wizard_plus_creations(others, wizard[count]);
}

void prepare_scene(void)
{
	clear_shot(boardonly);
	clear(mouseover);
	renderscene();
}

void draw_pyramid(float x, float y, float z, int colour)
{
	pyramid.x = x;
	pyramid.y = y;
	pyramid.z = z;

	pyramid_model.polys[0].datas[0].c = colour;
	pyramid_model.polys[1].datas[0].c = colour;
	pyramid_model.polys[2].datas[0].c = colour;
	pyramid_model.polys[3].datas[0].c = colour;

	add_player(&pyramid, view, LIT);
}

void draw_all_creations(void)
{
	add_wizard_plus_creations(view, wizard[currentwiz]);
}

void draw_other_creations(CHARACTER *nonechr)
{
	CHARACTER *chr;

	copy_buffer(others, backup);
	chr = &person[wizard[currentwiz]];

	do
	{
		if(chr != nonechr)
			add_player(chr, backup, LIT);

		chr = chr->next;
	}
	while(chr != NULL);

	copy_buffer(backup, view);
}

#if GCC || DJGPP
void inline clear_checks(void)
#else
void clear_checks(void)
#endif
{
	int count;
   
	count = numbsquares;
	while(count--)
		board[count].check = 0;
}

#if GCC || DJGPP
void inline clear_functable(void)
#else
void clear_functable(void)
#endif
{
	memset(functable, 0, 257*sizeof(func_ptr));
}

int do_boardview(void (*extrafunc)(void))
{
	MATRIX_f rot;
	char mouseone, leave;
	unsigned char funcid;
   
	get_y_rotate_matrix_f(&rot, 5*fpsadjust);
	mouseone = leave = 0;
	seed_fpsadjuster();
	while(!leave && !globleave)
	{
		draw_realtime_scene();
		apply_matrix_f(&rot,	 lightx,  lighty,  lightz,
					&lightx, &lighty, &lightz);

		if(extrafunc)
			extrafunc();
                           
		if(key[KEY_SPACE])
		{
			fix_light();

			map.cam++;

			if(map.cam >= &map.camera[map.numcams] || map.cam < map.camera)
				map.cam = map.camera;

			point_camera_at(mover);
			draw_other_players();

			draw_other_creations(mover);
		}
        
		if(mouse_b & 1)
		{
			if(!mouseone)
			{
				message[0] = 0;
              
				mouseone = TRUE;

				funcid = board[mouse_xy].check;

				if(functable[funcid])
					leave = functable[funcid](mouse_sqx, mouse_sqy, mouse_xy);
			}
		}
		else
			mouseone = FALSE;

		if(mouse_b & 2)
		{
			message[0] = 0;
			leave = TRUE;
		}

		if(mouse_b & 4 || key[KEY_I] || key[KEY_ENTER])
		{
			if(board[mouse_xy].chr != NULL)
				if(board[mouse_xy].chr->dead & LMASK)
					info_screen(board[mouse_xy].chr->model);
		}

		if(key[KEY_S] && functable[SPECKEY])
		{
			leave = functable[SPECKEY](mouse_sqx, mouse_sqy, mouse_xy);
		}
	}
     
	do{}while(mouse_b);

	return leave;
}

void backup_camera(void)
{
	map.lastcam = map.cam;
}

void revert_to_last_camera(char force)
{
	if(map.cam != map.lastcam || force)
	{
		map.cam = map.lastcam;
		prepare_scene();
	}
}

void set_up_camera(CAMERA *cam)
{
	get_camera_matrix_f(&cam->vision, cam->x, cam->y, cam->z, cam->inx, cam->iny, cam->inz, cam->upx, cam->upy, cam->upz, cam->fov, 1);
}

void set_camera(CAMERA *cam, char force)
{
	if(cam != map.prevcam || force)
	{
		map.prevcam = map.cam;
		map.cam = cam;
		prepare_scene();
	}
}
