/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "gengrap.h"
#include "clip.h"
#include <string.h>

void copy_buffer(SHOT *src, SHOT *dest)
{
	blit(src->image, dest->image, 0, 0, 0, 0, WIDTH, HEIGHT);
	memcpy(&dest->depth[0], &src->depth[0], SIZE << 2);
}

void show_buffer(void)
{
	acquire_bitmap(scr);
	set_palette_range(mainpal, 16, 31, FALSE);
	set_palette_range(mainpal, 192, 207, FALSE);
	blit(view->image, scr, 0, 0, 0, 0, WIDTH, HEIGHT);
	release_bitmap(scr);
}

void fastpoly(float *inx, float *iny, float *z, unsigned char flag, SHOT *viewpoint)
{
	float	zl, zladd;
	float	zr, zradd;
	float	linez, linezadd, ydif;
	int	xl, xladd, xr, xradd;
	int	sy, test, target, end, top, bottom, vertr, vertl, fdif, len;
	int	x[3], y[3], topval, bottomval;
	unsigned long pptr;
	float	*dptr;
        
	acquire_bitmap(viewpoint->image);
	bmp_select(viewpoint->image);

	x[0] = I(inx[0]) << 16;
	x[1] = I(inx[1]) << 16;
	x[2] = I(inx[2]) << 16;

	y[0] = I(iny[0]);
	y[1] = I(iny[1]);
	y[2] = I(iny[2]);


	top = 0;
	topval = y[0];

	if(y[1] < y[0])
	{
		top = 1;
		topval = y[1];
	}

	if(y[2] < topval)
	{
		top = 2;
		topval = y[2];
	}

	bottom = 0;
	bottomval = y[0];

	if(y[1] > y[0])
	{
		bottom = 1;
		bottomval = y[1];
	}

	if(y[2] > bottomval)
	{
		bottom = 2;
		bottomval = y[2];
	}

	xl = xr = x[top];
	zl = zr = 1.0f    / z[top];
	sy      = y[top];

	vertl = top + 1;
	vertr = top - 1;

	valid_range(vertl);
	valid_range(vertr);

	ydif = iny[vertl] - iny[top];
	fdif = I(ydif);
	
	if(fdif)
	{
		zladd  = ((1.0f / z[vertl]) - zl) / ydif;
		xladd  = (x[vertl]          - xl) / fdif;
	}
	else
	{
		xl = x[vertl];
		zl = 1.0f / z[vertl];
		zladd = 0;
		xladd = 0;
	}
	target = y[vertl];

	ydif = iny[vertr] - iny[top];
	fdif = I(ydif);
	
	if(fdif)
	{
		zradd  = ((1.0f / z[vertr])   - zr) / ydif;
		xradd  = (x[vertr]            - xr) / fdif;
	}
	else
	{
		xr = x[vertr];
		zr = 1.0f / z[vertr];
		zradd = 0;
		xradd = 0;
	}

	test = y[vertr];

	if(test < target)
		target = test;

	end = y[bottom];

	while(sy < end)
	{
		while(sy < target)
		{
			if(xl < xr)
			{
				len  = ((xr - xl) >> 16)+1;
				pptr = bmp_write_line(viewpoint->image, sy);
				pptr += (xl >> 16);
				dptr = &viewpoint->depth[(sy << SHIFT1) + (sy << SHIFT2) + (xl >> 16)];
				linez = zl;
				linezadd = zr - zl;
			}
			else
			{
				len  = ((xl - xr) >> 16)+1;
				pptr = bmp_write_line(viewpoint->image, sy);
				pptr += (xr >> 16);
				dptr = &viewpoint->depth[(sy << SHIFT1) + (sy << SHIFT2) + (xr >> 16)];
				linez = zr;
				linezadd = zl - zr;
			}

			if(len)
			{
				linezadd /= (float)len;

				while(len-- > 0)
				{
					if(linez >= *dptr)
					{
						bmp_write8(pptr, flag);
						*dptr = linez;
					}

					pptr++;
					dptr++;

					linez += linezadd;
				}
			}

			xl += xladd;
			zl += zladd;

			xr += xradd;
			zr += zradd;
			bmp_unwrite_line(viewpoint->image);
			sy++;
		}

		if(sy != end)
		{
			target = end;

			if(vertr == bottom)
			{
				xl = x[vertl];
				zl = 1.0f / z[vertl];

				ydif = iny[bottom] - iny[vertl];
				fdif = I(ydif);
				if(fdif)
				{
					zladd  = ((1.0f / z[bottom])   - zl) / ydif;
					xladd  = (x[bottom]            - xl) / fdif;
				}
			}
			else
			{
				xr = x[vertr];
				zr = 1.0f / z[vertr];

				ydif = iny[bottom] - iny[vertr];
				fdif = I(ydif);
				if(fdif)
				{
					zradd  = ((1.0f / z[bottom])   - zr) / ydif;
					xradd  = (x[bottom]            - xr) / fdif;
				}
			}
		}
	}
	release_bitmap(viewpoint->image);
}

void dofastpoly(POLY *polygon, SHOT *viewpoint, unsigned char cursor)
{
	float x[3], y[3], z[3];
	VERTEX **lvert, *dvert;
	unsigned char colour;
	float dotprod;

	if(check_reverse(	polygon->verts[0]->wx, polygon->verts[0]->wy, polygon->verts[0]->wz,
				polygon->verts[1]->wx, polygon->verts[1]->wy, polygon->verts[1]->wz,
				polygon->verts[2]->wx, polygon->verts[2]->wy, polygon->verts[2]->wz) < 0)
	{
		colour = polygon->datas[0].c;

		if(cursor != STATED && cursor != LIT)
			colour = cursor;

		if(cursor != STATED)
		{
			dotprod = (polygon->wx * lightx) + (polygon->wy * lighty) + (polygon->wz * lightz);

			if(dotprod > 0)
				colour += I(dotprod*15);
		}

		if(	polygon->verts[0]->awkward == FALSE &&
			polygon->verts[1]->awkward == FALSE &&
			polygon->verts[2]->awkward == FALSE)
		{
			lvert = &polygon->verts[0];
			dvert = *lvert;
			x[0] = dvert->sx;
			y[0] = dvert->sy;
			z[0] = dvert->wz;

			lvert++;
			dvert = *lvert;
			x[1] = dvert->sx;
			y[1] = dvert->sy;
			z[1] = dvert->wz;

			lvert++;
			dvert = *lvert;
			x[2] = dvert->sx;
			y[2] = dvert->sy;
			z[2] = dvert->wz;

			fastpoly(x, y, z, colour, viewpoint);
		}
		else
			clipfastpoly(polygon, colour, viewpoint);
	}
}

void add_player(CHARACTER *bloke, SHOT *viewpoint, unsigned char cursor)
{
	int count;
	CHARACTER_MODEL *mdl;
	MATRIX_f one, two, total;
	float angle;

	mdl = bloke->model;
	angle = bloke->angle;

	if(!(bloke->dead & LMASK))
	{
		mdl = &grave_model;
		angle = 0;
	}
        
	get_translation_matrix_f(&one, bloke->x, bloke->y, bloke->z);
	get_y_rotate_matrix_f(&two, angle);

	count = mdl->numpolys;
	while(count--)
		apply_matrix_f(&two,	 mdl->polys[count].cx,  mdl->polys[count].cy,  mdl->polys[count].cz,
						&mdl->polys[count].wx, &mdl->polys[count].wy, &mdl->polys[count].wz);

	matrix_mul_f(&two, &one, &total);
	two = total;
	matrix_mul_f(&two, &map.cam->vision, &total);
   
	count = mdl->numverts;
	while(count--)
	{
		apply_matrix_f(&total,	 mdl->verts[count].x,   mdl->verts[count].y,   mdl->verts[count].z,
						&mdl->verts[count].wx, &mdl->verts[count].wy, &mdl->verts[count].wz);

		if(	(check_against_plane(&mdl->verts[count], &cplanes[0]) > 0) &&
			(check_against_plane(&mdl->verts[count], &cplanes[1]) > 0) &&
			(check_against_plane(&mdl->verts[count], &cplanes[2]) > 0) &&
			(check_against_plane(&mdl->verts[count], &cplanes[3]) > 0) &&
			(check_against_plane(&mdl->verts[count], &cplanes[4]) > 0))
		{
			persp_project_f(	 mdl->verts[count].wx,  mdl->verts[count].wy,  mdl->verts[count].wz,
						&mdl->verts[count].sx, &mdl->verts[count].sy);

			mdl->verts[count].awkward = FALSE;
		}
		else
			mdl->verts[count].awkward = TRUE;
	}

	count = mdl->numpolys;

	acquire_bitmap(viewpoint->image);
	while(count--)
		dofastpoly(&mdl->polys[count], viewpoint, cursor);
	release_bitmap(viewpoint->image);
}
