/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "probfunc.h"

void plot_movement_circle(int add, int radius, int x, int y, char mul) //adds 'add' to board[n].check where n = every value in range radius of x,y
{
	int count, difx, dify;
	float dist;

	count = numbsquares;
	while(count--)
	{
		difx = board[count].sq_x - x;
		dify = board[count].sq_y - y;

                dist = sqroot[difx*difx + dify*dify];

		if(dist <= radius)
		{
                        if(mul)
				board[count].data += add*(50/dist);
                        else
				board[count].data += add;
		}
	}
}

int mod_comp_taintcircle(void *chr)
{
        int score;
        score = ptr_attack_rating(((CHARACTER *)chr)->model);

        if(((CHARACTER *)chr)->owner & 128)
                score *= 2;

	plot_movement_circle(score, ptr_movement_rating(((CHARACTER *)chr)->model), ((CHARACTER *)chr)->sqx, ((CHARACTER *)chr)->sqy, 1);
	return 0;
}

int mod_comp_untaintcircle(void *chr)
{
	plot_movement_circle(-(ptr_defense_rating(((CHARACTER *)chr)->model) >> 1), ptr_movement_rating(((CHARACTER *)chr)->model), ((CHARACTER *)chr)->sqx, ((CHARACTER *)chr)->sqy, 0);
	return 0;
}

void computer_premovement(int wiz, unsigned char *selected, PALETTE *inverse)
{
	//JUST CAST THE STRONGEST for now
	int highstr, str, highone, count;

	highone = 1;
	highstr = 0;
	for(count = 2; count < spells[wiz][0]; count++)
	{
		str = (attack_rating(allchars[spells[wiz][count]]) + defense_rating(allchars[spells[wiz][count]])) * probability(spells[wiz][count]);
		if(str > highstr)
		{
			highstr = str;
			highone = count;
		}
	}

	selected[wiz] = highone;
	if(probability(spells[wiz][highone]) < 3 + rand()%3 && rand()%3)
		selected[wiz] |= 128;
	
	if(spells[wiz][0] < 5 && rand()%4)
		selected[wiz] = 1;
}
