/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "slowgrap.h"
#include "fastgrap.h"
#include <string.h>

float midway(float val1, float val2, float ratio)
{
	return	(
				((val2 - val1) * ratio)
			) + val1;
}

void find_plane_equation( float x1, float y1, float z1,
                          float x2, float y2, float z2,
                          float x3, float y3, float z3,
                          PLANE *cplane)
{
	cplane->a =		y1 * (z2 - z3) + y2 * (z3 - z1) + y3 * (z1 - z2);
	cplane->b =		z1 * (x2 - x3) + z2 * (x3 - x1) + z3 * (x1 - x2);
	cplane->c =		x1 * (y2 - y3) + x2 * (y3 - y1) + x3 * (y1 - y2);
	cplane->d =- (	x1 * ((y2 * z3) - (y3 * z2)) +
					x2 * ((y3 * z1) - (y1 * z3)) +
					x3 * ((y1 * z2) - (y2 * z1)) );
}

float calc_intersection( float x1, float y1, float z1,
                         float x2, float y2, float z2,
                         PLANE *cplane)
{
	return	(cplane->a*x1        + cplane->b*y1        + cplane->c*z1 + cplane->d) /
			(cplane->a*(x1 - x2) + cplane->b*(y1 - y2) + cplane->c*(z1 - z2));
}

float check_against_plane(VERTEX *point, PLANE *cplane)
{
	return	cplane->a*point->wx +
			cplane->b*point->wy +
			cplane->c*point->wz +
			cplane->d;
}

float check_against_planexyz(float x, float y, float z, PLANE *cplane)
{
	return	cplane->a*x +
			cplane->b*y +
			cplane->c*z +
			cplane->d;
}

void clipslowpoly(POLY *polygon)
{
	float x[8], y[8], z[8], u[8], v[8], ratio;
	float sx[8], sy[8], sz[8], su[8], sv[8], check1, check2;
	float passx[3], passy[3], passz[3], passu[3], passv[3];
	VERTEX **lvert, *dvert;
	POLYDATA *ldata;
	int pcount, num, ccount, ccount2, nnum;

	lvert = &polygon->verts[0];
	ldata = &polygon->datas[0];
	dvert = *lvert;
	x[0] = dvert->wx;
	y[0] = dvert->wy;
	z[0] = dvert->wz;
	u[0] = ldata->u;
	v[0] = ldata->v;

	lvert++;
	ldata++;
	dvert = *lvert;
	x[1] = dvert->wx;
	y[1] = dvert->wy;
	z[1] = dvert->wz;
	u[1] = ldata->u;
	v[1] = ldata->v;

	lvert++;
	ldata++;
	dvert = *lvert;
	x[2] = dvert->wx;
	y[2] = dvert->wy;
	z[2] = dvert->wz;
	u[2] = ldata->u;
	v[2] = ldata->v;

	num = 3;

	pcount = 5;
	while(pcount--)
	{
		nnum = 0;

		for(ccount = 0; ccount < num; ccount ++)
		{
			ccount2 = ccount + 1;

			if(ccount2 < 0)
				ccount2 = num-1;

			if(ccount2 >= num)
				ccount2 = 0;

			check1 = check_against_planexyz(x[ccount],  y[ccount],  z[ccount],  &cplanes[pcount]);
			check2 = check_against_planexyz(x[ccount2], y[ccount2], z[ccount2], &cplanes[pcount]);

			if(check1 >= 0.0f)
			{
				sx[nnum] = x[ccount];
				sy[nnum] = y[ccount];
				sz[nnum] = z[ccount];
				su[nnum] = u[ccount];
				sv[nnum] = v[ccount];
				nnum++;

				if(check2 < 0.0f)
				{
					ratio = calc_intersection(	x[ccount2], y[ccount2], z[ccount2],
												x[ccount],  y[ccount],  z[ccount],
												&cplanes[pcount]);

					sx[nnum] = midway(x[ccount2], x[ccount], ratio);
					sy[nnum] = midway(y[ccount2], y[ccount], ratio);
					sz[nnum] = midway(z[ccount2], z[ccount], ratio);
					su[nnum] = midway(u[ccount2], u[ccount], ratio);
					sv[nnum] = midway(v[ccount2], v[ccount], ratio);
					nnum++;
				}
			}
			else
				if(check2 > 0.0f)
				{
					ratio = calc_intersection(	x[ccount],  y[ccount],  z[ccount],
												x[ccount2], y[ccount2], z[ccount2],
												&cplanes[pcount]);

					sx[nnum] = midway(x[ccount], x[ccount2], ratio);
					sy[nnum] = midway(y[ccount], y[ccount2], ratio);
					sz[nnum] = midway(z[ccount], z[ccount2], ratio);
					su[nnum] = midway(u[ccount], u[ccount2], ratio);
					sv[nnum] = midway(v[ccount], v[ccount2], ratio);
					nnum++;
				}
		}

		num = nnum;
		memcpy(x, sx, 32); //32 = sizeof(float)*8 = 4*8
		memcpy(y, sy, 32);
		memcpy(z, sz, 32);
		memcpy(u, su, 32);
		memcpy(v, sv, 32);
	}

	nnum = num;
	while(nnum--)
		persp_project_f( x[nnum],  y[nnum],  z[nnum], &x[nnum], &y[nnum]);

	if(num >= 3)
	{
		passx[2] = x[num-1];
		passy[2] = y[num-1];
		passz[2] = z[num-1];
		passu[2] = u[num-1];
		passv[2] = v[num-1];

		for(nnum = 0; nnum < num-2; nnum++)
		{
			passx[0] = x[nnum];
			passy[0] = y[nnum];
			passz[0] = z[nnum];
			passu[0] = u[nnum];
			passv[0] = v[nnum];

			passx[1] = x[nnum+1];
			passy[1] = y[nnum+1];
			passz[1] = z[nnum+1];
			passu[1] = u[nnum+1];
			passv[1] = v[nnum+1];

			slowpoly(passx, passy, passz, passu, passv, polygon->datas[0].c, polygon->tex);
		}
	}
}

void clipfastpoly(POLY *polygon, unsigned char colour, SHOT *viewpoint)
{
	float x[8], y[8], z[8], ratio;
	float sx[8], sy[8], sz[8], check1, check2;
	float passx[3], passy[3], passz[3];
	VERTEX **lvert, *dvert;
	POLYDATA *ldata;
	int pcount, num, ccount, ccount2, nnum;

	lvert = &polygon->verts[0];
	ldata = &polygon->datas[0];
	dvert = *lvert;
	x[0] = dvert->wx;
	y[0] = dvert->wy;
	z[0] = dvert->wz;

	lvert++;
	ldata++;
	dvert = *lvert;
	x[1] = dvert->wx;
	y[1] = dvert->wy;
	z[1] = dvert->wz;

	lvert++;
	ldata++;
	dvert = *lvert;
	x[2] = dvert->wx;
	y[2] = dvert->wy;
	z[2] = dvert->wz;

	num = 3;

	pcount = 5;
	while(pcount--)
	{
		nnum = 0;

		for(ccount = 0; ccount < num; ccount ++)
		{
			ccount2 = ccount + 1;

			if(ccount2 < 0)
				ccount2 = num-1;

			if(ccount2 >= num)
				ccount2 = 0;

			check1 = check_against_planexyz(x[ccount],  y[ccount],  z[ccount],  &cplanes[pcount]);
			check2 = check_against_planexyz(x[ccount2], y[ccount2], z[ccount2], &cplanes[pcount]);

			if(check1 >= 0)
			{
				sx[nnum] = x[ccount];
				sy[nnum] = y[ccount];
				sz[nnum] = z[ccount];
				nnum++;

				if(check2 < 0)
				{
					ratio = calc_intersection(	x[ccount2], y[ccount2], z[ccount2],
												x[ccount],  y[ccount],  z[ccount],
												&cplanes[pcount]);

					sx[nnum] = midway(x[ccount2], x[ccount], ratio);
					sy[nnum] = midway(y[ccount2], y[ccount], ratio);
					sz[nnum] = midway(z[ccount2], z[ccount], ratio);
					nnum++;
				}
			}
			else
				if(check2 > 0)
				{
					ratio = calc_intersection(	x[ccount],  y[ccount],  z[ccount],
												x[ccount2], y[ccount2], z[ccount2],
												&cplanes[pcount]);

					sx[nnum] = midway(x[ccount], x[ccount2], ratio);
					sy[nnum] = midway(y[ccount], y[ccount2], ratio);
					sz[nnum] = midway(z[ccount], z[ccount2], ratio);
					nnum++;
				}
		}

		num = nnum;
		memcpy(x, sx, 32);
		memcpy(y, sy, 32);
		memcpy(z, sz, 32);
	}

	nnum = num;
	while(nnum--)
		persp_project_f( x[nnum],  y[nnum],  z[nnum], &x[nnum], &y[nnum]);

	for(nnum = 0; nnum < num-2; nnum++)
	{
		passx[0] = x[nnum];
		passx[1] = x[nnum+1];
		passx[2] = x[num-1];

		passy[0] = y[nnum];
		passy[1] = y[nnum+1];
		passy[2] = y[num-1];

		passz[0] = z[nnum];
		passz[1] = z[nnum+1];
		passz[2] = z[num-1];

		fastpoly(passx, passy, passz, colour, viewpoint);
	}
}
