/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "movefunc.h"
#include "castfunc.h"
#include "probfunc.h"
#include "compfunc.h"
#include "logic.h"
#include "cmods.h"
#include <string.h>
#include <math.h>

struct name
{
	struct name *next;
	char *name;
};

struct name *filelist, *cfile;

short get_short(FILE *stream)
{
	short ret;
	ret = fgetc(stream);
	ret |= fgetc(stream) << 8;
	return ret;
}

float get_float(FILE *stream)
{
	/* assume a four byte array named Float exists, where Float[0]
	was the first byte read from the UEF, Float[1] the second, etc */
	unsigned char Float[4];
	Float[0] = fgetc(stream);
	Float[1] = fgetc(stream);
	Float[2] = fgetc(stream);
	Float[3] = fgetc(stream);

	/* decode mantissa */
	unsigned int Mantissa;
	Mantissa = Float[0] | (Float[1] << 8) | ((Float[2]&0x7f)|0x80) << 16;

	float Result = (float)Mantissa;
	Result = (float)ldexp(Result, -23);

	/* decode exponent */
	int Exponent;
	Exponent = ((Float[2]&0x80) >> 7) | (Float[3]&0x7f) << 1;
	Exponent -= 127;
	Result = (float)ldexp(Result, Exponent);

	/* flip sign if necessary */
	if(Float[3]&0x80)
		Result = -Result;

	/* floating point number is now in 'Result' */
	return Result;
}

void read_3dmodel(FILE *stream, CHARACTER_MODEL *chr)
{
	short temp, vert;
	unsigned char tempc;

	fseek(stream, 26, SEEK_SET);

//	fread(&temp, sizeof(short), 1, stream);
	temp = get_short(stream);

	chr->numverts = temp;
	chr->verts = malloc(sizeof(VERTEX)*chr->numverts);

	for(temp = 0; temp < chr->numverts; temp++)
	{
		chr->verts[temp].x = get_float(stream);
		chr->verts[temp].y = get_float(stream);
		chr->verts[temp].z = get_float(stream);
//		fread(&chr->verts[temp].x, sizeof(float), 1, stream);
//		fread(&chr->verts[temp].y, sizeof(float), 1, stream);
//		fread(&chr->verts[temp].z, sizeof(float), 1, stream);
	}

//	fread(&temp, sizeof(short), 1, stream);
	temp = get_short(stream);
	chr->numpolys = temp;
	chr->polys = malloc(sizeof(POLY)*chr->numpolys);

	for(temp = 0; temp < chr->numpolys; temp++)
	{
//		fread(&vert, sizeof(short), 1, stream);
		vert = get_short(stream);
		chr->polys[temp].verts[2] = &chr->verts[vert];
//		fread(&vert, sizeof(short), 1, stream);
		vert = get_short(stream);
		chr->polys[temp].verts[1] = &chr->verts[vert];
//		fread(&vert, sizeof(short), 1, stream);
		vert = get_short(stream);
		chr->polys[temp].verts[0] = &chr->verts[vert];

		fread(&tempc, sizeof(char), 1, stream);

		chr->polys[temp].datas[0].c = (tempc*16)+16;
	}
}

void default_3dmodel(CHARACTER_MODEL *chr)
{
	chr->numverts = 4;
	chr->verts = malloc(sizeof(VERTEX)*chr->numverts);

	chr->verts[0].x = 0;
	chr->verts[0].y = 5;
	chr->verts[0].z = 0;

	chr->verts[1].x = 0;
	chr->verts[1].y = -5;
	chr->verts[1].z = 5;

	chr->verts[2].x = 4.330127;
	chr->verts[2].y = -5;
	chr->verts[2].z = -2.5;

	chr->verts[3].x = -4.330127;
	chr->verts[3].y = -5;
	chr->verts[3].z = -2.5;

	chr->numpolys = 4;
	chr->polys    = malloc(sizeof(POLY)*chr->numpolys);

	chr->polys[0].verts[0]   = &chr->verts[2];
	chr->polys[0].verts[1]   = &chr->verts[1];
	chr->polys[0].verts[2]   = &chr->verts[0];
	chr->polys[0].datas[0].c = 144;

	chr->polys[1].verts[0]   = &chr->verts[3];
	chr->polys[1].verts[1]   = &chr->verts[2];
	chr->polys[1].verts[2]   = &chr->verts[0];
	chr->polys[1].datas[0].c = 80;

	chr->polys[2].verts[0]   = &chr->verts[1];
	chr->polys[2].verts[1]   = &chr->verts[3];
	chr->polys[2].verts[2]   = &chr->verts[0];
	chr->polys[2].datas[0].c = 128;

	chr->polys[3].verts[0]   = &chr->verts[1];
	chr->polys[3].verts[1]   = &chr->verts[2];
	chr->polys[3].verts[2]   = &chr->verts[3];
	chr->polys[3].datas[0].c = 192;
}

/*char *extension(char *text)
{
	char *ext;

	ext = text + strlen(text) - 1;
	while(*ext != '.')
		ext--;

	return ext;
}*/

void setup_procs(CHARACTER_MODEL *chrm)
{
/*	if(ptr_uses_z80(chrm))
	{
		allchars[numcharacters].probfunc = z80_probfunc;
		allchars[numcharacters].keepalive = z80_keepalive;
		allchars[numcharacters].taint = z80_taint;
		allchars[numcharacters].untaint = z80_untaint;
	}
	else*/
	{
		chrm->probfunc = mod_prob_normal;
		chrm->keepalive = cmod_keepalive;
		chrm->taint = mod_comp_taintcircle;
		chrm->untaint = mod_comp_untaintcircle;

		if(ptr_flying(chrm))
		{
			chrm->computer_move = mod_move_compmove_fly;
			chrm->setup_move = mod_move_setup_fly;
		}
		else
		{
			chrm->computer_move = mod_move_compmove_walker;
			chrm->setup_move = mod_move_setup_walker;
		}

		switch(returntype(chrm))
		{
			case PERSON :
				chrm->setup_cast = mod_hcast_creature;
				chrm->computer_cast = mod_ccast_creature;
			break;

			case BEAM :
				chrm->setup_cast = mod_hcast_beam;
				chrm->computer_cast = mod_ccast_beam;
			break;
                        
			case BLOB :
				chrm->setup_cast = mod_hcast_blob;
				chrm->computer_cast = mod_ccast_blob;
				chrm->probfunc = mod_prob_blob;
				chrm->keepalive = cmod_grow;
			break;
		}
	}
}

void incnumcharacters(const char *filename, int attrib, int param)
{
	numcharacters++;
	cfile = cfile->next;
	cfile->name = strdup(filename);
	cfile->next = malloc(sizeof(struct name));
}

void free_name_list(struct name *list)
{
	struct name *next;

	while(list)
	{
		next = list->next;
		free(list->name);
		free(list);
		list = next;
	}
}
        
int load_creatures(void)
{
	FILE *fstream;

	numcharacters = 0;
	cfile = filelist = malloc(sizeof(struct name));
	cfile->next = cfile;
	for_each_file("creature/*.chr", 0, incnumcharacters, 0);
	free(cfile->next);
	cfile->next = NULL;

	allchars = malloc(sizeof(CHARACTER_MODEL)*(numcharacters+EXTRAMODS));

	allchars[0].polys = malloc(sizeof(POLY)*6);
	allchars[0].numpolys = 6;
	allchars[0].verts = malloc(sizeof(VERTEX)*8);
	allchars[0].numverts = 8;

	allchars[0].polys[0].verts[0] = &allchars[0].verts[0];
	allchars[0].polys[0].verts[1] = &allchars[0].verts[2];
	allchars[0].polys[0].verts[2] = &allchars[0].verts[3];

	allchars[0].polys[1].verts[0] = &allchars[0].verts[0];
	allchars[0].polys[1].verts[1] = &allchars[0].verts[1];
	allchars[0].polys[1].verts[2] = &allchars[0].verts[2];

	allchars[0].polys[2].verts[0] = &allchars[0].verts[3];
	allchars[0].polys[2].verts[1] = &allchars[0].verts[7];
	allchars[0].polys[2].verts[2] = &allchars[0].verts[0];

	allchars[0].polys[3].verts[0] = &allchars[0].verts[0];
	allchars[0].polys[3].verts[1] = &allchars[0].verts[4];
	allchars[0].polys[3].verts[2] = &allchars[0].verts[1];

	allchars[0].polys[4].verts[0] = &allchars[0].verts[1];
	allchars[0].polys[4].verts[1] = &allchars[0].verts[5];
	allchars[0].polys[4].verts[2] = &allchars[0].verts[2];

	allchars[0].polys[5].verts[0] = &allchars[0].verts[2];
	allchars[0].polys[5].verts[1] = &allchars[0].verts[6];
	allchars[0].polys[5].verts[2] = &allchars[0].verts[3];

	allchars[0].polys[0].datas[0].c = 117;
	allchars[0].polys[1].datas[0].c = 117;
	allchars[0].polys[2].datas[0].c = 113; //127, 127, 151, 175, 151, 175
	allchars[0].polys[3].datas[0].c = 127;
	allchars[0].polys[4].datas[0].c = 113;
	allchars[0].polys[5].datas[0].c = 127;

	allchars[0].verts[0].x = -5;
	allchars[0].verts[0].y = -3;
	allchars[0].verts[0].z = -5;

	allchars[0].verts[1].x =  5;
	allchars[0].verts[1].y = -3;
	allchars[0].verts[1].z = -5;

	allchars[0].verts[2].x =  5;
	allchars[0].verts[2].y = -3;
	allchars[0].verts[2].z =  5;

	allchars[0].verts[3].x = -5;
	allchars[0].verts[3].y = -3;
	allchars[0].verts[3].z =  5;

	allchars[0].verts[4].x =  0;
	allchars[0].verts[4].y = -5;
	allchars[0].verts[4].z = -5;

	allchars[0].verts[5].x =  5;
	allchars[0].verts[5].y = -5;
	allchars[0].verts[5].z =  0;

	allchars[0].verts[6].x =  0;
	allchars[0].verts[6].y = -5;
	allchars[0].verts[6].z =  5;

	allchars[0].verts[7].x = -5;
	allchars[0].verts[7].y = -5;
	allchars[0].verts[7].z =  0;

	numcharacters = 1;
	while(numcharacters < 9)
	{
		default_3dmodel(&allchars[numcharacters]);
		allchars[numcharacters].movement = (1 << 3);
		allchars[numcharacters].flags = 0;
		allchars[numcharacters].projectile = 0;
		setup_procs(&allchars[numcharacters]);

		numcharacters++;
	}

	//disbelieve
	allchars[numcharacters].setup_cast = mod_hcast_disbelieve;
	allchars[numcharacters].computer_cast = mod_ccast_disbelieve;
	allchars[numcharacters].probfunc = mod_prob_hundred;
	default_3dmodel(&allchars[numcharacters]);
	sprintf(allchars[numcharacters].name, "Disbelieve");
	numcharacters++;

	cfile = filelist;

	while(cfile)
	{
		if((fstream = fopen(cfile->name, "rb")))
		{
			fread(&allchars[numcharacters].name,       sizeof(char),          21, fstream);
			fread(&allchars[numcharacters].flags,      sizeof(unsigned char),  1, fstream);
			fread(&allchars[numcharacters].ratings,    sizeof(unsigned char),  1, fstream);
			fread(&allchars[numcharacters].movement,   sizeof(unsigned char),  1, fstream);
			fread(&allchars[numcharacters].resist,     sizeof(unsigned char),  1, fstream);
			fread(&allchars[numcharacters].projectile, sizeof(unsigned char),  1, fstream);

			if(fgetc(fstream) == EOF)
			{
				fclose(fstream);
				default_3dmodel(&allchars[numcharacters]);
			}
			else
			{
				read_3dmodel(fstream, &allchars[numcharacters]);
				fclose(fstream);
			}

			setup_procs(&allchars[numcharacters]);
			
			numcharacters++;
		}
			
		cfile = cfile->next;
	}

	person = malloc(sizeof(CHARACTER)*301); //8 players * 16 spells = 128 spells, + 10 extras = 138, = 164 spare. Quite arbitrarily
	numpeople = 0;

	if(numcharacters == EXTRAMODS)
	{
		printf("All creature files corrupt! (or missing)");
		exit(1);
	}
	
	free_name_list(filelist);
	
	return 0;
}

void setup_ready_model(CHARACTER_MODEL *mdl)
{
	int pcount;
	double x1, x2, x3;
	double y1, y2, y3;
	double z1, z2, z3;
	double multiplier, nx, ny, nz;

	pcount = mdl->numpolys;

	while(pcount--)
	{
		x1 = mdl->polys[pcount].verts[0]->x;
		x2 = mdl->polys[pcount].verts[1]->x;
		x3 = mdl->polys[pcount].verts[2]->x;

		y1 = mdl->polys[pcount].verts[0]->y;
		y2 = mdl->polys[pcount].verts[1]->y;
		y3 = mdl->polys[pcount].verts[2]->y;

		z1 = mdl->polys[pcount].verts[0]->z;
		z2 = mdl->polys[pcount].verts[1]->z;
		z3 = mdl->polys[pcount].verts[2]->z;

		nx = ((y1 - y2) * (z1 - z3)) - ((z1 - z2) * (y1 - y3));
		ny = ((z1 - z2) * (x1 - x3)) - ((x1 - x2) * (z1 - z3));
		nz = ((x1 - x2) * (y1 - y3)) - ((y1 - y2) * (x1 - x3));

		multiplier = 1.0f / sqrt(nx*nx + ny*ny + nz*nz);

		mdl->polys[pcount].cx = multiplier * nx;
		mdl->polys[pcount].cy = multiplier * ny;
		mdl->polys[pcount].cz = multiplier * nz;
	}
}

void setup_ready(CHARACTER *bloke)
{
	setup_ready_model(bloke->model);
}

int setup_character(unsigned char num)
{
	person[numpeople].x = 0;
	person[numpeople].y = 0;
	person[numpeople].z = 0;
	person[numpeople].angle = 0;
	person[numpeople].next = NULL;
	person[numpeople].dead = defense_rating(allchars[num]); //|=

	person[numpeople].model = &allchars[num];

	person[numpeople].owner = WIZARD | 0;
        
	numpeople++;
	return numpeople-1;
}

int load_character(unsigned char num)
{
	int val;
	val = setup_character(num);
	setup_ready(&person[val]);
	return val;
}

