/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "human.h"
#include "gengrap.h"
#include "misc3d.h"
#include "logic.h"

CAMERA castview;

int mod_cast_creature_docast(int sqx, int sqy, int sqid)
{
	int id, ret;

	id = board[sqid].data;
	ret= cast_creature(sqx, sqy, sqid, id, 0) + 3;
	revert_to_last_camera(0);
		
	return ret;
}

int mod_cast_creature_docast_illus(int sqx, int sqy, int sqid)
{
	int id, ret;

	id = board[sqid].data;
	ret= cast_creature(sqx, sqy, sqid, id, 1) + 3;
	revert_to_last_camera(0);
		
	return ret;
}

int mod_hcast_creature(int id)
{
	int count, wiznum;
	
	wiznum = mover->owner & 127;
	backup_camera();
	
	castview.x = mover->x;
	castview.y = mover->y + 40;
	castview.z = mover->z;
	castview.inx = 0;
	castview.iny = -1;
	castview.inz = 0;
	castview.upx = 0;
	castview.upy = 0;
	castview.upz = 1;
	castview.fov = 60;
	set_up_camera(&castview);
	set_camera(&castview, 1);
	draw_other_players();
	draw_other_creations(mover);
	
	if(board[0].data)
		functable[DGREY] = mod_cast_creature_docast_illus;
	else
		functable[DGREY] = mod_cast_creature_docast;
        
	count = numbsquares;
	while(count--)
	{
		board[count].check = 0;

		if(board[count].chr != NULL)
			if((board[count].chr->dead & LMASK))
			{
				if((board[count].chr->owner & 127) == wiznum)
					board[count].check = TEAMTI;
				else
					board[count].check = ATTACK;
			}

		if(abs(board[count].sq_x - mover->sqx) <= 1 && abs(board[count].sq_y - mover->sqy) <= 1 && !board[count].check)
		{
			board[count].check = DGREY;
			board[count].data  = id;
		}
	}

	return 0;
}

int mod_cast_beam_docast(int sqx, int sqy, int sqid)
{
	int hpos;

	hpos = xy(mover->sqx, mover->sqy);
        clear_checks();

	cast_shot(sqx, sqy, sqid, board[hpos].data);

	return 3;
}

int mod_hcast_beam(int id)
{
	int wiznum, count, pos, xdif, ydif, number;
	
	wiznum = mover->owner & 127;
	pos = xy(mover->sqx, mover->sqy);
	board[pos].data = 3;
	functable[RRED >> 4] = mod_cast_beam_docast;
	number = 0;

	count = numbsquares;
	while(count--)
	{
		board[count].check = 0;
      
		if(board[count].chr != NULL)
			if(board[count].chr->dead & LMASK)
			{
				if((board[count].chr->owner & 127) == currentwiz)
					board[count].check = TEAMTI;
				else
				{
					xdif = board[count].sq_x - mover->sqx;
					ydif = board[count].sq_y - mover->sqy;

					if(sqroot[xdif*xdif + ydif*ydif] < movement_rating(allchars[id]))
						if(line_of_sight(mover, count))
						{
							board[count].check = (RRED >> 4);
							number++;
							board[count].last  = pos;
						}
				}
			}
	}

	if(number)
		return 0;
	else
	{
		mcolour = 47;
		sprintf(message, "No Enemies in Range");
		pauser = 1;
		return 1;
	}
}

int mod_hcast_blob(int id)
{
	return 0;
}

int mod_ccast_creature(int id)
{
	#define check_square(x,y) {pos=xy(x,y);if(board[pos].chr != NULL){ if(!board[pos].chr->dead&LMASK) cpos = pos;}else cpos=pos;}
	int pos, cpos;

	cpos = -1;
	if(mover->sqx - 1 >= 0)
	{
		check_square(mover->sqx-1, mover->sqy);

		if(mover->sqy - 1 >= 0)
			check_square(mover->sqx-1, mover->sqy-1);

		if(mover->sqy + 1 < bheight)
			check_square(mover->sqx-1, mover->sqy+1);
	}

	if(mover->sqx + 1 < bwidth)
	{
		check_square(mover->sqx+1, mover->sqy);

		if(mover->sqy - 1 >= 0)
			check_square(mover->sqx+1, mover->sqy-1);

		if(mover->sqy + 1 < bheight)
			check_square(mover->sqx+1, mover->sqy+1);
	}

	if(mover->sqy - 1 >= 0)
		check_square(mover->sqx, mover->sqy-1);

	if(mover->sqy + 1 < bheight)
		check_square(mover->sqx, mover->sqy+1);

	if(cpos != -1)
	{
		backup_camera();
		cast_creature(board[cpos].sq_x, board[cpos].sq_y, cpos, id, board[0].data);
		revert_to_last_camera(0);
	}

	return 0;
	#undef check_square
}

int mod_ccast_beam(int id)
{
	return 0;
}

int mod_ccast_blob(int id)
{
	return 0;
}

int mod_cast_disbelieve_docast(int sqx, int sqy, int sqid)
{
	fix_light();
	if(board[sqid].chr)
	{
		if(board[sqid].chr->dead & 128)
		{
			illusion_animation(board[sqid].chr);
		}

		return 3;
	}
	else
		return 0;
}

int mod_hcast_disbelieve(int id)
{
	int count, wiznum;
	
	wiznum = mover->owner & 127;
	
	functable[ATTACK] = mod_cast_disbelieve_docast;
        
	count = numbsquares;
	while(count--)
	{
		board[count].check = 0;

		if(board[count].chr != NULL)
			if((board[count].chr->dead & LMASK))
			{
				if((board[count].chr->owner & 127) != wiznum)
					board[count].check = ATTACK;
			}
	}

	return 0;
}

int mod_ccast_disbelieve(int id)
{
	CHARACTER *cchr;
	int wizno, exit, prob;

	wizno = rand()%(numwizards-1);
	if(wizno == currentwiz)
		wizno++;

	exit = 0;
	cchr = &person[wizard[wizno]];

	while(cchr->next && !exit)
	{
		prob = cchr->model->probfunc(cchr);
		if(prob < rand()%7 && rand()%2 && cchr->dead&LMASK)
			exit = 1;
		else
			cchr = cchr->next;
	}

	if(cchr->dead & 128)
		illusion_animation(board[xy(cchr->sqx, cchr->sqy)].chr);


	return 0;
}

void mod_cast_humanmain(int wiz, unsigned char *selected, int *change)
{
	int spellid;
	CHARACTER *cchr, *ochr;

	cchr = mover;
	while(cchr->next)
		cchr = cchr->next;

	ochr = cchr;

	play_sample(globdata[StartMove].dat, 255, 127, 1000, FALSE);
	point_camera_at(mover);
	fix_light();
	draw_other_players();
	draw_other_creations(mover);
	
	clear_checks();
	clear_functable();
	
	spellid = selected[wiz] & 127;
	board[0].data = selected[wiz] & 128;
	if(!allchars[spells[wiz][spellid]].setup_cast(spells[wiz][spellid]))
		(*change) += (do_boardview(NULL) - 3);
	
	cchr = mover;
	while(cchr->next)
		cchr = cchr->next;
	if(cchr != ochr)
		cchr->dead |= (selected[wiz] & 128);
}

void mod_cast_compmain(int wiz, unsigned char *selected, int *change)
{
	int spellid;
	CHARACTER *cchr, *ochr;

	cchr = mover;
	while(cchr->next)
		cchr = cchr->next;

	ochr = cchr;
	clear_checks();
	spellid = selected[wiz] & 127;
	board[0].data = selected[wiz] & 128;
	allchars[spells[wiz][spellid]].computer_cast(spells[wiz][spellid]);
	
	cchr = mover;
	while(cchr->next)
		cchr = cchr->next;
	if(cchr != ochr)
		cchr->dead |= (selected[wiz] & 128);
}