/*
	Anarchy - code by Thomas Harte 1999

	Distributed under the GPL version 2 - see file 'Copying' for details
*/

#include "anarchy.h"
#include "gengrap.h"
#include <math.h>

#define TEX_W 1024.0f
#define TEX_H 1024.0f

int load_board(unsigned char num)
{
	int xc, yc, c, base, texno, firstvert, firstpoly, sq_id;

	map.numcams = 5;
	map.cam = map.camera = malloc(sizeof(CAMERA)*5);

	map.camera[0].x = -25;
	map.camera[0].y = 123;
	map.camera[0].z = 0;
	map.camera[0].inx = 0;
	map.camera[0].iny = -1;
	map.camera[0].inz = 0;
	map.camera[0].upx = 0;
	map.camera[0].upy = 0;
	map.camera[0].upz = 1;
	map.camera[0].fov = 60;
	map.camera[0].movable = FALSE;
	set_up_camera(&map.camera[0]);

	map.camera[1].x = -75;
	map.camera[1].y = 50;
	map.camera[1].z = 75;
	map.camera[1].inx = 150;
	map.camera[1].iny = -70;
	map.camera[1].inz = -150;
	map.camera[1].upx = 0;
	map.camera[1].upy = 1;
	map.camera[1].upz = 0;
	map.camera[1].fov = 30;
	map.camera[1].movable = TRUE;
	set_up_camera(&map.camera[1]);

	map.camera[2].x = 75;
	map.camera[2].y = 20;
	map.camera[2].z = -75;
	map.camera[2].inx = -150;
	map.camera[2].iny = -20;
	map.camera[2].inz = 150;
	map.camera[2].upx = 0;
	map.camera[2].upy = 1;
	map.camera[2].upz = 0;
	map.camera[2].fov = 20;
	map.camera[2].movable = TRUE;
	set_up_camera(&map.camera[2]);

	map.camera[3].x = 0;
	map.camera[3].y = 5;
	map.camera[3].z = -100;
	map.camera[3].inx = 0;
	map.camera[3].iny = 1;
	map.camera[3].inz = 100;
	map.camera[3].upx = 0;
	map.camera[3].upy = 1;
	map.camera[3].upz = 0;
	map.camera[3].fov = 60;
	map.camera[3].movable = TRUE;
	set_up_camera(&map.camera[3]);

	map.camera[4].x = 0;
	map.camera[4].y = 200;
	map.camera[4].z = -100;
	map.camera[4].inx = 0;
	map.camera[4].iny = -200;
	map.camera[4].inz = 150;
	map.camera[4].upx = 0;
	map.camera[4].upy = 1;
	map.camera[4].upz = 0;
	map.camera[4].fov = 60;
	map.camera[4].movable = TRUE;
	set_up_camera(&map.camera[4]);
   
	bwidth = bheight = 16;
	numbsquares = bwidth*bheight;
	board = malloc(sizeof(SQUARE)*numbsquares);

	sq_id = (bwidth*bwidth) + (bheight*bheight);
	sqroot = malloc(sizeof(float)*sq_id);
	while(sq_id--)
		sqroot[sq_id] = sqrt((double)sq_id);

	map.numverts = 298;
	map.verts = malloc(298*sizeof(VERTEX));
	c = 0;

	map.verts[0].x = -10000.0f;
	map.verts[0].y =  10000.0f;
	map.verts[0].z =  10000.0f;
	c++;

	map.verts[1].x =  10000.0f;
	map.verts[1].y =  10000.0f;
	map.verts[1].z =  10000.0f;
	c++;

	map.verts[2].x =  10000.0f;
	map.verts[2].y = -10000.0f;
	map.verts[2].z =  10000.0f;
	c++;

	map.verts[3].x = -10000.0f;
	map.verts[3].y = -10000.0f;
	map.verts[3].z =  10000.0f;
	c++;

	map.verts[c].x = -10000.0f;
	map.verts[c].y =  10000.0f;
	map.verts[c].z = -10000.0f;
	c++;

	map.verts[c].x =  10000.0f;
	map.verts[c].y =  10000.0f;
	map.verts[c].z = -10000.0f;
	c++;

	map.verts[c].x =  10000.0f;
	map.verts[c].y = -10000.0f;
	map.verts[c].z = -10000.0f;
	c++;

	map.verts[c].x = -10000.0f;
	map.verts[c].y = -10000.0f;
	map.verts[c].z = -10000.0f;
	c++;

	map.verts[c].x = 0.0f;
	map.verts[c].y = -100.0f;
	map.verts[c].z = 0.0f;
	c++;

	firstvert = c;
	
	for(xc = 0; xc < 17; xc ++)
		for(yc = 0; yc < 17; yc ++)
		{
			map.verts[c].x = (xc * 10) - 80;
			map.verts[c].y = 0;
			map.verts[c].z = (yc * 10) - 80;
			c++;
		}

	map.numtexs = 4;

	map.textures = malloc(sizeof(TEXTURE *)*4);

	map.textures[0] = load_pcx("dark.pcx", mainpal); //dark, bright, stars, base
	map.textures[1] = load_pcx("bright.pcx", mainpal);
	map.textures[2] = load_pcx("stars2.pcx", mainpal); //sky
	map.textures[3] = load_pcx("base.pcx", mainpal);

	map.polys = malloc(sizeof(POLY)*528);

	c = 0;
	map.polys[c].verts[0] = &map.verts[2];
	map.polys[c].verts[1] = &map.verts[1];
	map.polys[c].verts[2] = &map.verts[3];

	map.polys[c].datas[0].u = TEX_W;
	map.polys[c].datas[0].v = TEX_H;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = 0.0f;
	map.polys[c].datas[2].u = 0.0f;
	map.polys[c].datas[2].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[0] = &map.verts[3];
	map.polys[c].verts[1] = &map.verts[1];
	map.polys[c].verts[2] = &map.verts[0];

	map.polys[c].datas[0].u = 0.0f;
	map.polys[c].datas[0].v = TEX_H;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = 0.0f;
	map.polys[c].datas[2].u = 0.0f;
	map.polys[c].datas[2].v = 0.0f;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[2] = &map.verts[5];
	map.polys[c].verts[1] = &map.verts[4];
	map.polys[c].verts[0] = &map.verts[7];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = 0;
	map.polys[c].datas[0].u = TEX_W;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[2] = &map.verts[5];
	map.polys[c].verts[1] = &map.verts[7];
	map.polys[c].verts[0] = &map.verts[6];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = TEX_H;
	map.polys[c].datas[0].u = 0;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[2] = &map.verts[1];
	map.polys[c].verts[1] = &map.verts[5];
	map.polys[c].verts[0] = &map.verts[6];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = 0;
	map.polys[c].datas[0].u = TEX_W;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[2] = &map.verts[1];
	map.polys[c].verts[1] = &map.verts[6];
	map.polys[c].verts[0] = &map.verts[2];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = TEX_H;
	map.polys[c].datas[0].u = 0;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[2] = &map.verts[4];
	map.polys[c].verts[1] = &map.verts[0];
	map.polys[c].verts[0] = &map.verts[3];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = 0;
	map.polys[c].datas[0].u = TEX_W;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[2] = &map.verts[4];
	map.polys[c].verts[1] = &map.verts[3];
	map.polys[c].verts[0] = &map.verts[7];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = TEX_H;
	map.polys[c].datas[0].u = 0;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[2] = &map.verts[3];
	map.polys[c].verts[1] = &map.verts[2];
	map.polys[c].verts[0] = &map.verts[6];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = 0;
	map.polys[c].datas[0].u = TEX_W;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[2] = &map.verts[3];
	map.polys[c].verts[1] = &map.verts[6];
	map.polys[c].verts[0] = &map.verts[7];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = TEX_H;
	map.polys[c].datas[0].u = 0;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;


	map.polys[c].verts[2] = &map.verts[0];
	map.polys[c].verts[1] = &map.verts[4];
	map.polys[c].verts[0] = &map.verts[5];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = 0;
	map.polys[c].datas[0].u = TEX_W;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	map.polys[c].verts[2] = &map.verts[0];
	map.polys[c].verts[1] = &map.verts[5];
	map.polys[c].verts[0] = &map.verts[1];

	map.polys[c].datas[2].u = 0;
	map.polys[c].datas[2].v = 0;
	map.polys[c].datas[1].u = TEX_W;
	map.polys[c].datas[1].v = TEX_H;
	map.polys[c].datas[0].u = 0;
	map.polys[c].datas[0].v = TEX_H;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[2];
	c++;

	sq_id = 0;

	firstpoly = c;
	for(xc = 0; xc < 16; xc ++)
		for(yc = 0; yc < 16; yc++)
		{
			base = firstvert + (xc*17)+yc;
			texno = (xc+yc) & 1;

			board[sq_id].chr		= NULL;
			board[sq_id].x			= (map.verts[base].x + map.verts[base+17].x)/2;
			board[sq_id].y			= map.verts[base].y+5;
			board[sq_id].z			= (map.verts[base].z + map.verts[base+1].z)/2;

			board[sq_id].sq_x		= yc;
			board[sq_id].sq_y		= xc;

			map.polys[c].verts[0]	= &map.verts[base];
			map.polys[c].verts[1]	= &map.verts[base+17];
			map.polys[c].verts[2]	= &map.verts[base+1];

			map.polys[c].datas[0].u	= 0;
			map.polys[c].datas[0].v	= 0;
			map.polys[c].datas[1].u	= 255;
			map.polys[c].datas[1].v	= 0;
			map.polys[c].datas[2].u	= 0;
			map.polys[c].datas[2].v	= 255;

			map.polys[c].datas[0].c	= sq_id;
			map.polys[c].tex		= map.textures[texno];
			c++;

			map.polys[c].verts[0]	= &map.verts[base+17];
			map.polys[c].verts[1]	= &map.verts[base+18];
			map.polys[c].verts[2]	= &map.verts[base+1];

			map.polys[c].datas[0].u	= 255;
			map.polys[c].datas[0].v	= 0;
			map.polys[c].datas[1].u	= 255;
			map.polys[c].datas[1].v	= 255;
			map.polys[c].datas[2].u	= 0;
			map.polys[c].datas[2].v	= 255;

			map.polys[c].datas[0].c	= sq_id;
			map.polys[c].tex		= map.textures[texno];

			c++;
			sq_id++;
		}

	map.polys[c].verts[0] = &map.verts[firstvert];
	map.polys[c].verts[1] = &map.verts[firstvert+16];
	map.polys[c].verts[2] = &map.verts[8];

	map.polys[c].datas[0].u = 0;
	map.polys[c].datas[0].v = 0;
	map.polys[c].datas[1].u = 255;
	map.polys[c].datas[1].v = 0;
	map.polys[c].datas[2].u = 127;
	map.polys[c].datas[2].v = 255;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[3];
	c++;

	map.polys[c].verts[0] = &map.verts[firstvert+16];
	map.polys[c].verts[1] = &map.verts[firstvert+(16*17)+16];
	map.polys[c].verts[2] = &map.verts[8];

	map.polys[c].datas[0].u = 255;
	map.polys[c].datas[0].v = 0;
	map.polys[c].datas[1].u = 0;
	map.polys[c].datas[1].v = 0;
	map.polys[c].datas[2].u = 127;
	map.polys[c].datas[2].v = 255;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[3];
	c++;

	map.polys[c].verts[0] = &map.verts[firstvert+(16*17)+16];
	map.polys[c].verts[1] = &map.verts[firstvert+(16*17)];
	map.polys[c].verts[2] = &map.verts[8];

	map.polys[c].datas[0].u = 0;
	map.polys[c].datas[0].v = 0;
	map.polys[c].datas[1].u = 255;
	map.polys[c].datas[1].v = 0;
	map.polys[c].datas[2].u = 127;
	map.polys[c].datas[2].v = 255;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[3];
	c++;

	map.polys[c].verts[0] = &map.verts[firstvert+(16*17)];
	map.polys[c].verts[1] = &map.verts[firstvert];
	map.polys[c].verts[2] = &map.verts[8];

	map.polys[c].datas[0].u = 255;
	map.polys[c].datas[0].v = 0;
	map.polys[c].datas[1].u = 0;
	map.polys[c].datas[1].v = 0;
	map.polys[c].datas[2].u = 127;
	map.polys[c].datas[2].v = 255;

	map.polys[c].datas[0].c = NOTSQUARE;
	map.polys[c].tex        = map.textures[3];

	c++;

	map.numpolys = c;

	map.song = load_midi("song1.mid");

	set_palette(mainpal);

	starts = malloc(sizeof(BOARD_POSITIONS)*35); //8+7+6+5+4+3+2

	starts[0].x = 7;
	starts[0].y = 0;
	starts[1].x = 8;
	starts[1].y = 15;

	starts[2].x = 13;
	starts[2].y = 8;
	starts[3].x = 2;
	starts[3].y = 2;
	starts[4].x = 2;
	starts[4].y = 14;

	starts[5].x = 14;
	starts[5].y = 14;
	starts[6].x = 14;
	starts[6].y = 1;
	starts[7].x = 1;
	starts[7].y = 1;
	starts[8].x = 1;
	starts[8].y = 14;

	starts[9].x = 15;
	starts[9].y = 7;
	starts[10].x = 9;
	starts[10].y = 0;
	starts[11].x = 0;
	starts[11].y = 4;
	starts[12].x = 0;
	starts[12].y = 11;
	starts[13].x = 9;
	starts[13].y = 15;

	starts[14].x = 15;
	starts[14].y = 7;
	starts[15].x = 13;
	starts[15].y = 0;
	starts[16].x = 2;
	starts[16].y = 0;
	starts[17].x = 0;
	starts[17].y = 8;
	starts[18].x = 2;
	starts[18].y = 15;
	starts[19].x = 13;
	starts[19].y = 15;

	starts[20].x = 15;
	starts[20].y = 7;
	starts[21].x = 13;
	starts[21].y = 0;
	starts[22].x = 4;
	starts[22].y = 0;
	starts[23].x = 0;
	starts[23].y = 4;
	starts[24].x = 0;
	starts[24].y = 11;
	starts[25].x = 4;
	starts[25].y = 15;
	starts[26].x = 13;
	starts[26].y = 14;

	starts[27].x = 14;
	starts[27].y = 14;
	starts[28].x = 14;
	starts[28].y = 7;
	starts[29].x = 14;
	starts[29].y = 1;
	starts[30].x = 8;
	starts[30].y = 1;
	starts[31].x = 1;
	starts[31].y = 1;
	starts[32].x = 1;
	starts[32].y = 8;
	starts[33].x = 1;
	starts[33].y = 14;
	starts[34].x = 7;
	starts[34].y = 14;

	return 0;
}
