#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <allegro.h>
#include <time.h>

#ifdef WIN32
#include <winalleg.h>
#include <windows.h>
#endif

#include "data.h"
#ifdef WITH_Z80
#include "z80/z80.h"
#endif

#define WIDTH	640
#define HEIGHT	480
#define SIZE		(WIDTH*HEIGHT)
#define SHIFT1	7
#define SHIFT2	9 //(1 << SHIFT1) + (1 << SHIFT2) = WIDTH
#define EXTRAMODS 10

#define LFONT	gothicL
#define MFONT	gothicM

#define valid_range(x) if(x > 2) x = 0; if(x < 0) x = 2;

#define WIZARD	128 //highest bit

#define NOTSQUARE	2147483647

#define add_realtime_player(x) add_player(&person[x], view, LIT)
#define add_static_player(x) add_player(&person[x], backup, LIT)

#define xy(x,y)	((y)*bwidth)+x

//flags      = (all 1 wide) - undead:flying:rideable:chaos(3):growable
//ratings    = (all 4 wide) - combat:defense
//movement   =                range(5)
//resist     = (all 4 wide) - manoeuvre:magic resistance
//projectile =                possible(1):distance(5):type(2)

#define undead(x)			(x.flags >> 7)
#define flying(x)			((x.flags >> 6)&1)
#define mount(x)			((x.flags >> 5)&1)
#define chaos_rating(x)			(((x.flags >> 2)&7)-2)
#define growth_type(x)			(x.flags&3)

#define defense_rating(x)		(x.ratings & 15)
#define attack_rating(x)		(x.ratings >> 4)

#define movement_rating(x)		(x.movement >> 3)
#define static(x)			((x.movement >> 2)&1)

#define manoeuvre_rating(x)		(x.resist >> 4)
#define magic_resistance(x)		(x.resist & 15)

#define can_shoot(x)			(x.projectile >> 7)
#define shot_distance(x)		((x.projectile >> 2)&31)
#define shot_type(x)			(x.projectile & 3)

#define ptr_undead(x)			(x->flags >> 7)
#define ptr_flying(x)			((x->flags >> 6)&1)
#define ptr_mount(x)			((x->flags >> 5)&1)
#define ptr_chaos_rating(x)		(((x->flags >> 2)&7)-2)
#define ptr_defense_rating(x)		(x->ratings & 15)
#define ptr_attack_rating(x)		(x->ratings >> 4)
#define ptr_movement_rating(x)		(x->movement >> 3)
#define ptr_static(x)			((x->movement >> 2)&1)
#define ptr_manoeuvre_rating(x)		(x->resist >> 4)
#define ptr_magic_resistance(x)		(x->resist & 15)
#define ptr_can_shoot(x)			(x->projectile >> 7)
#define ptr_shot_distance(x)		((x->projectile >> 2)&31)
#define ptr_shot_type(x)			(x->projectile & 3)
#define ptr_growth_type(x)			(x->flags&3)

#define LIT		0
#define GREY		32
#define SKIN		48
#define RED		64
#define ORANGE	80
#define YELLOW	96
#define GREEN	112
#define CYAN		128
#define LBLUE	144
#define BLUE		160
#define RRED		176
#define SPECTRE	192
#define DGREY	208
#define MGREY	224
#define BROWN	240
#define STATED	255

//colour coding for movements
#define CURRENT	BLUE
#define EMPTY	0
#define ONTO		GREEN
#define ATTACK	ORANGE
#define TEAMEN	RED
#define TEAMTI	YELLOW

#define LMASK	63
#define DMASK	64
#define ONMASK	128

#define SPECKEY	256

#define ang_range(ang)	if(ang > 255) ang -= 256;  if(ang < 0) ang += 256;
#define wait_for_mouse_free() while(mouse_b){}
#define fix_light() {lightx = olightx; lighty = olighty; lightz = olightz;}

#define PERSON   0
#define BEAM     1
#define BLOB     2
#define FOREST   3


#if GCC || DJGPP
static inline int I(float f) __attribute__((const));
static inline int I(float f)
{
  f += (1<<23);
  return *((int *)&f) & 0x7fffff;
}
#else
#define I(x) (int)(x)
#endif

typedef int(*func_ptr)(int sqx, int sqy, int sqid);

#ifdef WITH_Z80
extern int *z80addrs;
#endif
extern func_ptr *functable;

typedef BITMAP TEXTURE;

typedef struct
{
	float x, y, z;
	float wx, wy, wz;
	float sx, sy, sz;
	unsigned char awkward;
} VERTEX;

typedef struct
{
	float u, v;
	int c;
} POLYDATA;

typedef struct
{
	VERTEX   *verts[3];
	POLYDATA datas[3];
	TEXTURE  *tex;
	float cx, cy, cz;
	float wx, wy, wz;
} POLY;

#ifdef WITH_Z80
typedef struct
{
	Z80_REGISTERPAIR	af,		bc,		de,		hl,		ix,		iy,		sp;
	Z80_REGISTERPAIR	afd,		bcd,		ded,		hld;
	unsigned short	pc;
	unsigned char	i,		r;
	unsigned char	imode,		**membanks,		*specmem,		*zones,		*bankzones,		*roms;
} Z80_STATE;
#endif

typedef struct
{
	POLY *polys;
	VERTEX *verts;
	short numpolys, numverts;
	char name[21];
	unsigned char flags, ratings, movement, resist, projectile;

	int (* setup_cast)(int id);
	int (* setup_move)(void *chr);
	int (* computer_cast)(int id);
	int (* computer_move)(void *chr);
	int (* probfunc)(void *chrmdl);
	int (* keepalive)(void *chr);
	int (* taint)(void *chr);
	int (* untaint)(void *chr);
	int (* cleanup)(void *chr, void *attacker, int pos);
   
	#ifdef WITH_Z80
	Z80_STATE *z80state;
	#endif
} CHARACTER_MODEL;

typedef struct fellow
{
	float x, y, z, angle;
	int sqx, sqy;
	unsigned char moves, diags;
	int attacked;
	unsigned char owner, dead;
	CHARACTER_MODEL *model;
	struct fellow *next, *square, *mount;
} CHARACTER;

typedef struct
{
	MATRIX_f vision;
	float x, y, z, inx, iny, inz, upx, upy, upz, fov;
	char movable;
} CAMERA;

typedef struct
{
	BITMAP *image;
	float *depth;
} SHOT;

typedef struct
{
	POLY *polys;
	VERTEX *verts;
	short numpolys, numverts, numtexs;
	TEXTURE **textures;
	MIDI *song;
	CAMERA *camera;
	CAMERA *cam, *lastcam, *prevcam;
	unsigned char numcams;
} ARENA;

typedef struct
{
	float a, b, c, d;
} PLANE;

typedef struct
{
	float x, y, z;
	int sq_x, sq_y, data;
	CHARACTER *chr;
	unsigned char check, dist, last, diags;
} SQUARE;

typedef struct
{
	void (*prefunc)(int wiz, unsigned char *selected, PALETTE *inverse);
	void (*castfunc)(int wiz, unsigned char *selected, int *change);
	void (*movefunc)(void);
	int target;
	char level;
} PLAYERINFO;

typedef struct
{
	int x, y;
} BOARD_POSITIONS;
  
extern SHOT			*view, *backup, *boardonly, *others;
extern CHARACTER		*person;
extern BITMAP			*mouseover;
extern SQUARE			*board;
extern CHARACTER		*mouse_on, *mover;
extern CHARACTER_MODEL	*allchars;
extern DATAFILE		*globdata;
extern int			*wizard, **spells;
extern BOARD_POSITIONS	*starts;

extern ARENA			map;
extern PLANE			cplanes[5];
extern unsigned char	globleave,		winner,		mcolour;
extern char			chaoslaw,		message[40],		complev;
extern float			lightx,		lighty,		lightz,	*sqroot;
extern float			olightx,		olighty,		olightz;
extern int			numcharacters,	numpeople,		cursornum,	currentwiz,	numwizards;
extern int			mouse_sqx,		mouse_sqy,		mouse_xy;
extern short			bwidth,		bheight,		numbsquares;
extern PALETTE		mainpal;
extern CHARACTER		pyramid;
extern CHARACTER_MODEL	pyramid_model, grave_model;
extern PLAYERINFO		players[8];
extern volatile unsigned char pauser;
extern BITMAP *scr;
extern float fpsadjust;
extern BITMAP *mptr;
extern time_t time_1, time_2;
extern float fps;
extern int frames, measures;

#define seed_fpsadjuster() {time_1 = time_2 = time(NULL); measures = frames = 0;}
#define add_frame() {\
			frames++;\
		        time_2 = time(NULL);\
			if(time_2 != time_1)\
			{\
				if(measures)\
				{\
					fps = (float)frames / (float)(time_2 - time_1);\
					fpsadjust = 30 / fps;\
                                }\
				measures++;\
				time_1 = time_2;\
				frames = 0;\
			}\
		}

