//
//    MARAUDER
//
//    sprite.h: sprite objects and movement code
//
//    By Shawn Hargreaves, 1995.
//
//    C++ source code for djgpp, using the 
//    Allegro game programming library.



#define STAR_COUNT  24

#define FIX_TO_PIX_SHIFT    20


#define REPAIR_PRICE            1000
#define SHIELD_PRICE            10000
#define MISSILE_PRICE           100
#define TORPEDO_PRICE           250
#define MINE_PRICE              50
#define PROTON_GUN_PRICE        8000
#define MATTER_CANNON_PRICE     20000
#define AFTERBURNER_PRICE       3000


inline int myabs(int x) 
{
    return (x<0) ? -x : x;
}


typedef struct SHIP_STATE {
    int money;
    int cargo;
    int shields;
    int missiles;
    int torpedoes;
    int mines;
    int proton_gun;
    int matter_cannon;
    int afterburner;
} SHIP_STATE;



typedef struct RECT
{
    int x, y, w, h;
} RECT;



class dirty_list
{
public:
    dirty_list();
    ~dirty_list();
    void reset();
    void empty();
    void add(int x, int y, int w, int h);
    void add(class dirty_list *other);
    void copy(class dirty_list *other);
    void sort();
    void do_clear(BITMAP *b);
    void do_blit(BITMAP *src, BITMAP *dest);
protected:
    void resize(int s);
    int size;
    int count;
    RECT *data;
};


extern dirty_list dirty, old_dirty;



class multidir
{
public:
    multidir(BITMAP *b, int num, void (*callback)(void));
    ~multidir();
    BITMAP *sprite(int dir) { return s[((dir+round)>>shift)&(number-1)]; }
private:
    int number;
    int shift;
    int round;
    BITMAP **s;
    BITMAP *rotate_sprite(BITMAP *b, fixed angle);
};



enum {
    ITEM_UNKNOWN = 0,
    ITEM_ALIEN,
    ITEM_PLANET,
    ITEM_BULLET,
    ITEM_TREASURE
};



int checkpixel(BITMAP *s, int x, int y);
int calculate_bound(BITMAP *s);



class item
{
public:
    item() { current_sprite=NULL; x=y=xc=yc=w=h=rcol=itemtype=bound=0; }
    virtual ~item() { ; }
    virtual int move() { return 0; }
    int move(int x) { while (x) { if (move()) return -1; x--; } return 0; }
    virtual void collide(item *other) { other = other; }
    void draw(BITMAP *b, int x, int y);
    int getx() { return x; }
    int gety() { return y; }
    int getwidth() { return w; }
    int getheight() { return h; }
    int getbound() { return bound; }
    int get_radar_color() { return rcol; }
    int get_type() { return itemtype; }
    void position(int xpos, int ypos) { x = xpos; y = ypos; }
protected:
    BITMAP *current_sprite;
    void set_dim() { w = (current_sprite->w/2) << FIX_TO_PIX_SHIFT; h = (current_sprite->h/2) << FIX_TO_PIX_SHIFT; }
    int bound;
    int x, y;
    int w, h;
    int xc, yc;
    int rcol;
    int itemtype;
};




class spaceship : public item
{
public:
    spaceship() { damage = dir = burn_delay = 0; }
    virtual ~spaceship() { ; }
    virtual int move() { return 0; }
    int get_damage() { return damage; }
    void set_damage(int d) { damage = d; }
protected:
    int dir;
    int damage;
    int burn_delay;
    int ander;
};



class spritemgr;


class playership : public spaceship
{
public:
    playership(SHIP_STATE *initial_state, multidir *go, multidir *burn, multidir *still);
    virtual ~playership() { ; }
    virtual int move();
    virtual void collide(item *other);
    void draw_stars(BITMAP *b);
    SHIP_STATE state;
    int esc;
    int draw_stat_flag;
    int get_wpn() { return wpn; }
    int kill_count;
protected:
    multidir *go_spr;
    multidir *burn_spr;
    multidir *still_spr;
    int wpn;
    struct {
	int x, y;
    } star[STAR_COUNT];
    int shootdelay;
    item *recent_mine;
    int recent_flag;
};



enum {
    PLANET_ASTEROID = 0,
    PLANET_EARTH,
    PLANET_JUPITER,
    PLANET_SUN,
    PLANET_WATER
};



class planet : public item
{
public:
    planet();
    int price();
private:
    int type;
};



#define EXPLODER_COUNT     80

class exploder
{
public:
    exploder(int hotcount, int explode_size, void (*callback)());
    ~exploder();
    BITMAP *sprite(int count) { return s[count]; }
private:
    BITMAP *s[EXPLODER_COUNT];
};



class explosion : public item
{
public:
    explosion(exploder *multi, int flag);
    virtual ~explosion() { ; }
    virtual int move();
protected:
    int die_flag;
    int count;
    exploder *expl;
};



class treasure : public item
{
public:
    treasure(int c, int m);
    virtual ~treasure() { ; }
    virtual int move();
    int get_cargo() { return cargo; }
    int get_money() { return money; }
    void kill() { life = 0; }
protected:
    int life;
    int dir;
    int cargo;
    int money;
    multidir *spr;
};



class yippee : public item
{
public:
    yippee(char *fmt, ...);
    virtual ~yippee();
    virtual int move() { return (--life > 0) ? 0 : -1; }
protected:
    int life;
};

