//
//    MARAUDER
//
//    mgr.cpp: sprite manager and collision detection
//
//    By Shawn Hargreaves, 1995.
//
//    C++ source code for djgpp, using the 
//    Allegro game programming library.


#include <stdlib.h>
#include <allegro.h>
#include "sprite.h"
#include "mgr.h"


extern spritemgr *planets, *bullets, *treasures;



spritemgr::spritemgr()
{
    alloc_size = count = 0;
    i = NULL;
}



spritemgr::~spritemgr()
{
    for (int c=0; c<count; c++)
	delete i[c];

    free(i);
}



void spritemgr::draw(BITMAP *b, item *ship)
{
    for (int c=0; c<count; c++)
	i[c]->draw(b,
	(SCREEN_W-80)/2 + ((i[c]->getx() - ship->getx()) >> FIX_TO_PIX_SHIFT),
	SCREEN_H/2 + ((i[c]->gety() - ship->gety()) >> FIX_TO_PIX_SHIFT));
}



#define FIX_TO_R    26


void spritemgr::draw_radar(BITMAP *b, item *ship)
{
    for (int c=0; c<count; c++)
	if (i[c]->get_radar_color())
	    putpixel(b, SCREEN_W-40 + ((i[c]->getx() - ship->getx()) >> FIX_TO_R),
		     40 + ((i[c]->gety() - ship->gety()) >> FIX_TO_R),
		     i[c]->get_radar_color());
}



item *spritemgr::add(item *addition, int x, int y)
{
    x &= 0xfff00000;
    y &= 0xfff00000;
    addition->position(x,y);

    if (count >= alloc_size) {
	alloc_size += 8;
	i = (item **)realloc(i, sizeof(item *)*alloc_size);
    }

    int c;

    for (c=count; (c>0) && (i[c-1]->getx()>addition->getx()); c--)
	i[c] = i[c-1];

    i[c] = addition;
    count++;

    return addition;
}



#define ADD_DISTANCE    (0xff<<FIX_TO_PIX_SHIFT)


item *spritemgr::add(item *addition, item *avoid)
{
    int x, y;
    int ok;
    int count = 0;

    do {
	x = rand() << FIX_TO_PIX_SHIFT;
	y = rand() << FIX_TO_PIX_SHIFT;
	if (find_within(x,y,ADD_DISTANCE))
	    ok = FALSE;
	else
	    ok = TRUE;
	if (avoid) {
	    if ((myabs(x-avoid->getx())<(ADD_DISTANCE<<1)) &&
		(myabs(y-avoid->gety())<(ADD_DISTANCE<<1)))
		ok = FALSE;
	}
	count++;
    } while ((!ok)&&(count<100));

    return add(addition, x, y);
}



item *spritemgr::find_within(int x, int y, int distance)
{
    for (int c=0; c<count; c++)
	if ((myabs(x-i[c]->getx())<(distance+i[c]->getwidth())) &&
	    (myabs(y-i[c]->gety())<(distance+i[c]->getheight())))
	    return i[c];

    return NULL;
}



void spritemgr::check_items(item *i1, item *i2)
{
    // fast rectangle bounding box
    if ((myabs(i1->getx()-i2->getx()) < (i1->getwidth()+i2->getwidth())) &&
	(myabs(i1->gety()-i2->gety()) < (i1->getheight()+i2->getheight()))) {

	// refine to circle bounding box
	int xd = myabs(i1->getx()-i2->getx()) >> FIX_TO_PIX_SHIFT;
	int yd = myabs(i1->gety()-i2->gety()) >> FIX_TO_PIX_SHIFT;
	if ((fsqrt(xd*xd+yd*yd)>>8) < (i1->getbound()+i2->getbound())) {
	    i1->collide(i2);
	}
    }
}



void spritemgr::collision_check(item *item)
{
    int a = 0;
    int b = count-1;
    int c, d; 

    if (count) {

	do {                        // binary search
	    c = (a + b) >> 1;

	    if (item->getx() > i[c]->getx())
		a = c + 1;
	    else
		if (item->getx() < i[c]->getx())
		    b = c - 1;

	} while ((a <= b) && (item->getx()!=i[c]->getx()));

	d = c;                      // look backwards
	do { 
	    check_items(item, i[d]);
	    d--;
	    if (d<0)
		d = count-1;
	} while ((myabs(item->getx()-i[d]->getx()) < (50<<FIX_TO_PIX_SHIFT)) &&
		  (d != c));

	d = c+1;                    // and look forwards
	if (d>=count)
	    d = 0;
	while ((myabs(item->getx()-i[d]->getx()) < (50<<FIX_TO_PIX_SHIFT)) &&
	       (d != c)) { 
	    check_items(item, i[d]);
	    d++;
	    if (d>=count)
		d = 0;
	}
    }
}



void spritemgr::move(int x)
{
    int c, sorted;
    item *t;

    for (c=0; c<count; c++) {
	if (i[c]->move(x)) {
	    delete i[c];
	    for (int c2=c; c2<count-1; c2++)
		i[c2] = i[c2+1];
	    count--;
	}
    }

    do {                    // bubble sort since list will be almost sorted
	sorted = TRUE;
	for (c=0; c<count-1; c++)
	    if (i[c]->getx() > i[c+1]->getx()) {
		t = i[c];
		i[c] = i[c+1];
		i[c+1] = t;
		sorted = FALSE;
	    }
    } while (!sorted); 
}


