#include <allegro.h>
#include <jgmod.h>
#include <libcda.h>
#include <blocks3.h>

int f_no;

void increment_time_counter()
{
 time_count++;
}

END_OF_FUNCTION(increment_time_counter);

void Remember_Mod_File(char *fn, int a, int b)
{
 strcpy(mod[f_no].name, "./music/");
 strcat(mod[f_no].name, get_filename(fn));
 f_no++;
}

void Initialise(void)
{
 int i;

 allegro_init();
 install_keyboard();
 install_timer();
 install_mouse();

 cd_init();

 set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);

 gfx = load_bitmap("gfx1.bmp", pallete);

 set_pallete(pallete);

 /** Timer Stuff **/

 LOCK_VARIABLE(time_count);
 LOCK_FUNCTION(increment_time_counter);

 install_int_ex(increment_time_counter, BPS_TO_TIMER(200));

 /** Trans and Lit tables **/

 create_trans_table(&trans_table, pallete, 50, 50, 50, NULL);
 create_light_table(&light_table, pallete, 0, 0, 0, NULL);
 color_map = &light_table;


 /** Bitmap stuff **/

 for (i = 0; i < 12; i++)
 {
  ply_pic[0][i] = create_bitmap(32, 40);
  ply_pic[1][i] = create_bitmap(32, 40);
 }

 box_pic = create_bitmap(32, 40);
 clear(box_pic);

 blank = create_bitmap(32, 40);
 clear(blank);

 editor_icons = create_bitmap(1024, 32);
 clear(editor_icons);

 temp = create_bitmap(640, 480);
 back = create_bitmap(640, 480);

 fonts = load_datafile("fonts.dat");
 title_gfx = load_bitmap("title256.bmp", title_pallete);

 reserve_voices(20, -1);
 install_sound(DIGI_AUTODETECT, MIDI_NONE, "");
 install_mod(12);

 set_mod_volume(255);
 set_volume(255, 0);
 sfx = load_datafile("sfx.dat");

 mus_vol = 255;
 sfx_vol = 255;
 cd_vol = 255;

 f_no = 0;
 for_each_file("./music/*.mod", NULL, Remember_Mod_File, 0);
 for_each_file("./music/*.s3m", NULL, Remember_Mod_File, 0);
 for_each_file("./music/*.xm", NULL, Remember_Mod_File, 0);

 mod_last = f_no;
 mod_track = 0;

 music = load_mod(mod[mod_track].name);
 play_mod(music, TRUE);

 Change_Motif(SUNNY);
}
