/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2003                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include <string.h>
#include "gamegfx.h"
#include "gamemsg.h"
#include "gfx.h"
#include "gamedraw.h"
#include "ugrp.h"
#include "cheats.h"


static char *gamemsg[] = {
   "You must explore there first",
   "You must keep space between buildings",
   "You cannot build there",
   "Low religion",
   "Not enough food", //"Not enough living space",
   "Not enough engineering",
   "Not enough lumber",
   "Not enough stone",
   "Not enough resource 5",
   "Not enough resource 6",
   "Not enough resource 7",
   "Cheat enabled",
   "Cheat disabled"
};

/* Display a message over the command map */
static void push_gamemsg(int colour, const char *text, ...)
{
   FLOATWIN_LIST *flwl;
   FLOATWIN *flw;
   FONT *f = (FONT *)get_normal_font();
   int h = text_height(f);
   char *s = malloc(4096);
   va_list ap;

   va_start(ap, text);
   uvsprintf(s, text, ap);
   va_end(ap);
   
   /* Move previous floatwins */
   /* The drawing code *could* be slightly sparser here, since we don't really */
   /*  have to mark all the tiles as dirty; only the area of the floatwin... */
   for (flwl = flwin; flwl; flwl = flwl->next) {
      if (flwl->win->flags&FWIN_GAMEMSG) {
         undraw_floatwin(flwl->win);
         flwl->win->y -= h;
         flwl->win->flags |= FWIN_MARK;
         mark_rect(flwl->win->x, flwl->win->y, flwl->win->w, flwl->win->h);
      }
   }
             
   flw = make_floattext(12, SCREEN_H-138-h, black, colour,
                        FWIN_GAMEMSG+FWIN_MARK, 50+text_length(f, s)/2, f, s);
      
   free (s);
}


void broadcast_message(const int msg_id, const int sender, const int receiver)
{
   int c = white;
   
   if (receiver==get_local_player()) {
      if (sender==get_local_player())
         c = yellow;
      push_gamemsg (c, gamemsg[msg_id]);
   }
}

void broadcast_text(const char *text, const int sender, const int receiver)
{
   int c = white;
   
   if (receiver==get_local_player()) {
      if (sender==get_local_player())
         c = yellow;
      push_gamemsg (c, text);
      //set_screen_changed();
   } else if (receiver==COMPUTER_RECIPIENT) {
      /* Check cheat codes */
      c = do_cheat_codes(text);
      if (c==1)
         broadcast_message(GAMEMSG_CTON, receiver, sender);
      else if (c==-1)
         broadcast_message(GAMEMSG_CTOF, receiver, sender);
   }
}
