#include <string.h>
#include <ctype.h>
#include "str.h"

/* Macro for readability - returns true if two strings are equal */
#define streq(s1,s2)  (!strcmp((s1), (s2)))

/*********************************************/
/*    String manipulation helper functions   */
/*********************************************/

/* Removes all blank characters from the start of a string. MODIFIES THE
	ACTUAL STRING. The pointer returned is the string itself */
/* Implementation is rather stupid - update at a later time */
char *strflushl(char *s)
{
   int c;
   int n;

   n = strlen(s);
   while (isspace(s[0]) && (s[0])) {
      for (c = 1; c < n; c++)
	 s[c - 1] = s[c];
      s[c - 1] = 0;
      n--;
   }
   return s;
}

/* Removes all blank characters from the end of a string. MODIFIES THE
	ACTUAL STRING. The pointer returned is the string itself */
char *strflushr(char *s)
{
   int n;
   n = strlen(s);
   while (n && isspace(s[n - 1])) {
      s[n - 1] = '\0';
      n--;
   }
   return s;
}

/* Returns a copy of the string text, with all caps converted to lower case */
char *str_to_lower(const char *text)
{
   char *s = strdup(text);
   char *str;
   
   for(str=s; str[0]; str++) {
      str[0] = tolower(str[0]);      
   }
   
   return s;
}

/* Returns a copy of the string text, with all caps converted to upper case */
char *str_to_upper(const char *text)
{
   char *s = strdup(text);
   char *str;
   
   for(str=s; str[0]; str++) {
      str[0] = toupper(str[0]);
   }
   
   return s;
}

