/* Message window strings; up to 6 */
static char *msg_str[6] = { NULL, NULL, NULL, NULL, NULL, NULL };
static int msg_timer = 0;

/* game messages */
static char **global_msg = NULL;
static size_t num_global_msg = 0;

/* Return pointer to message window */
char *get_msg_str(unsigned int line)
{
   if (line > 5)
      return NULL;
   return msg_str[line];
}

/* Frees one line in the message window. */
void clr_msg_str(unsigned int line)
{
   if (line > 5)
      return;
   if (msg_str[line]) {
      free(msg_str[line]);
      msg_str[line] = NULL;
   }
}

/* Frees the message window. */
void clr_msg_win(void)
{
   int c;

   for (c = 0; c < 6; c++)
      clr_msg_str(c);
}

/* Scrolls the message window up one line */
void scroll_msg_win(void)
{
   int c;

   clr_msg_str(0);
   for (c = 0; c < 5; c++) {
      msg_str[c] = msg_str[c + 1];
   }
   msg_str[5] = NULL;
}

/* Set one line in the message window */
void set_msg_str(unsigned int line, char *s)
{
   if (line <= 5) {
      clr_msg_str(line);
      msg_str[line] = strdup(s);
      msg_timer += 80;
   }
}

/* Pushes message string in the first free line, scrolls if nescessary */
void push_msg(char *msg, ...)
{
   int c;
   char *s = malloc(512);

   va_list ap;

   va_start(ap, msg);
   uvsprintf(s, msg, ap);
   va_end(ap);

   for (c = 0; c < 6; c++)
      if (!msg_str[c]) {
         set_msg_str(c, s);
         free(s);
         return;
      }
   /* Scroll one up */
   scroll_msg_win();
   set_msg_str(5, s);
   free(s);
}

void set_msg_timer(unsigned int value)
{
   msg_timer = value;
}

int get_msg_timer(void)
{
   return msg_timer;
}

int dec_msg_timer(void)
{
   if (msg_timer)
      msg_timer--;
   return msg_timer;
}

/* Global game messages; like conversations */
void clear_global_msg(void)
{
   int c;

   if (!num_global_msg)
      return;
   for (c = 0; c < num_global_msg; c++)
      free(global_msg[c]);
   free(global_msg);
   num_global_msg = 0;
}

/* Add a copy of s to the end of the list */
void push_global_msg(char *s)
{
   global_msg = realloc(global_msg, (num_global_msg + 1) * sizeof(char *));
   global_msg[num_global_msg] = strdup(s);
   num_global_msg++;
}

/* Add a copy of s to the list, unless it already exists. Returns the */
/*  index number for s */
int add_global_msg(char *s)
{
   int c;

   for (c = 0; c < num_global_msg; c++)
      if (!strcmp(global_msg[c], s))
         return c;
   /* Message didn't exist yet */
   push_global_msg(s);
   return num_global_msg - 1;
}

char *get_global_msg(unsigned int num)
{
   if (num >= num_global_msg)
      return NULL;
   return global_msg[num];
}
