//GIFAllegS ver 1.00
//By Hard Rock
//Website http://stars.hybd.net, Email hard_rock_2@yahoo.com
#include "allegro.h"
#include "sgif.h"

//Internal defines, not for use elsewhere
#define GIF_EOI (1 << al_gif->cc) + 1   //Tells end of gif file 
#define GIF_CC  (1 << al_gif->cc)        //Tells to clear gif table
//We need to define it to tell compiler it exists
int _color_load_depth(int depth, int alpha);
//The only global variable
int gif_a_settings = 0;
///////LZW CODE/////////////////////////////////////////
//Creates the table
int create_lzw_table (LZW *table, int bits)
{
table->prefix = malloc(sizeof(unsigned short int) * (1<<(bits)));
table->character = malloc(sizeof(short int) * (1<<(bits)));
table->string = malloc(sizeof(unsigned char) * (1<<bits));
table->lzw_size = (1<<(bits))-1; //One less, becuase of 0 :)
clear_lzw_tablef(table,bits);
return 0;
}

//Free's the table
int delete_lzw_table (LZW *table)
{
//Error Checking
if(!table)
 return 1; //Error
//Free memory
if(table->prefix)
    free(table->prefix);
if(table->character)
    free(table->character);
if(table->string)
    free(table->string);
//Clear pointers
table->string = NULL;
table->prefix = NULL;
table->character = NULL;
//Set Defaults
table->codes_used = 0;
table->codes_reserved = 255; //255 by default
return 0;
}



//Clears the table's values
int clear_lzw_table(LZW *table)
{
int looper;
//Some Error Checking
if(!table)
 return 1;
if(!table->prefix || !table->character)
 return 1;
//Clear Table
for(looper = 0; looper < table->lzw_size+1; looper++)
{
    table->prefix[looper] = 0; 
    table->character[looper] = -1; //Would use 0, but NULL uses it
    table->string[looper] = 0;
}
return 0;
}

//Completely Clears the table
int clear_lzw_tablef(LZW *table,int bits)
{
int looper;
//Some Error Checking
if(!table)
 return 1;
if(!table->prefix || !table->character)
 return 1;
//Clear Table
for(looper = 0; looper < table->lzw_size+1; looper++)
{
    table->prefix[looper] = 0; 
    table->character[looper] = -1; //Would use 0, but NULL uses it
    table->string[looper] = 0;
}
//FIXME, doesnt seem to like allocated chars, is there a reason?
//strcpy(table->string,""); //Clears String
table->codes_used = 0;
table->codes_reserved = 255;
table->buffer = 0;
table->buffer_bits = 0;
table->bits = bits;
table->buffer_size = 0; //tells how big buffer chunks are
table->to_nbuffer = 0;

return 0;
}

//This is a little handy tool that returns the string
//Corrosponding to the appropriate string ID.
//Returns the size of the string
int lzw_get_string( LZW *table,int code_number)
{
int looper= 0;
 while(code_number > table->codes_reserved)
 { 
  table->string[looper] = table->character[code_number];
  code_number = table->prefix[code_number];
  looper++; 
 }
 table->string[looper] = code_number;
 looper++;
 table->string[looper] = '\0'; //End of string
 return looper;
}


//This formula is really easy to understand
//Simply Does a brute-force search throught the entire table
//However, it is optimized not to look at lower code values then itself
int lzw_find_code(LZW *table, int string_buffer, int character)
{
int looper;
looper = string_buffer; //A code after string buffer cant be below
//The Search
for(; looper <= table->codes_used+table->codes_reserved;looper++)
 {
  //If we find a match
  if(string_buffer == table->prefix[looper] && character == table->character[looper])
    return looper;
 }
//If not we return the next available code 
return table->codes_used + 1 +table->codes_reserved;
}
//////////////////////////////////////////////////////



//////////GIF Code//////////////////////////////////////

unsigned char gmem_getc(GIF_DATA * fp)
{
	unsigned char temp;
	temp = *((unsigned char *)(fp->mem_data));
	fp->mem_data+=1;//Increase adress by a byte
	return temp;
}

//Fread alternative
void gmem_fread(void * data,int size,GIF_DATA * fp)
{
	int looper;
	unsigned char *mdata;
	mdata = data;
	for(looper = 0; looper < size;looper++)
	{
	   mdata[looper] = *(unsigned char *)(fp->mem_data);
	   fp->mem_data += 1;
	}
}





//This functions load data from a memory gif
//Grabs a char, and sends it one forward
//Not to sure how **p works,
//Im sure thers a simpeler way
unsigned char gif_getc(GIF_DATA *fp)
{
	if(fp->fp_data)
		return pack_getc(fp->fp_data);
	else if(fp->mem_data)
	    return gmem_getc(fp);
	else 
	    return 0;
}

void gif_fread(void * data,int size,GIF_DATA * fp)
{
	if(fp->fp_data)
	     pack_fread(data,size,fp->fp_data);
	else if(fp->mem_data)
		gmem_fread(data,size,fp);
}





//Gets the GIF Code, is slightly different then the lzw version
int get_gif_lzw_code(LZW *table, GIF_DATA *gif)
{
unsigned int code;

while(table->buffer_bits <=(int)((sizeof(int)-sizeof(char))*8) && table->to_nbuffer > 0)//Never go over than size - 8or we loose data
 {
   table->buffer |= ((unsigned char)gif->buffer[table->buffer_size-table->to_nbuffer]) << table->buffer_bits; //We store all data in the buffer
   table->buffer_bits+= 8; 
   table->to_nbuffer--;
}

code = table->buffer << (sizeof(int) * 8 - table->bits); //extract code
code = code   >> (sizeof(int) * 8 - table->bits);
table->buffer >>= table->bits; //remove code from buffer
table->buffer_bits -= table->bits;

   
   if(table->to_nbuffer <= 0 && (int)code != (1 << gif->cc) + 1  && table->buffer_bits <table->bits) //We reset the table data
   { 
    table->buffer_size = gif_getc(gif);
    table->to_nbuffer = table->buffer_size;
    gif_fread(&gif->buffer,table->buffer_size,gif);
    }

return code;
//This is the old unoptimized code which
//Is bug free. This is kept here just in case the above has bugs.
/*int code, looper;
//Gif speciallized code
//Restart new buffer block?
code = 0;
//Read required number of buts
 for (looper = 0; looper < table->bits; looper++) 
 {
    //Maybe, a new byte needs to be loaded with a further 8 bits
    if (table->buffer == 8) 
    {
     table->to_nbuffer--;
     table->buffer = 0;
    if(table->to_nbuffer <= 0)
     { 
      table->buffer_size = gif_getc(gif);
      table->to_nbuffer = table->buffer_size;
      table->buffer_bits = 0;
      table->buffer = 0;
      gif_fread(&gif->buffer,table->buffer_size,gif);
     }
    }
    //Add the current bit to the code
   if (gif->buffer[table->buffer_size-table->to_nbuffer] & 1)
   { 
    code += 1 << looper;
   } 
    gif->buffer[table->buffer_size-table->to_nbuffer] >>= 1;
    table->buffer++;
 }
return code;*/
}

//Calculated which line the gif loader is on
__inline int calc_interlaced_line(GIF_DATA *gif,long counter)
{
 if(counter / gif->image->w < (gif->image->h-1) / 8 +1) //First pass
    return (counter / gif->image->w)*8;
 else if(counter / gif->image->w < (gif->image->h-1)/8 + (gif->image->h-1-4) / 8 + 2)
     return (counter / gif->image->w -  (gif->image->h-1)/8  - 1) * 8 + 4;
 else if(counter / gif->image->w < (gif->image->h-1)/8 + (gif->image->h-1-4) / 8 + (gif->image->h-1-2)/4 +3)  
     return (counter / gif->image->w - 2 - ((gif->image->h-1-4) / 8 + (gif->image->h-1)/ 8))*4 +2;
 else 
    return (counter / gif->image->w - 3 - (gif->image->h-1)/8 - (gif->image->h-1-4) /8 - (gif->image->h-1-2) / 4)*2+1;

}    

//This makes a calculation Based on width and height where the pixel should go
__inline void draw_lzw_pixel(GIF_DATA *gif, long counter,unsigned char color)
{
if(gif->usetransparent)
{
if(gif->transparent != 0 && color == 0)
 color = gif->transparent;
else  if(color == gif->transparent)	
 color = 0;
}	
if(gif->interlaced)
{

  gif->image->line[gif->lineh][gif->liner] = color;
   gif->liner++;
  if(gif->liner == gif->image->w)
  {
   gif->liner = 0;
   gif->lineh = calc_interlaced_line(gif,counter+1);
  }   
 }
 else
 {
   gif->image->line[gif->lineh][gif->liner] = color;
   gif->liner++;
  if(gif->liner == gif->image->w)
  {
   gif->liner = 0;
   gif->lineh++;
  }     
 }
}




//Loads a gif, using PackFILE
BITMAP *load_gif(const char *filename, RGB *pal)
{
//These are used to swap
RGB *g_pal;
//Compression
GIF_DATA al_gif;
PACKFILE *fp;
LZW table;
//Allocate Memory
create_lzw_table(&table,12);
//Start Code
//Open File
if(!(fp = pack_fopen(filename, "rb")))
     return NULL; 
g_pal = pal;
if(!g_pal)
 {
 g_pal = malloc(sizeof(RGB) * 256);
 }
al_gif.fp_data = fp;
if(load_gif_header(&al_gif, g_pal))
{
    if(g_pal != pal)
     free(g_pal);
    pack_fclose(fp);
    delete_lzw_table(&table);
    return NULL;
}    
load_gimage_header(&al_gif,&table, g_pal);
decode_gif_image(&al_gif,&table, g_pal);

//Close and clean up

pack_fclose(fp);
delete_lzw_table(&table);


//Check to see if we allocated palette

if(g_pal != pal)
  free(g_pal);


return al_gif.image;
}


//Loads a gif, using PackFILE
BITMAP *load_gif_memory(void *fp, RGB *pal)
{
//These are used to swap
RGB *g_pal;
//Compression
GIF_DATA al_gif;
LZW table;

//Allocate Memory
create_lzw_table(&table,12);
//Start Code
g_pal = pal;
al_gif.mem_data = fp;
al_gif.fp_data = NULL;
if(!g_pal)
 {
 g_pal = malloc(sizeof(RGB) * 256);
 }

if(load_gif_header(&al_gif, g_pal))
{
    if(g_pal != pal)
     free(g_pal);
     delete_lzw_table(&table);
    return NULL;
}    

load_gimage_header(&al_gif,&table, g_pal);
decode_gif_image(&al_gif,&table, g_pal);


//Close and clean up

delete_lzw_table(&table);


//Check to see if we allocated palette

if(g_pal != pal)
  free(g_pal);


return al_gif.image;
}


//Loads the starting header
//returns 1 on error
int load_gif_header(GIF_DATA *al_gif,RGB *pal)
{
int looper;
//Open File
for(looper = 0;looper <6;looper++)
   al_gif->id[looper] = gif_getc(al_gif);

//Test if valid header
if(al_gif->id[0] != 'G' || al_gif->id[1] !='I' || al_gif->id[2] !='F')
   return 1;

//Load Widths
gif_fread(&al_gif->s_width, 2, al_gif);  //Screen Width
gif_fread(&al_gif->s_height,2, al_gif);  //Screen Height
//Get Important Info
al_gif->global_depth = gif_getc(al_gif);  //Colour Depths
al_gif->bpp = 1 + (al_gif->global_depth & 7);
//Irrelevant Entries,
//We dont need to use these
al_gif->background = gif_getc(al_gif); //Background Colour
gif_getc(al_gif); //Pixel Aspect Ratio
//If the palette is global, we load it
//if(al_gif->global_depth & 0x07)
if(al_gif->global_depth & 128)
{
  for(looper = 0; looper < (1 << al_gif->bpp); looper++)
  {

	  pal[looper].r = (gif_getc(al_gif) /4);
      pal[looper].g = (gif_getc(al_gif) /4);
      pal[looper].b = (gif_getc(al_gif) /4);
  }
}


return 0;

}

//Loads an individual image header
//returns 1 on error, 2 when done
int load_gimage_header(GIF_DATA *al_gif,LZW*table,RGB *pal)
{

int looper = 1;
unsigned char temp;
al_gif->transparent = 0;
al_gif->usetransparent = 0;

//We Look For a Header
//We keep reading until "," which begins the image header.

while(looper)
{
  switch(gif_getc(al_gif))
  {
      
  case ';': //End of File
      return 2;
  case ',': //Start of new Image
	  looper = 0;
	  break;
  case '!': //Gif 89a With special settings
	  temp = gif_getc(al_gif);
      if(temp == 0x01) //Plain text extension, ignore text
      {
       while(gif_getc(al_gif) != 0){}
        break;
      }    
      if(temp == 0xFE) //Plain text extension, ignore text
      {
       while(gif_getc(al_gif) != 0){}
        break;
      }    
      if(temp == 0xF9)
	  {
        gif_getc(al_gif); //Contains the fixed value 4
		al_gif->transparent = gif_getc(al_gif); //Contains the packed fields
		al_gif->disposal = al_gif->transparent << 3;
		al_gif->disposal = al_gif->disposal >> 5;
        gif_fread(&al_gif->delay,sizeof(unsigned short int),al_gif); //Contains Packed Fields
		if(al_gif->transparent & 1) //Check if transparency flag is set
		{
		 al_gif->transparent = gif_getc(al_gif); //The Transparency Color
         al_gif->usetransparent = 1;
        }
        else
        {
         al_gif->transparent = 0;
         al_gif->usetransparent = 0;
         }
		
		
	  }
	  
	  break;
  }
//Some error checking)
   if(al_gif->fp_data)
   if(pack_feof(al_gif->fp_data))
    return 1;

}
//Read image header, the sizes
gif_fread(&(al_gif->ileft), 2, al_gif); 
gif_fread(&(al_gif->itop), 2,  al_gif); 
gif_fread(&(al_gif->iwidth), 2,  al_gif); 
gif_fread(&(al_gif->iheight), 2, al_gif); 
//Get local depth
al_gif->depth = gif_getc(al_gif);
//Allocate Memory
if(!(al_gif->image = create_bitmap_ex(8,al_gif->iwidth, al_gif->iheight)))
 return 1;


//We don't support all gif's 
//For this little proggy
  if (al_gif->depth & 128) 
  {
  //Local Colour Table
  for(looper = 0; looper < (1 << al_gif->bpp); looper++) 
  {
      pal[looper].r = (gif_getc(al_gif) /4);
      pal[looper].g = (gif_getc(al_gif) /4);
      pal[looper].b = (gif_getc(al_gif) /4);
  }
  }
  if (al_gif->depth & 64) 
     al_gif->interlaced = 1;
  
  else 
    al_gif->interlaced = 0;

if(al_gif->usetransparent && al_gif->transparent != 0)
   pal[al_gif->transparent] = pal[0];


//Last Minute Initalizing
al_gif->cc = gif_getc(al_gif);        //Save starting size 
al_gif->code_size = al_gif->cc + 1;   //Starting Code Size
table->bits = al_gif->code_size;     //Bits used for table
table->buffer_size = gif_getc(al_gif);      //al_gif.block_byte; //Buffer size
table->to_nbuffer = table->buffer_size;  //Countdown
table->codes_reserved = GIF_EOI;        //Set reserved code
return 0;

}

//Loads a gif IMAGE
int decode_gif_image(GIF_DATA *al_gif,LZW *table, RGB *pal)
{
//These are used to swap
BITMAP *t_bitmap;
int looper;
///Everything here from Decompress LZW
short int first_code = -1;      //Check psuedo code, grabs next char
unsigned short int next_code;     
short int first_char = -1;   //Is for the if fix,make sure is 0 to escape potential bugs

//This is for graphics optimization
al_gif->liner = 0;
al_gif->lineh = 0; 
if(al_gif->interlaced)
   al_gif->lineh = calc_interlaced_line(al_gif,0);

//Some Beforehand Initialization
al_gif->counter = 0;                    //restart drawing buffer
gif_fread(&al_gif->buffer,table->buffer_size,al_gif); //Load buffer
//End last init

//We start the loop
while((next_code = get_gif_lzw_code(table,al_gif))!= GIF_EOI && al_gif->counter <= (al_gif->image->w*al_gif->image->h))
  {
   if(next_code == GIF_CC) //If it's a clear code
    {
      clear_lzw_table(table);   //We clear everthing and laod first code
      table->codes_used = 0;
      al_gif->code_size = al_gif->cc+1;
      table->bits = al_gif->cc+1;
      next_code = get_gif_lzw_code(table,al_gif);
      first_code = next_code;
      first_char = first_code;
      //allegro_message("wtf");
      draw_lzw_pixel(al_gif,al_gif->counter,next_code); //Draw first_code
      al_gif->counter++;
    }
//If its not a clear code, or an EOI
    else
    {
    //If not in table
      if (next_code > table->codes_used + table->codes_reserved)          
      {
        table->codes_used++;
        table->prefix[next_code]= first_code;
        table->character[next_code]=first_char;
        looper = lzw_get_string(table,next_code);
      }
      //If the code was already in the table
      //See if we can add a new code to the table
      //Make sure we have not gone over the table size
      else if(table->codes_used + table->codes_reserved < table->lzw_size )                                   
      {                                       
          looper = lzw_get_string(table,next_code);
          table->codes_used++;
          table->prefix[table->codes_used +table->codes_reserved]= first_code;
          table->character[table->codes_used +table->codes_reserved]=table->string[looper-1];
      }
      else //Characters that we output
        looper = lzw_get_string(table,next_code);


    //We Draw the gif
      first_char = table->string[looper-1];    
      first_code = next_code;
      while(looper > 0)
       {
       draw_lzw_pixel(al_gif,al_gif->counter,table->string[looper-1]);
       al_gif->counter++;
 
       looper--;
       }
 
  //This is a check to see if the code_size must grow by a bit or not.
    if((1 << al_gif->code_size)-1 <= table->codes_used + table->codes_reserved && al_gif->code_size < 12)
    {
    table->bits++;
    al_gif->code_size++;
    }
   
   }//End else 
   } //End While

//Correct Colour Conversion
if(_color_load_depth(8,0) != 8)
  {
  t_bitmap = create_bitmap_ex(_color_load_depth(8,0),al_gif->iwidth, al_gif->iheight);
  select_palette(pal);
  //Hack for transparency
  if(al_gif->usetransparent)
  {
  rectfill(t_bitmap,0,0,t_bitmap->w,t_bitmap->h,makecol(255,0,255));
  //masked_blit(al_gif->image, t_bitmap, 0, 0, 0, 0, al_gif->image->w, al_gif->image->h);
  draw_sprite(t_bitmap,al_gif->image,0,0);
  }
  else
  {
  blit(al_gif->image, t_bitmap, 0, 0, 0, 0, al_gif->image->w, al_gif->image->h);
  }
  destroy_bitmap(al_gif->image);
  al_gif->image = t_bitmap;
  unselect_palette();
  }


return 0;
}



void free_gifa(GIF_ANIM *gif_a)
{
GIF_FRAME *temp;
GIF_FRAME *next;
if(gif_a)
{
temp = gif_a->frames;
while (temp) {
 next = temp->next;
 destroy_bitmap(temp->image);
 free(temp);
 temp = next;
 }
free(gif_a);
}
}

//This one is for internal use, different then load_gif_frame
void create_gif_frame(GIF_DATA *al_gif,BITMAP *frame,BITMAP *prev,RGB *g_pal,int free_prev)
{


     if(al_gif->usetransparent)
     {
     draw_sprite(frame,al_gif->image,al_gif->ileft,al_gif->itop);
     }        
     else
     {
     blit(al_gif->image,frame,0,0,al_gif->ileft,al_gif->itop,al_gif->image->w,al_gif->image->h);
     }    
     destroy_bitmap(al_gif->image);   
     if(_color_load_depth(8,0) == 8)
         al_gif->image = create_bitmap_ex(8,al_gif->s_width,al_gif->s_height);
     else
         al_gif->image = create_bitmap(al_gif->s_width,al_gif->s_height);         

//     al_gif->image = create_bitmap(al_gif->s_width,al_gif->s_height);
     blit(frame,al_gif->image,0,0,0,0,al_gif->image->w, al_gif->image->h);   

     
     //We Do Animation Restore Now
     if(al_gif->disposal == 2)
     {
       if(al_gif->background == 0 || (al_gif->background == al_gif->transparent && al_gif->usetransparent)  || gif_a_settings & 1)
        if(_color_load_depth(8,0) == 8)
         rectfill(frame,0,0,frame->w,frame->h,0);
        else
         rectfill(frame,0,0,frame->w,frame->h,makecol(255,0,255));
       else
        rectfill(frame,0,0,frame->w,frame->h,makecol(g_pal[al_gif->background].r*4,g_pal[al_gif->background].g*4,g_pal[al_gif->background].b*4));
     }    
     else if(al_gif->disposal == 3)
     {
      blit(prev,frame,0,0,0,0,prev->w,prev->h);
     }    
   if(free_prev)
    destroy_bitmap(prev);   
   prev = al_gif->image;


    
}    

GIF_ANIM* create_gif_a(GIF_DATA *al_gif,LZW *table, RGB *g_pal,int frame_num)
{
BITMAP *frame = NULL;
BITMAP *prev = NULL;
GIF_ANIM *gif_a;
GIF_FRAME *temp = NULL;
int looper = 0;
if(!frame_num)
{
gif_a = malloc(sizeof(GIF_ANIM));
if(!gif_a)
  return NULL;
gif_a->num_frames = 0;
}
else
  gif_a = NULL;



while(!load_gimage_header(al_gif,table, g_pal))
{
if(!frame)
{

//We Set the frame Background
if(_color_load_depth(8,0) == 8)
         frame = create_bitmap_ex(8,al_gif->s_width,al_gif->s_height);
else
         frame = create_bitmap(al_gif->s_width,al_gif->s_height);         

   if(al_gif->background == 0 ||(al_gif->background == al_gif->transparent && al_gif->usetransparent)  || gif_a_settings & 1)
      if(_color_load_depth(8,0) == 8)
      {
        rectfill(frame,0,0,frame->w,frame->h,0);
      }    
      else
      {
         rectfill(frame,0,0,frame->w,frame->h,makecol(255,0,255));
      }    
   else
      rectfill(frame,0,0,frame->w,frame->h,makecol(g_pal[al_gif->background].r*4,g_pal[al_gif->background].g*4,g_pal[al_gif->background].b*4));
}    
    rectfill(frame,0,0,frame->w,frame->h,0);
    decode_gif_image(al_gif,table, g_pal);
    if(!frame_num)
    create_gif_frame(al_gif,frame,prev,g_pal,0);
    else
    create_gif_frame(al_gif,frame,prev,g_pal,1); //The last flag is wether of not to free up the prev image

if(!frame_num)
{
    gif_a->num_frames++;
    if(!temp) //First Image
    {
        temp = malloc(sizeof(GIF_FRAME)); //Potential Memory Leak
        if(!temp)
          return NULL;
        gif_a->frames = temp;
        temp->next = NULL;
        //Now we update the frame
    }
    else  //Rest of Images
    {
        temp->next = malloc(sizeof(GIF_FRAME)); //Potential Memory Leak
        if(!temp->next)
         return NULL;
        temp = temp->next;
        temp->next = NULL;
    }

   temp->image = al_gif->image;
   temp->delay = al_gif->delay;
   //Copy Palette Now
    
  for(looper = 0; looper < (1 << al_gif->bpp); looper++) 
  {
      temp->pal[looper] = g_pal[looper];
  }
}
else
{
    looper++;
    if(frame_num == looper)
    {
      prev = al_gif->image;
      break;
    }       


}      

   clear_lzw_tablef(table,12);
}


if(!frame_num)
{
//Set up some settings
    gif_a->frame_width = al_gif->s_width;
    gif_a->frame_height = al_gif->s_height;
    gif_a->frame_color = al_gif->background;
    gif_a->timepassed = 0;
    if(al_gif->global_depth & 128)
     gif_a->local_pal = 1;
    else 
     gif_a->local_pal = 0;

}    



if(frame)
  destroy_bitmap(frame);


return gif_a;
}    


//Loads an animted gif from a file
void *load_gif_animated_memory(void * fp)
{
//These are used to swap
RGB *g_pal;
//Compression
GIF_ANIM *gif_a;
GIF_DATA al_gif;
LZW table;


//Allocate Memory
create_lzw_table(&table,12);
//Open File
al_gif.mem_data = fp;
al_gif.fp_data = NULL;
//Create Colour Table
g_pal = malloc(sizeof(RGB) * 256);
if(load_gif_header(&al_gif, g_pal))
{
 if(g_pal)
   free(g_pal);
 delete_lzw_table(&table);
 return NULL;
} 
//This new sub does all the work
//Here we load the gif
gif_a =  create_gif_a(&al_gif,&table, g_pal,0);

//Close and clean up
if(g_pal)
  free(g_pal);

delete_lzw_table(&table);
return gif_a;
}


//Loads an animted gif from a file
GIF_ANIM *load_gif_animated(const char *filename)
{
//These are used to swap
RGB *g_pal;
//Compression
GIF_ANIM *gif_a;
GIF_DATA al_gif;
PACKFILE *fp;
LZW table;


//Open File
if(!(fp = pack_fopen(filename, "rb")))
     return NULL; 
//Allocate Memory
create_lzw_table(&table,12);
al_gif.fp_data = fp;
//Create Colour Table
g_pal = malloc(sizeof(RGB) * 256);
if(load_gif_header(&al_gif, g_pal))
{
if(g_pal)
  free(g_pal);
delete_lzw_table(&table);
pack_fclose(fp);
 return NULL;
} 
//This new sub does all the work
//Here we load the gif
gif_a =  create_gif_a(&al_gif,&table, g_pal,0);
//Close and clean up
if(g_pal)
  free(g_pal);

delete_lzw_table(&table);
pack_fclose(fp);
return gif_a;
}

//Loads an animted gif from a file
int load_gif_animated_call(const char *filename, int(*callback)(GIF_FRAME *))
{

//These are used to swap
RGB *g_pal;
//Compression
GIF_ANIM *gif_a;
GIF_DATA al_gif;
PACKFILE *fp;
LZW table;
GIF_FRAME *temp;


//Open File
if(!(fp = pack_fopen(filename, "rb")))
     return -1; 
//Allocate Memory
create_lzw_table(&table,12);
al_gif.fp_data = fp;
//Create Colour Table
g_pal = malloc(sizeof(RGB) * 256);
if(load_gif_header(&al_gif, g_pal))
{
if(g_pal)
  free(g_pal);
delete_lzw_table(&table);
pack_fclose(fp);
 return -1;
} 
//This new sub does all the work
//Here we load the gif
gif_a =  create_gif_a(&al_gif,&table, g_pal,0);
temp = gif_a->frames;
while(temp)
{
 callback(temp); //Call pointer
}    
//Close and clean up
if(g_pal)
  free(g_pal);
//Destroy data but not images
while(gif_a->frames)
{
temp = gif_a->frames->next;
free(gif_a->frames);
gif_a->frames = temp;
}    
free(gif_a);
//free_gif(gif_a);
delete_lzw_table(&table);
pack_fclose(fp);
return 0;


return 0;
}



//Loads a single frame of an animated gif
BITMAP *load_gif_animated_frame(const char *filename,RGB *pal,int frame_num)
{
//These are used to swap
BITMAP *temp = NULL;

RGB *g_pal;
//Compression
GIF_DATA al_gif;
PACKFILE *fp;
LZW table;

//Frame must be a real number
if(frame_num == 0 || frame_num < 0)
 return NULL;

  
//Open File
if(!(fp = pack_fopen(filename, "rb")))
     return NULL; 
//Allocate Memory
create_lzw_table(&table,12);


al_gif.fp_data = fp;


if(!pal)
g_pal = malloc(sizeof(RGB) * 256);
else
g_pal = pal;
if(load_gif_header(&al_gif, g_pal))
{
 if(g_pal != pal)
  free(g_pal);
  pack_fclose(fp);
 delete_lzw_table(&table);
 return NULL;
} 
create_gif_a(&al_gif,&table, g_pal,frame_num);
temp = al_gif.image;   
//Close and clean up
if(g_pal != pal)
  free(g_pal);
pack_fclose(fp);
delete_lzw_table(&table);
return temp;
}


//Loads an animted gif from a file
void *load_gif_anim_datafile(PACKFILE *fp, long size)
{
RGB *g_pal;
//Compression
GIF_DATA al_gif;
GIF_ANIM *gif_a;
LZW table;

//Not needed, but you get a warning with -Wall so what the heck
if(!size)
  return NULL;

//Allocate Memory
create_lzw_table(&table,12);

gif_a = malloc(sizeof(GIF_ANIM));
if(!gif_a)
  return NULL;

al_gif.fp_data = fp;

g_pal = malloc(sizeof(RGB) * 256);
if(load_gif_header(&al_gif, g_pal))
{
//Close and clean up
if(g_pal)
  free(g_pal);
delete_lzw_table(&table);
 return NULL;
} 



//This new sub does all the work
//Here we load the gif
gif_a =  create_gif_a(&al_gif,&table, g_pal,0);

//Close and clean up
if(g_pal)
  free(g_pal);
delete_lzw_table(&table);

return gif_a;
}


//Loads a gif, using PackFILE
void *load_gif_datafile(PACKFILE *fp, long size)
{
//These are used to swap
//Compression
GIF_DATA al_gif;
GIF *r_gif;
LZW table;

//This is to be returned, instead of a bitmap
r_gif = malloc(sizeof(GIF));
if(!r_gif)
  return NULL;

//Not needed, but you get a warning with -Wall so what the heck
if(!size)
  return NULL;

//Allocate Memory
create_lzw_table(&table,12);
al_gif.fp_data = fp;
if(load_gif_header(&al_gif, r_gif->pal))
{
//Close and clean up
if(r_gif)
  free(r_gif);
delete_lzw_table(&table);   
return NULL;
}
load_gimage_header(&al_gif,&table, r_gif->pal);
decode_gif_image(&al_gif,&table, r_gif->pal);

//Close and clean up
delete_lzw_table(&table);

//We Set the image
r_gif->image =  al_gif.image;

return r_gif;
}


void destroy_gif_anim_datafile(void *data)
{
if(data)
  free_gifa((GIF_ANIM *)data);
}    


void destroy_gif_datafile(void *data)
{
GIF *r_gif;
r_gif = (GIF*)data;
if(r_gif)
 {
  destroy_bitmap(r_gif->image);
  free(r_gif);
 }
}


//In here we create a gif image
//Do the colour Conversion
//and open/close files
int save_gif(AL_CONST char *filename,BITMAP *image,AL_CONST RGB *pal)
{
GIF_DATA al_gif;
BITMAP *t_bitmap = NULL;
RGB_MAP *prev; //Create a colour conversion table
RGB_MAP nmap;
al_gif.fp_data = pack_fopen(filename,"wb");

if(!al_gif.fp_data)
 return -1;
if(!image)
 return -1;
al_gif.image = image;
if(!pal)
  pal = default_palette;
//Correct Colour Conversion
//If needed
if(_color_load_depth(8,0) != 8 && bitmap_color_depth(al_gif.image) != 8)
  {
  t_bitmap = create_bitmap_ex(8,image->w, image->h);
  create_rgb_table(&nmap, pal, NULL);
  prev = rgb_map;
  rgb_map = &nmap;
  select_palette(pal);
  //Transparency conversion when in depth higher then 8 is not supported
  blit(image, t_bitmap, 0, 0, 0, 0, image->w, image->h);
  al_gif.image = t_bitmap;
  unselect_palette();
  rgb_map = prev;
  }

write_gif_header(al_gif.fp_data,al_gif.image->w, al_gif.image->h,pal);
write_gif_frame(al_gif.fp_data,&al_gif,pal);
pack_putc(0x00,al_gif.fp_data); //CSome Space
pack_putc(0x3B,al_gif.fp_data); //Close the file
pack_fclose(al_gif.fp_data);
if(t_bitmap)
destroy_bitmap(t_bitmap);
//free(&al_gif);
return 0;
}    

int save_gif_anim(AL_CONST char *filename,GIF_ANIM *ga)
{
GIF_DATA al_gif;
RGB *pal;
GIF_FRAME *temp;
BITMAP *t_bitmap = NULL;
RGB_MAP *prev; //Create a colour conversion table
RGB_MAP nmap;
al_gif.fp_data = pack_fopen(filename,"wb");

if(!al_gif.fp_data)
 return -1;
if(!ga)
 return -1;

write_gif_header(al_gif.fp_data,ga->frame_width, ga->frame_height,ga->frames->pal);
temp = ga->frames;
while(temp)
{
al_gif.image = temp->image;
pal = temp->pal;
al_gif.delay = temp->delay;
if(!pal)
  pal = default_palette;
//Correct Colour Conversion
//If needed
if(_color_load_depth(8,0) != 8 && bitmap_color_depth(al_gif.image) != 8)
  {
  t_bitmap = create_bitmap_ex(8,temp->image->w, temp->image->h);
  create_rgb_table(&nmap, pal, NULL);
  prev = rgb_map;
  rgb_map = &nmap;
  select_palette(pal);
  //Transparency conversion when in depth higher then 8 is not supported
  blit(temp->image, t_bitmap, 0, 0, 0, 0, temp->image->w, temp->image->h);
  al_gif.image = t_bitmap;
  unselect_palette();
  rgb_map = prev;
  }


write_gif_frame(al_gif.fp_data,&al_gif,pal);
pack_putc(0x00,al_gif.fp_data); //Some Space
temp = temp->next;
destroy_bitmap(t_bitmap);
}

pack_putc(0x00,al_gif.fp_data); //Some Space
pack_putc(0x3B,al_gif.fp_data); //Close the file
pack_fclose(al_gif.fp_data);
if(t_bitmap)
destroy_bitmap(t_bitmap);
//free(&al_gif);
return 0;
}
//Writes the header for a saved gif
int write_gif_header(PACKFILE *fp,int width, int height,AL_CONST RGB *pal)
{
unsigned char temp = 0;
int looper;
if(!fp)
 return -1;
//Write Header
pack_putc('G',fp);
pack_putc('I',fp);
pack_putc('F',fp);
pack_putc('8',fp);
pack_putc('9',fp);
pack_putc('a',fp);
//Screen Descripter
pack_fwrite(&width,2,fp);
pack_fwrite(&height,2,fp);
temp = 119; //Set pallete to 7, and coulour depth to 7
if(!(gif_a_settings & 2))
 temp |= 128; //Yes there is a global palette
pack_putc(temp,fp);
temp = gif_a_settings >> 3; //we grab the background colour
pack_putc(temp,fp);
pack_putc(0,fp);
//Global Header if applicable
if(!pal)
pal = default_palette;
if(!(gif_a_settings &2))
{
 for(looper = 0;looper < 256;looper++)
 {
      pack_putc(pal[looper].r * 4,fp);
      pack_putc(pal[looper].g * 4,fp);
      pack_putc(pal[looper].b * 4,fp);
 }    
}
return 0;

}    

int write_gif_frame(PACKFILE *fp,GIF_DATA *al_gif,AL_CONST RGB *pal)
{
LZW *table;
int looper = 0;
unsigned char temp = 0;

//The normal compress variables
short int next_char;      //Check psuedo code, grabs next char
short int string_buffer;  //Check the psuedo code, hold string info
short int code_number;    //Holds code value for STRING_BUFFER
char written = 0;
//Graphic Control Extension
pack_putc(0x21,fp);
pack_putc(0xF9,fp);
pack_putc(4,fp);
if(gif_a_settings & 8) //If using trapnsparent or not
 pack_putc(0,fp);
else
 pack_putc(1,fp);
pack_fwrite(&(al_gif->delay),2,fp);
pack_putc(0,fp); //0 is Transparent
pack_putc(0,fp); //Block Terminator

//Write image descriptor
pack_putc(0x2C,fp);
pack_fwrite(&looper,2,fp);
pack_fwrite(&looper,2,fp);
pack_fwrite(&(al_gif->image->w),2,fp);
pack_fwrite(&(al_gif->image->h),2,fp);
temp = 7; //Set pallete to 7
if(gif_a_settings & 4)
 temp|=64;
if(gif_a_settings & 2)
 temp |= 128; //Yes there is a local palette
pack_putc(temp,fp);
//Local Header if applicable
if(!pal)
pal = default_palette;
if(gif_a_settings & 2)
{
 for(looper = 0;looper < 256;looper++)
 {
      pack_putc(pal[looper].r * 4,fp);
      pack_putc(pal[looper].g * 4,fp);
      pack_putc(pal[looper].b * 4,fp);
 }    
}
pack_putc(8,fp); //We Write the starting Code Size
//Now we can get started on writing the image!


//Some Beforehand Initialization
al_gif->counter = 0;                    //restart drawing buffer
for(looper = 0;looper < 255;looper++)
 al_gif->buffer[looper] = 0; //We Clear the buffer
//Create the table
table = malloc(sizeof(LZW));
create_lzw_table(table,12);
table->bits = 9;     //Bits used for table
al_gif->cc = 8;        //Save starting size 
al_gif->code_size = 9;   //Starting Code Size
table->codes_used = 0;
table->to_nbuffer = 0;  //Countdown
table->codes_reserved = GIF_EOI;        //Set reserved code

//We Start adding to the buffer
gif_write_code(table,al_gif,GIF_CC);
string_buffer=gif_get_pixel(al_gif);  //Get the first code
while(1) //End when the file is finished
  {
    next_char = gif_get_pixel(al_gif); //get next code
    if(next_char == -1) //End of image code
     break;
    code_number = lzw_find_code(table,string_buffer,next_char); //look for entry
    if (table->character[code_number] != -1)  //If its in the table
	{
        string_buffer= code_number;     
        written = 0;
	}
    else   //If its not in the table
    {                                      
        //We can only add new entries if the table is not full  
        if (table->codes_used+ table->codes_reserved < table->lzw_size-1)
        {
          table->prefix[code_number]= string_buffer;
          table->character[code_number]=next_char;
          table->codes_used++;
        }        
      if((1 << al_gif->code_size) < table->codes_used + table->codes_reserved && al_gif->code_size < 12)
     {
          table->bits++;
            al_gif->code_size++;
        }
      //We write the code
     written = 1;
     gif_write_code(table,al_gif,string_buffer);
     //This is a check to see if the code_size must grow by a bit or not.
     //Start again
     string_buffer=next_char;     
    
   

    }                                
  }                                  
if(!written)
{
gif_write_code(table,al_gif,string_buffer); //In case last byte was not written/Will flush the buffer if any codes need to be flushed
}
gif_flush_code(table,al_gif); //Any extra bits added to table
if(table->to_nbuffer) //Write out buffer if need be
{
 pack_putc(table->to_nbuffer,fp);
 pack_fwrite(al_gif->buffer,table->to_nbuffer,fp);
} 


return 0;
}    

//This gets the next pixel to write
//Using getpixel incase one wishes to save the screen
int gif_get_pixel(GIF_DATA *gif)
{
long counter = gif->counter;
gif->counter++; //Next Pixel
if(counter >= gif->image->w *gif->image->h)
{
if(counter - gif->image->w *gif->image->h == 0) //This makes sure
   return 257;
if(counter - gif->image->w *gif->image->h == 1) //This makes sure
  return 0; //the above code is written
 else return -1;
}
 
if(gif_a_settings & 4)
{
 if(counter / gif->image->w < (gif->image->h-1) / 8 +1) //First pass
//  return gif->image->line[(counter / gif->image->w)*8][counter % gif->image->w];
    return getpixel(gif->image,counter % gif->image->w,(counter / gif->image->w)*8);
 else if(counter / gif->image->w < (gif->image->h-1)/8 + (gif->image->h-1-4) / 8 + 2)
    return getpixel(gif->image,counter % gif->image->w,(counter / gif->image->w -  (gif->image->h-1)/8  - 1) * 8 + 4);
//  return gif->image->line[(counter / gif->image->w -  (gif->image->h-1)/8  - 1) * 8 + 4][counter % gif->image->w];
 else if(counter / gif->image->w < (gif->image->h-1)/8 + (gif->image->h-1-4) / 8 + (gif->image->h-1-2)/4 +3)  
    return getpixel(gif->image,counter % gif->image->w,(counter / gif->image->w - 2 - ((gif->image->h-1-4) / 8 + (gif->image->h-1)/ 8))*4 +2);
//  return gif->image->line[(counter / gif->image->w - 2 - ((gif->image->h-1-4) / 8 + (gif->image->h-1)/ 8))*4 +2][counter % gif->image->w];
 else 
    return getpixel(gif->image,counter % gif->image->w,(counter / gif->image->w - 3 - (gif->image->h-1)/8 - (gif->image->h-1-4) /8 - (gif->image->h-1-2) / 4)*2+1);
//   return gif->image->line[(counter / gif->image->w - 3 - (gif->image->h-1)/8 - (gif->image->h-1-4) /8 - (gif->image->h-1-2) / 4)*2+1][counter % gif->image->w];
 }
else
    return getpixel(gif->image,counter % gif->image->w,counter / gif->image->w);
//  return gif->image->line[counter / gif->image->w][counter % gif->image->w];

}    

//This writes a code to a file, really cool stuff.
//We support a max of 16 bit compression
//Modified for gif use
int gif_flush_code(LZW *table,GIF_DATA *al_gif)
{
unsigned char tcode;
//Some bit manipulation
if(table->buffer_bits >=0)//Never go less than 8 or we loose data
 {
  tcode = ((unsigned int)(table->buffer)) << (32-table->buffer_bits) >> (32-table->buffer_bits); //extract code
  al_gif->buffer[table->to_nbuffer] = tcode; //We store it in the bufer
  table->to_nbuffer++;
 }
return 0;

}    
int gif_write_code(LZW *table,GIF_DATA *al_gif, unsigned int code)
{
unsigned char tcode;
//Some bit manipulation
table->buffer |= code << (table->buffer_bits);
table->buffer_bits+=table->bits;
while(table->buffer_bits >=8)//Never go less than 8 or we loose data
 {
  tcode = ((unsigned int)(table->buffer)) << (24) >> (24); //extract code
  al_gif->buffer[table->to_nbuffer] = tcode; //We store it in the bufer
  table->buffer >>=8; //Remove the char from the buffer
  table->buffer_bits-= sizeof(char) * 8; //Buffer now stores one less char.
  table->to_nbuffer++;
  if(table->to_nbuffer == 255)
  {
  pack_putc(255,al_gif->fp_data);
  pack_fwrite(al_gif->buffer,255,al_gif->fp_data);
  for(table->to_nbuffer = 0;table->to_nbuffer < 255 ;table->to_nbuffer++)
    al_gif->buffer[table->to_nbuffer] = 0; //We Clear the buffer
  table->to_nbuffer = 0;

  }    
 }
return 0;
}


//This gets an image occording to the time passed.
GIF_FRAME * get_gifa_framet(GIF_ANIM * ga, int timepassed)
{
GIF_FRAME *temp;
if(ga->timepassed < 0)
 ga->timepassed = abs(ga->timepassed);
ga->timepassed+= timepassed;
timepassed = ga->timepassed;
while(1)//Loop Forever
{
 temp = ga->frames;
 timepassed -= temp->delay*10;
 while((temp!=NULL && timepassed >= 0))
 {
  temp = temp->next;
  if(temp !=NULL)
  timepassed -= temp->delay*10;
 }    
 if(timepassed <= 0)
 {
  if(temp == NULL)
   {
     ga->timepassed = timepassed;
     return ga->frames;
   }    
  else
   return temp;
 } 
 ga->timepassed = -timepassed;
}
}    
//Just uses the above code
BITMAP * get_gifa_bitmapt(GIF_ANIM * ga, int timepassed) 
{
return get_gifa_framet(ga,timepassed)->image;
}    

//Grabs frame number specified
GIF_FRAME * get_gifa_framen(GIF_ANIM * ga,  int number)
{
GIF_FRAME *temp;
if(number > ga->num_frames || number < 0)
 return NULL;
temp = ga->frames;
while(ga->frames!=NULL && number > 0)
{
temp = temp->next;
number--;
}    
return temp;
}    
//No point writing code twice....
BITMAP * get_gifa_bitmapn(GIF_ANIM * ga,int number)
{
return get_gifa_framen(ga,number)->image;
}    

//////////////////////////////////////////////////
