/**********************************************/
/* Multi-controller game input routines       */
/* Evert Glebbeek 2002, 2003                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include <string.h>
#include "input.h"
#include "keymap.h"

void load_default_mapping(int player, int driver, int *keymap)
{
   /* Set to -1 `unassigned' by default */
   memset(keymap, -1, NUM_GAMEKEYS*sizeof *keymap);

   /* Ignore player 2 for the time being */
   if (player==1) {
      return;
   }

   if (driver==CTRL_INPUT_KEYB) {        /* Keyboard */
      keymap[GAMEKEY_UP] = KEY_UP;
      keymap[GAMEKEY_DOWN] = KEY_DOWN;
      keymap[GAMEKEY_LEFT] = KEY_LEFT;
      keymap[GAMEKEY_RIGHT] = KEY_RIGHT;
      keymap[GAMEKEY_BUTTON1] = KEY_ALT;
      keymap[GAMEKEY_BUTTON2] = KEY_Z;
      keymap[GAMEKEY_BUTTON3] = KEY_LSHIFT;
      keymap[GAMEKEY_BUTTON4] = KEY_LCONTROL;
      keymap[GAMEKEY_BUTTON5] = KEY_BACKSPACE;
      keymap[GAMEKEY_BUTTON6] = KEY_TAB;
      keymap[GAMEKEY_BUTTON7] = KEY_ENTER;
      keymap[GAMEKEY_BUTTON8] = KEY_SPACE;
   } else if (driver==CTRL_INPUT_JOY1) {    /* Gamepad 1 */
   /* Key numbering isn't the same in Windows as it is in Linux as it is in DOS... set similar keys */
#ifdef ALLEGRO_WINDOWS
      keymap[GAMEKEY_BUTTON1] = 2;                       /* A      */
      keymap[GAMEKEY_BUTTON2] = 1;                       /* B      */
      keymap[GAMEKEY_BUTTON3] = 0;                       /* Y      */
      keymap[GAMEKEY_BUTTON4] = 3;                       /* X      */
      keymap[GAMEKEY_BUTTON5] = 6;                       /* L      */
      keymap[GAMEKEY_BUTTON6] = 7;                       /* R      */
      keymap[GAMEKEY_BUTTON7] = 9;                       /* Start  */
      keymap[GAMEKEY_BUTTON8] = 8;                       /* Select */
#else
#ifdef ALLEGRO_LINUX
      keymap[GAMEKEY_BUTTON1] = 0;                       /* A      */
      keymap[GAMEKEY_BUTTON2] = 1;                       /* B      */
      keymap[GAMEKEY_BUTTON3] = 2;                       /* Y      */
      keymap[GAMEKEY_BUTTON4] = 3;                       /* X      */
      keymap[GAMEKEY_BUTTON5] = 4;                       /* L1     */
      keymap[GAMEKEY_BUTTON6] = 5;                       /* R1     */
      keymap[GAMEKEY_BUTTON7] = 8;                       /* Start  */
      keymap[GAMEKEY_BUTTON8] = 9;                       /* Select */
#else
#ifdef ALLEGRO_DOS
      keymap[GAMEKEY_BUTTON1] = 4;                       /* A      */
      keymap[GAMEKEY_BUTTON2] = 3;                       /* B      */
      keymap[GAMEKEY_BUTTON3] = 2;                       /* Y      */
      keymap[GAMEKEY_BUTTON4] = 6;                       /* X      */
      keymap[GAMEKEY_BUTTON5] = 1;                       /* L1     */
      keymap[GAMEKEY_BUTTON6] = 0;                       /* R1     */
      keymap[GAMEKEY_BUTTON7] = 8;                       /* Start  */
      keymap[GAMEKEY_BUTTON8] = 9;                       /* Select */
#endif
#endif
#endif
   }
}

