#ifndef UGRP_H
#define UGRP_H

#include "unit.h"

/* Flags for unit selection */
#define CLICK_MAKE_SELECTION   0
#define CLICK_ADD_SELECTION    1
#define CLICK_RMV_SELECTION    2
#define CLICK_TOGGLE_SELECTION 4

extern void reset_players(void);
extern int get_local_player(void);

extern int get_resource (const int player_id, const int res);
extern int inline get_player_upkeep(const int player, const int resource);
extern int inline get_player_provision(const int player, const int resource);

extern void add_resource (const int player_id, const int res, const int amount);

extern void give_to_player(const int player_num, UNIT *unit);
extern UNIT *take_from_player(const int player_num, CHARDATA *udta);
extern UNIT *get_player_units(const int player_id);
extern UNIT *get_selected_units(const int player_id);
extern CHARDATA *get_captain(const int player_id);
extern int get_num_selected_units(const int player_id);
extern void remove_from_all_selections(CHARDATA *udta);
extern void remove_from_active_selections(CHARDATA *udta);

extern int get_group_num_units(const int player_id, const int groupnr);
extern void retrieve_unit_groupnr(const int player_id, const int groupnr);
extern void store_unit_groupnr(const int player_id, const int groupnr);
extern void shift_selection(const int player_id);
extern int group_is_active_group(const int player_id, const int groupnr);

extern void set_last_clicked_unit (const int player_id, CHARDATA *u);
extern CHARDATA *get_last_clicked_unit (const int player_id);
extern void set_last_touched_button (const int player_id, int u);
extern int get_last_touched_button (const int player_id);
extern void set_last_clicked_button (const int player_id, int u);
extern int get_last_clicked_button (const int player_id);
extern void register_click (const int player_id, const int flags);
extern void set_player_target(const int player_id, const int x, const int y, CHARDATA *u);
extern TARGET get_player_target(const int player_id);

extern void set_command_panel (void);
extern void give_group_targeted_command (const int player_id, const int command, const TARGET target, const int script_flags);
extern void push_group_script (const int player_id, char *script, int cmd_flags, int script_flags);

/* Debugging functions */
extern void dump_player_units(const int player_id);
#endif
