#ifndef SOUND_H
#define SOUND_H
/* Sound flags */
#define NONE         0
#define SOUND_DIGI   1
#define SOUND_MIDI   2
#define SOUND_CD     4
#define CD_MUSIC     8
#define MIDI_MUSIC   16
#define ANY_MUSIC    (CD_MUSIC+MIDI_MUSIC)

extern int set_sound(void);
extern void read_music_aliases (const char *filename);
extern void read_sample_aliases (const char *filename);

extern int read_sound_flags (void);

/* DIGI refers to the digital sound device */
/* MIDI refers to the midi sound device */
/* CD refers to the CD player */

/* SFX is for effects/speech and ususally also refers to DIGI */
/* MUSIC can refer to either the MIDI or the CD */
extern void select_music (const int type);
extern void set_digi_volume (const int vol);
extern void set_midi_volume (const int vol);
extern void set_cd_volume (const int vol);
extern void set_sfx_volume (const int vol);
extern void set_music_volume (const int vol);
inline extern int get_midi_volume (void);
inline extern int get_cd_volume (void);
inline extern int get_digi_volume (void);
inline extern int get_sfx_volume (void);
inline extern int get_music_volume (void);

extern void start_music (const int id, const int looped);
extern void start_sample(const int id, const int looped);
extern int cd_playing(void);
extern int midi_playing(void);
extern int music_playing(void);
extern void stop_music(void);
extern void stop_sound(void);

#endif
