#ifndef SKEYWORD_H
#define SKEYWORD_H

#include "script.h"

/* Script opcodes */
#define CMD_NOP      0xFF
#define CMD_ATOMIC   0xFE

#define CMD_ALERT    0xFD

#define CMD_RESET    0xFC
#define CMD_RETURN   0xFB

#define CMD_CREATE   0xEF
#define CMD_SPAWN    CMD_CREATE
#define CMD_REMOVE   0xEE
#define CMD_CHANGE   0xED
#define CMD_UNLOAD   0xEC

#define CMD_PUSHN    0xDA              /* Push a numerical constant */
#define CMD_POPN     0xDB              /* Discard a numerical constant */
#define CMD_LOAD     0xDC              /* Push a game state variable on the stack */
#define CMD_STORE    0xDD              /* Pop a game state variable off the stack */
#define CMD_XCHG     0xDE              /* Exchange two variables on the stack */

#define CMD_CLRZF    0xD0
#define CMD_SETZF    0xD1
#define CMD_CLRSF    0xD2
#define CMD_SETSF    0xD3
#define CMD_CLRFF    0xD4
#define CMD_SETFF    0xD5

#define CMD_JCF      0xC0              /* Jump on cancel flag     */
#define CMD_JBE      0xC1              /* Jump if below or equal  */
#define CMD_JAE      0xC2              /* Jump if above or equal  */
#define CMD_JB       0xC3              /* Jump if below           */
#define CMD_JA       0xC4              /* Jump if above           */
#define CMD_JNE      0xC5              /* Jump if not equal       */
#define CMD_JE       0xC6              /* Jump if equal           */
#define CMD_JMP      0xC7              /* Jump unconditionally    */

#define CMD_CMP      0xCA

#define CMD_AND      0xB0
#define CMD_OR       0xB1
#define CMD_XOR      0xB2
#define CMD_NOT      0xB3
#define CMD_TEST     0xB4

#define CMD_ITOF     0xBA
#define CMD_FTOI     0xBB

#define CMD_RND      0xBC

#define CMD_SIN      0xA0
#define CMD_COS      0xA1
#define CMD_TAN      0xA2
#define CMD_ASIN     0xA3
#define CMD_ACOS     0xA4
#define CMD_ATAN     0xA5
#define CMD_ATAN2    0xA6
#define CMD_EXP      0xA7
#define CMD_LOG      0xA8
#define CMD_ADD      0xA9
#define CMD_SUB      0xAA
#define CMD_MUL      0xAB
#define CMD_DIV      0xAC
#define CMD_INC      0xAD
#define CMD_DEC      0xAE
#define CMD_NEG      0xAF

#define CMD_REST     0x01
#define CMD_REPAINT  0x02


/* Rise of the Tribes specifics */
#define CMD_WAIT1    0x01
#define CMD_WAIT2    0x07
#define CMD_WAIT3    0x09
#define CMD_WAIT4    0x0C

#define CMD_ADVCOUNTER 0x10
#define CMD_CHKCOUNTER 0x11
#define CMD_SHOWCNTER  0x12
#define CMD_HIDECNTER  0x13

#define CMD_CHDIR    0x21
#define CMD_MOVE     0x22
#define CMD_SHOWF    0x23

#define CMD_CHKD     0x30
#define CMD_CLRC     0x31
#define CMD_SETC     0x32
#define CMD_SETD     0x33
#define CMD_CLRD     0x34
#define CMD_CHKC     0x35

#define CMD_CHKRES   0x40

#define CMD_TARGET   0x50

#define CMD_MAKEPATH  0x60
#define CMD_CHKTARGET 0x61
#define CMD_SETTARGET 0x62

#define CMD_PUSHTASK  0x68
#define CMD_POPTASK   0x69

/* Numerical identifiers for game state variables */
#define SCRA_ARG0       0x0000
#define SCRA_ARG1       0x0001
#define SCRA_ARG2       0x0002
#define SCRA_ARGC       0x0003

#define SCRA_SELF       0x0011
#define SCRA_PARENT     0x0012
#define SCRA_ATTCKER    0x0013
#define SCRA_AITARGT    0x0014
#define SCRA_PATH       0x0015

#define SCRA_TARGET     0x0020
#define SCRA_TARGET_X   0x0021
#define SCRA_TARGET_Y   0x0022
#define SCRA_LOCATION   0x0023
#define SCRA_LOCATION_X 0x0024
#define SCRA_LOCATION_Y 0x0025

#define SCRA_NORTH      0x0000
#define SCRA_NORTH_EAST 0x0001
#define SCRA_EAST       0x0002
#define SCRA_SOUTH_EAST 0x0003
#define SCRA_SOUTH      0x0004
#define SCRA_SOUTH_WEST 0x0005
#define SCRA_WEST       0x0006
#define SCRA_NORTH_WEST 0x0007
#define SCRA_LEFT       0x0030
#define SCRA_RIGHT      0x0031
#define SCRA_BACKWARD   0x0032
#define SCRA_RANDOM     0x0033

extern PARSE_OPCODE keyword[];
extern PARSE_OPCODE skeyword[];
extern PARSE_OPCODE fkeyword[];
extern PARSE_IDENTIFIER identifier[];

#endif
