#ifndef MONSTER_H
#define MONSTER_H

#include "bbox.h"

/* Monster types */
#define MONSTER_NONE         -1
#define MONSTER_SPAWN         1
#define MONSTER_ZOMBIE        2
#define MONSTER_ARMEDZOMBIE   3
#define MONSTER_SKELETON      4
#define MONSTER_GHOUL         5
#define MONSTER_GHOST         6
#define MONSTER_BAT           7
#define MONSTER_VAMPIREBAT    8
#define MONSTER_ASPAWN        9
#define MONSTER_DAEMON        10
#define MONSTER_WIZARD        11
#define MONSTER_GRIMREAPER    12

#define MONSTER_BOSS1         128
#define MONSTER_BOSS2         256

/* Monster abilities */
#define MONSTER_ABILITY_VAMPIRE        0x0001
#define MONSTER_ABILITY_SPAWN          0x0002
#define MONSTER_ABILITY_ETHEREAL       0x0004
#define MONSTER_ABILITY_SPELLS         0x0008
#define MONSTER_ABILITY_INVULNERABLE   0x0010
#define MONSTER_ABILITY_FLY            0x0020

/* Possible actions */
#define ACTION_NONE     0x0000
#define ACTION_WALK     0x0001
#define ACTION_TARGET   0x0002
#define ACTION_BOMB     0x0004
#define ACTION_DIE      0x0008
#define ACTION_DASH     0x0010
#define ACTION_ACTIVATE 0x0020
#define ACTION_SPELL    0x0040
#define ACTION_PARRY    0x0080

/* Serpent body parts */
#define SERPENT_HEAD       1
#define SERPENT_BODY       0
#define SERPENT_TAIL       2

typedef struct MONSTER {
   /* Animation variables */
   double x, y;
   double dx, dy;
   double velocity;
   double angle;
   unsigned int anim;
   unsigned int move_delay;

   int type;
   unsigned int ability;
   
   /* Combat variables - defence and attack scores */
   unsigned int atk;
   unsigned int def;

   unsigned int hitc;
   
   unsigned int base_ai;
   unsigned int ai_timer;
   unsigned int action;
   int health;
   
   int dropped_item;
   
   /* Used for bosses (that can consist of several distinct units) */
   int order;
   struct MONSTER *next;
   struct MONSTER *prev;
} MONSTER;

extern int init_monsters(void);
extern void free_monsters(void);

extern MONSTER *alloc_monster(void);
extern void free_monster(MONSTER *l);
extern int get_monster_count(void);

extern int get_monster_hp(int type);
extern int get_monster_attack(int type);
extern int get_monster_defence(int type);
extern int get_monster_ability(int type);

extern char *get_monster_name(int id);
extern int get_monster_id(char *name);

extern BSHAPE *get_monster_hit_bbox(int id);
extern BSHAPE *get_monster_move_bbox(int id);
#endif
