#ifndef INPUT_H
#define INPUT_H

/* Game-control keys identifiers */
/* These are logical input names, seperated from any specific input source */
#define GAMEKEY_NONE    0
#define GAMEKEY_UP      1
#define GAMEKEY_DOWN    2
#define GAMEKEY_LEFT    3
#define GAMEKEY_RIGHT   4
#define GAMEKEY_BUTTON1 5
#define GAMEKEY_BUTTON2 6
#define GAMEKEY_BUTTON3 7
#define GAMEKEY_BUTTON4 8
#define GAMEKEY_BUTTON5 9
#define GAMEKEY_BUTTON6 10
#define GAMEKEY_BUTTON7 11
#define GAMEKEY_BUTTON8 12

#define NUM_GAMEKEYS    13

/* Controller input devices */
#define CTRL_INPUT_NONE    0
#define CTRL_INPUT_KEYB    1
#define CTRL_INPUT_JOY1    2
#define CTRL_INPUT_JOY2    3
#define CTRL_INPUT_JOY3    4
#define CTRL_INPUT_JOY4    5
#define CTRL_INPUT_MOUSE   6

#define CTRL_INPUT_JOY     CTRL_INPUT_JOY1

extern void initialize_input(void);
extern void shutdown_input(void);

extern int set_controller_device(int ctrl_num, int device, int dev_id);
extern int get_controller_device(int ctrl_num, int device);
extern void set_controller_device_relax_time(int ctrl_num, int device, int relax);

extern void map_controller_axis(int ctrl_num, int device, int stick, int axis, int sign, int game_key);
extern void map_controller_button(int ctrl_num, int device, int button, int game_key);

extern int poll_controller(int ctrl_num);
extern int poll_controllers(void);

extern void push_gamekey_state(int ctrl_num);
extern void push_gamekey_states(void);

extern int gamekey_pressed(int ctrl_num);
extern int gamekey_released(int ctrl_num, int key);
extern int gamekey(int ctrl_num, int key);

extern void set_gamekey_buffer_size(int size);
extern void push_gamekey(int ctrl_num, int k);
extern int pop_gamekey(int ctrl_num);
extern int gamekey_in_buffer(int ctrl_num);
extern void flush_gamekey_buffer(int ctrl_num);

#endif
