#ifndef GAMESPRI_H
#define GAMESPRI_H

#define GFX_FLAG_RLE    1
#define GFX_FLAG_BMP    2

typedef struct {
   RLE_SPRITE *rle;
   BITMAP *bmp;
} SPRITE;

typedef struct {
   SPRITE *sprite;
   int x, y;
   int render_flags;
   int sort_flags;
   fixed angle;
} RENDER_SPRITE;

#define RENDER_NORMAL   0
#define RENDER_LIT      1
#define RENDER_TRANS    2
#define RENDER_ROTATE   4
#define RENDER_CENTRE   8

extern RENDER_SPRITE *alloc_render_sprite(void);
extern void free_render_sprite(RENDER_SPRITE *l);
extern int get_render_sprite_count(void);
extern int init_render_sprites(void);
extern void free_render_sprites(void);

extern int load_sprites(const char *filename);
extern void unload_sprites(void);
extern SPRITE *get_hero_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_zom_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_armzom_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_skel_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_ghoul_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_spawn_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_aspawn_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_bat_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_vambat_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_kingbat_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_ghost_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_daemon_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_wiz_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_reaper_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_shield_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_club_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_club2_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_dagger_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_dagger2_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_sword_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_sword2_sprite(const int dir, const int action, const int anim);
extern SPRITE *get_serpent_sprite(const int segment);

extern SPRITE *get_projectile_sprite(const int projectile);
extern SPRITE *get_arrow_sprite(const int anim);
extern SPRITE *get_death_sprite(const int anim);
extern SPRITE *get_bomb_sprite(const int anim);
extern SPRITE *get_explosion_sprite(const int anim);
extern SPRITE *get_fireball_sprite(const int anim);

extern int get_item_gfx_index(int type);
extern inline SPRITE *get_item_sprite(const int item);
extern SPRITE *get_heart_item_sprite(const int state);
extern SPRITE *get_heart_container_item_sprite(const int filled);
extern SPRITE *get_bow_item_sprite(const int state);
extern SPRITE *get_arrows_item_sprite(void);
extern SPRITE *get_swordpr_sprite(const int anim);
extern SPRITE *get_dagger1pr_sprite(const int anim);
extern SPRITE *get_mace_sprite(const int anim);
extern SPRITE *get_bomb_item_sprite(void);
extern SPRITE *get_key_item_sprite(void);

extern SPRITE *get_death_sprite(const int anim);
extern SPRITE *get_target_sprite(const int anim);

extern void game_draw_sprite(BITMAP *bmp, SPRITE *sprite, const int x, const int y);
extern void game_draw_lit_sprite(BITMAP *bmp, SPRITE *sprite, const int x, const int y, const int colour);
extern void game_draw_trans_sprite(BITMAP *bmp, SPRITE *sprite, const int x, const int y);
extern void game_centre_sprite(BITMAP *bmp, SPRITE *sprite, const int x, const int y);
extern void game_rotate_sprite(BITMAP *bmp, SPRITE *sprite, const int x, const int y, fixed angle);

extern void game_render_sprite(BITMAP *bmp, RENDER_SPRITE *sprite);
#endif
