#ifndef DAMAGE_H
#define DAMAGE_H

/* There are four damage types, each of which is calculated on (at most) */
/*  a 15d15, meaning it all fits perfectly in 4x2 nibbles = 1 int */

#define pack_dmg(mult,dice) ((mult)|((dice)<<4))

/* Store damage compactly */
#define st_dmg_pierce(dmg)  ((dmg))
#define st_dmg_cut(dmg)     ((dmg)<<8)
#define st_dmg_impact(dmg)  ((dmg)<<16)
#define st_dmg_elem(dmg)    ((dmg)<<24)

/* Get actual damage dealt from a packed word */
#define get_dmg_pierce(dmg) (((dmg)&0x000000FF))
#define get_dmg_cut(dmg)    (((dmg)&0x0000FF00)>>8)
#define get_dmg_impact(dmg) (((dmg)&0x00FF0000)>>16)
#define get_dmg_elem(dmg)   (((dmg)&0xFF000000)>>24)

extern unsigned int throw_attack_dice(int throw);
extern unsigned int calc_damage(int attack, int defence, int attack_mod, int defence_mod);
#endif
