#ifndef BBOX_H
#define BBOX_H

/* Bounding shape - either a circle (r>0) or a square (r=0) */
typedef struct {
   int dx, dy;
   int w, h;
   int r;
} BSHAPE;

extern BSHAPE monster_bb;
extern BSHAPE player_bb;
extern BSHAPE pickup_bb;
extern BSHAPE hit_bb;
extern BSHAPE move_bb;
extern BSHAPE item_bb;
extern BSHAPE tile_bb;
extern BSHAPE snake_bb;
extern BSHAPE bat_bb;
extern BSHAPE kingbat_bb;
extern BSHAPE arrow_bb;
extern BSHAPE melee_bb;
extern BSHAPE explosion_bb;

extern BSHAPE *alloc_bshape(void);
extern void free_bshape(BSHAPE *l);
extern int get_bshape_count(void);
extern int init_boxes(void);
extern void free_boxes(void);

extern int collide_box(int x1, int y1, BSHAPE *b1, int x2, int y2, BSHAPE *b2);
extern int collide_circle(int x1, int y1, BSHAPE *b1, int x2, int y2, BSHAPE *b2);

#endif
