/**********************************************/
/* Desert Falcon Clone                        */
/* Original (C) Atari 1987                    */
/* Evert Glebbeek 2002                        */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include <stdio.h>
#include "script.h"
#include "skeyword.h"

/* Parser helper data structures */
/* Opcodes: normal statements */
PARSE_OPCODE keyword[] = {
   { "nop",                CMD_NOP },
   { "atomic",             CMD_ATOMIC },

   { "alert",              CMD_ALERT },

   { "reset",              CMD_RESET },
   { "return",             CMD_RETURN },

   { "create",             CMD_CREATE },
   { "spawn",              CMD_SPAWN },
   { "build",              CMD_SPAWN },
   { "rmv",                CMD_REMOVE },
   { "chng",               CMD_CHANGE },
   { "unload",             CMD_UNLOAD },

   { "clrzf",              CMD_CLRZF },
   { "setzf",              CMD_SETZF },
   { "clrsf",              CMD_CLRSF },
   { "setsf",              CMD_SETSF },
   { "clrff",              CMD_CLRFF },
   { "setff",              CMD_SETFF },
   
   { "rest",               CMD_REST },
   { "repaint",            CMD_REPAINT },

   { "wait1",              CMD_WAIT1 },
   { "wait2",              CMD_WAIT2 },
   { "wait3",              CMD_WAIT3 },
   { "wait4",              CMD_WAIT4 },
   
   { "advcounter",         CMD_ADVCOUNTER },
   { "chkcounter",         CMD_CHKCOUNTER },
   { "showcounter",        CMD_SHOWCNTER },
   { "hidecounter",        CMD_HIDECNTER },

   { "chdir",              CMD_CHDIR },
   { "move",               CMD_MOVE },
   { "showf",              CMD_SHOWF },
   
   { "move_task_target",   CMD_MAKEPATH },
   { "chk_task_target",    CMD_CHKTARGET },
   { "settarget",          CMD_SETTARGET },

   { "pushtask",           CMD_PUSHTASK },
   { "poptask",            CMD_POPTASK },

   { "chkres",             CMD_CHKRES },
   
   { "chkc",               CMD_CHKC },
   { "chkd",               CMD_CHKD },
   { "clrc",               CMD_CLRC },
   { "clrd",               CMD_CLRD },
   { "setc",               CMD_SETC },
   { "setd",               CMD_SETD },
   
   { "cmp",                CMD_CMP },

   { "and",                CMD_AND },
   { "or",                 CMD_OR },
   { "xor",                CMD_XOR },
   { "not",                CMD_NOT },
   { "test",               CMD_TEST },

   { "itof",               CMD_ITOF },
   { "ftoi",               CMD_FTOI },

   { "rnd",                CMD_RND },
   
   { "sin",                CMD_SIN },
   { "cos",                CMD_COS },
   { "tan",                CMD_TAN },
   { "asin",               CMD_ASIN },
   { "acos",               CMD_ACOS },
   { "atan",               CMD_ATAN },
   { "atan2",              CMD_ATAN2 },
   { "exp",                CMD_EXP },
   { "log",                CMD_LOG },
   { "add",                CMD_ADD },
   { "sub",                CMD_SUB },
   { "mul",                CMD_MUL },
   { "div",                CMD_DIV },
   { "inc",                CMD_INC },
   { "dec",                CMD_DEC },
   { "neg",                CMD_NEG },

   { NULL,                 0 }
};

/* Opcodes: stack controlling opcodes */
PARSE_OPCODE skeyword[] = {
   { "pushn",        CMD_PUSHN },
   { "popn",         CMD_POPN },
   { "store",        CMD_STORE },
   { "load",         CMD_LOAD },
   { "xchg",         CMD_XCHG },
   { NULL,           0 }
};

/* Opcodes: flow control */
PARSE_OPCODE fkeyword[] = {
   { "jcf",          CMD_JCF },
   { "jbe",          CMD_JBE },
   { "jna",          CMD_JBE },
   { "jae",          CMD_JAE },
   { "jnb",          CMD_JAE },
   { "jb",           CMD_JB },
   { "jnae",         CMD_JB },
   { "ja",           CMD_JA },
   { "jnbe",         CMD_JA },
   { "jne",          CMD_JNE },
   { "jnz",          CMD_JNE },
   { "je",           CMD_JE },
   { "jz",           CMD_JE },
   { "jmp",          CMD_JMP },
   { "goto",         CMD_JMP },
   { NULL,           0 }
};

/* Known parser identifiers and their numerical translation handles by push */
PARSE_IDENTIFIER identifier[] = {
   /* fixed point translation of pi: we need to tell the script compiler   */
   /*  that `pi' is a number, because otherwise it will generate incorrect */
   /*  push/pop commands */
   { "pi",           0x0003243f, TRUE },

   { "north",        SCRA_NORTH, TRUE },
   { "northeast",    SCRA_NORTH_EAST, TRUE },
   { "northwest",    SCRA_NORTH_WEST, TRUE },
   { "south",        SCRA_SOUTH, TRUE },
   { "southeast",    SCRA_SOUTH_EAST, TRUE },
   { "southwest",    SCRA_SOUTH_WEST, TRUE },
   { "east",         SCRA_EAST, TRUE },
   { "west",         SCRA_WEST, TRUE },

   { "left",         SCRA_LEFT, TRUE },
   { "right",        SCRA_RIGHT, TRUE },
   { "backward",     SCRA_BACKWARD, TRUE },
   { "random",       SCRA_RANDOM, TRUE },

   { "arg0",         SCRA_ARG0, FALSE },
   { "arg1",         SCRA_ARG1, FALSE },
   { "arg2",         SCRA_ARG2, FALSE },
   { "argc",         SCRA_ARGC, FALSE },

   { "target->self", SCRA_SELF, FALSE },
   { "target->parent",SCRA_PARENT, FALSE },
   { "target->attacker",SCRA_ATTCKER, FALSE },
   { "target->aitarget",SCRA_AITARGT, FALSE },
   { "target->path", SCRA_PATH, FALSE },
   { "target->location",SCRA_LOCATION, TRUE },
   { "target->location->x",SCRA_LOCATION_X, FALSE },
   { "target->location->y",SCRA_LOCATION_Y, FALSE },
   { "target->target",SCRA_TARGET, TRUE },
   { "target->target->x",SCRA_TARGET_X, FALSE },
   { "target->target->y",SCRA_TARGET_Y, FALSE },
   { NULL,           0, 0 }
};
