/**********************************************/
/* Evert Glebbeek 2003, 2005                  */
/* eglebbk@dds.nl                             */
/**********************************************/
#include <allegro.h>
#include <stdlib.h>
#include <string.h>
#include "monster.h"
#include "player.h"
#include "damage.h"
#include "global.h"
#include "bbox.h"

#define MAX_MONSTERS (2*1024)

typedef struct MONSTER_NAME {
   int id;
   char *name;
} MONSTER_NAME;

/* Elemental, impact, cut, pierce */

/* Monster defence */
static int monster_defence[] = {
   0,
   0x0000A0A0,    /* Spawner: reduced damage from cutting or piercing attacks */
   0x00C00000,    /* Zombie: reduced impact damage */
   0x00C00000,    /* Armed Zombie: reduced impact damage */
   0x0000A0C0,    /* Skeleton: reduced damage from slashing or piercing attacks */
   0x00C0C0C0,    /* Ghoul: Reduced damage from all physical attacks */
   0x00FFB0B0,    /* Ghost: little damage from physical attacks          */
   0xFFFF9090,    /* Bat: tough to hit, no damage from elemental attacks */
   0x00FFD090,    /* Vampire Bat: vulnerable to piercing and elemental attacks, but tough to hit */
   0x0000A0A0,    /* Spawner: reduced damage from cutting or piercing attacks */
   0xA0C000A0,    /* Daemon: reduced damage from impact, piercing and elemental attacks */
   0xA0000000,    /* Wizard: reduced damage from elemental attacks */
   0xC0F0F0E0,    /* Grim Reaper: Reduced damage overall */
};

/* Monster attacks (unarmed!) */
static int monster_attack[] = {
   0,
   0x00000000,    /* Spawner: no attack damage */
   0x00820000,    /* Zombie: 2d8 impact damage */
   0x00640000,    /* Armed Zombie: 4d6 impact damage */
   0x00440000,    /* Skeleton: 4d4 impact damage */
   0x00460024,    /* Ghoul: 6d4 impact damage+4d2 piercing damage */
   0x00000042,    /* Ghost: 2d4 on piercing attacks */
   0x00212121,    /* Bat: 1d2 on all physical attacks (nasty teeth/claws!) */
   0x00212131,    /* Vampire Bat: 1d2 impact+slash, 1d3 piercing damage */
   0x00000021,    /* Attack Spawner: moderate attack damage */
   0x00442400,    /* Daemon: 4d4 impact damage and 2d4 cutting damage */
   0x00000000,    /* Wizard: no contact damage */
   0x00660044     /* Grim Reaper: 4d4 cutting and 6d6 impact damage */
};

/* Monster hitpoints */
static int monster_hp[] = {
   0,
   40,   /* Spawner           */
   20,   /* Zombie            */
   20,   /* Armed Zombie      */
   40,   /* Skeleton          */
   60,   /* Ghoul             */
   10,   /* Ghost             */
    5,   /* Bat               */
   10,   /* Vampire Bat       */
   40,   /* Attack Spawner    */
   60,   /* Daemon            */
   80,   /* Wizard            */
  100    /* Grim Reaper       */
};

/* Monster special abilities */
static int monster_ability[] = {
   0,
   MONSTER_ABILITY_SPAWN,           /* Spawner           */
   0,                               /* Zombie            */
   0,                               /* Armed Zombie      */
   0,                               /* Skeleton          */
   0,                               /* Ghoul             */
   MONSTER_ABILITY_ETHEREAL,        /* Ghost             */
   MONSTER_ABILITY_FLY,             /* Bat               */
   MONSTER_ABILITY_FLY|             /* Vampire Bat       */
      MONSTER_ABILITY_VAMPIRE,
   MONSTER_ABILITY_SPAWN,           /* Attack Spawner    */
   0,                               /* Daemon            */
   MONSTER_ABILITY_SPELLS,          /* Wizard            */
   MONSTER_ABILITY_ETHEREAL|        /* Grim Reaper       */
      MONSTER_ABILITY_VAMPIRE
};

static MONSTER_NAME monster_name[] = {
   { MONSTER_SPAWN,        "Spawner" },
   { MONSTER_ZOMBIE,       "Zombie" },
   { MONSTER_ARMEDZOMBIE,  "Armed Zombie" },
   { MONSTER_SKELETON,     "Skeleton" },
   { MONSTER_GHOUL,        "Ghoul" },
   { MONSTER_GHOST,        "Ghost" },
   { MONSTER_BAT,          "Bat" },
   { MONSTER_VAMPIREBAT,   "Vampire Bat" },
   { MONSTER_ASPAWN,       "Elite Spawner" },
   { MONSTER_DAEMON,       "Daemon" },
   { MONSTER_WIZARD,       "Wizard" },
   { MONSTER_GRIMREAPER,   "Grim Reaper" },
   { 0, NULL }
};

static MONSTER *monster_chunk = NULL;
static MONSTER **monster_stack = NULL;
static int monster_stack_counter = 0;

/* Monster hitpoints (increase with 50% on Hell) */
int get_monster_hp(int type)
{
   return monster_hp[type] + (settings.difficulty>1)*monster_hp[type]*settings.difficulty/4;
}

int get_monster_attack(int type)
{
   return monster_attack[type];
}

int get_monster_defence(int type)
{
   return monster_defence[type];
}

int get_monster_ability(int type)
{
   return monster_ability[type];
}

/* Monster memory pool management */
int init_monsters(void)
{
   int c;

   monster_chunk = realloc(monster_chunk, (sizeof *monster_chunk)*MAX_MONSTERS);
   monster_stack = realloc(monster_stack, (sizeof *monster_stack)*MAX_MONSTERS);
   
   monster_stack_counter = 0;
   for (c=0; c<MAX_MONSTERS; c++)
      monster_stack[c] = &(monster_chunk[c]);
      
   return (sizeof(MONSTER)+sizeof(MONSTER *))*MAX_MONSTERS;
}

void free_monsters(void)
{
   free(monster_chunk);
   free(monster_stack);
   
   monster_chunk = NULL;
   monster_stack = NULL;
   monster_stack_counter = 0;
}


MONSTER *alloc_monster(void)
{
   ASSERT(monster_stack_counter<MAX_MONSTERS);
   ASSERT(monster_stack);
   
   memset(monster_stack[monster_stack_counter], 0, sizeof *monster_stack);

   /* return the address of the last free monster in the list */
   return monster_stack[monster_stack_counter++];
}

void free_monster(MONSTER *l)
{
   ASSERT(monster_stack_counter);
   ASSERT(monster_stack);
   
   monster_stack[--monster_stack_counter]=l;
}

int get_monster_count(void)
{
   return monster_stack_counter;
}

/* Get the name (string) of the monster associated with the id */
char *get_monster_name(int id)
{
   int c;
   for(c=0; monster_name[c].name; c++) {
      if (monster_name[c].id == id)
         return monster_name[c].name;
   }
   return NULL;
}

/* Get the id of the monster associated with the string name */
int get_monster_id(char *name)
{
   int c;
   for(c=0; monster_name[c].name; c++) {
      if (ustricmp(monster_name[c].name, name) == 0)
         return monster_name[c].id;
   }
   return -1;
}

BSHAPE *get_monster_hit_bbox(int id)
{
   if (id == MONSTER_BOSS1)
      return &snake_bb;

   if (id == MONSTER_BAT || id == MONSTER_VAMPIREBAT)
      return &bat_bb;
      
   if (id == MONSTER_BOSS2)
      return &kingbat_bb;
      
   return &hit_bb;
}

BSHAPE *get_monster_move_bbox(int id)
{
   if (id == MONSTER_BOSS1)
      return &snake_bb;

   if (id == MONSTER_BAT || id == MONSTER_VAMPIREBAT)
      return &bat_bb;
      
   if (id == MONSTER_BOSS2)
      return &kingbat_bb;
      
   return &move_bb;
}
