/**********************************************/
/* Morphero RPG                               */
/* Evert Glebbeek 2003                        */
/* eglebbk@dds.nl                             */
/**********************************************/
#include <allegro.h>
#include <string.h>
#include "maptile.h"
#include "global.h"
#include "gfx.h"

typedef struct TILE {
   //int gfx_index;
   BITMAP *bmp;
   char *name;
   int mm_col;
} TILE;

static DATAFILE *tiles_dat = NULL;
static TILE *tiledata = NULL;
static int numtiles = 0;

void unload_tileset(void)
{
   int c;
   
   if (numtiles) {
      for(c=0; c<numtiles; c++) {
         destroy_bitmap(tiledata[c].bmp);
         free(tiledata[c].name);
      }
   }
   free(tiledata);
   tiledata = NULL;
   numtiles = 0;
}

/* Returns 0 on succes, -1 on failure */
int load_tileset(char *filename)
{
   int c;
   
   unload_tileset();
   
   if (tiles_dat) {
      unload_datafile(tiles_dat);
      tiles_dat = NULL;
   }


   tiles_dat = load_datafile(get_game_path(filename));
   if (!tiles_dat) {
      return -1;
   }

   for(numtiles = 0; tiles_dat[numtiles].type == DAT_BITMAP; numtiles++);

   tiledata = malloc(numtiles * sizeof *tiledata);

   for (c=0; c<numtiles; c++) {
      tiledata[c].bmp = create_optimized_mask_bitmap(TILE_WIDTH, TILE_HEIGHT);
      blit(tiles_dat[c].dat, tiledata[c].bmp, 0,0,0,0,TILE_WIDTH, TILE_HEIGHT);
      tiledata[c].name = strdup(get_datafile_property(tiles_dat+c, DAT_ID('N','A','M','E')));
      tiledata[c].mm_col = makecol(16, 97, 4);
   }
   
   return 0;
}


/* Access routine to map tiles. Implemented in this way to hide from other */
/*  parts of the program ('data-hiding') */
BITMAP *get_tile_bitmap(int index)
{
   ASSERT(index>=0);
   ASSERT(index<numtiles);
   return tiledata[index].bmp;
}

/* Return the colour a tile should have on the mini-map */
int get_tile_colour(int index)
{
   ASSERT(index>=0);
   ASSERT(index<numtiles);
   return tiledata[index].mm_col;
}

/* Find the index of a tile by name, or -1 if not found */
int find_named_tile(const char *name)
{
   int c;
   
   for (c=0; c<numtiles; c++) {
      if (strcmp(tiledata[c].name, name)==0) {
         return c;
      }
   }
   return -1;
}
