#include <stdio.h>
#include "genrand.h"
#include "damage.h"

/* Damage multiplier; tweak to change rounding rules */
#define MULTIPLIER   1

/* Do a damage roll for all types with the values stored in the throw */
unsigned int throw_attack_dice(int throw)
{
   unsigned int dmg;
   int packed;
   int mult;
   int dice;
   int c;
   int d;
   
   dmg = 0;
   
   /* Split each part in components */
   packed = get_dmg_pierce(throw);
   mult = packed&0x0F;
   dice = packed>>4;
   d = 0;
   for (c=0; c<mult; c++) {
      d+=(genrandf()*dice)+1;
   }
   dmg |= st_dmg_pierce(d);
   //printf ("%dd%d: %d\t", mult, dice, d);


   packed = get_dmg_cut(throw);
   mult = packed&0x0F;
   dice = packed>>4;
   d = 0;
   for (c=0; c<mult; c++) {
      d+=(genrandf()*dice)+1;
   }
   dmg |= st_dmg_cut(d);
   //printf ("%dd%d: %d\t", mult, dice, d);


   packed = get_dmg_impact(throw);
   mult = packed&0x0F;
   dice = packed>>4;
   d = 0;
   for (c=0; c<mult; c++) {
      d+=(genrandf()*dice)+1;
   }
   dmg |= st_dmg_impact(d);
   //printf ("%dd%d: %d\t", mult, dice, d);


   packed = get_dmg_elem(throw);
   mult = packed&0x0F;
   dice = packed>>4;
   d = 0;
   for (c=0; c<mult; c++) {
      d+=(genrandf()*dice)+1;
   }
   dmg |= st_dmg_elem(d);
   //printf ("%dd%d: %d\n", mult, dice, d);
   
   return dmg;
}

/* Calculate actual HP loss from attack */
unsigned int calc_damage(int attack, int defence, int attack_mod, int defence_mod)
{
   int dmg=0;
   int a;
   int d;

   /* Damage taken is reduced by a factor of def/255 for all damage types */
   /*   def=255 means the create does not take damage from such attacks! */
   
   a = get_dmg_pierce(attack) + attack_mod;
   d = get_dmg_pierce(defence) + 20*defence_mod;
   /* Attack roll: creature takes damage if it throws>than its to-hit number */
   if (genrandf()*256 + attack_mod > d)
      dmg += a*MULTIPLIER;
   //dmg += a*MULTIPLIER*(256-d)/256;
   //printf ("atk:%d def:%d -> %d damage\n", a, d, a*MULTIPLIER*(256-d)/256);

   a = get_dmg_cut(attack) + attack_mod;
   d = get_dmg_cut(defence) + 20*defence_mod;
   if (genrandf()*256 + attack_mod > d)
      dmg += a*MULTIPLIER;
   //dmg += a*MULTIPLIER*(256-d)/256;
   //printf ("atk:%d def:%d -> %d damage\n", a, d, a*MULTIPLIER*(256-d)/256);

   a = get_dmg_impact(attack) + attack_mod;
   d = get_dmg_impact(defence) + 20*defence_mod;
   if (genrandf()*256 + attack_mod > d)
      dmg += a*MULTIPLIER;
   //dmg += a*MULTIPLIER*(256-d)/256;
   //printf ("atk:%d def:%d -> %d damage\n", a, d, a*MULTIPLIER*(256-d)/256);

   a = get_dmg_elem(attack) + attack_mod;
   d = get_dmg_elem(defence) + 20*defence_mod;
   if (genrandf()*256 + attack_mod> d)
      dmg += a*MULTIPLIER;
   //dmg += a*MULTIPLIER*(256-d)/256;
   //printf ("atk:%d def:%d -> %d damage\n", a, d, a*MULTIPLIER*(256-d)/256);
   //printf ("Total: %d damage\n\n", dmg);
   
   return dmg/MULTIPLIER;
}
