#include <stdlib.h>
#include <math.h>
#include "assert.h"
#include "global.h"
#include "bbox.h"

BSHAPE monster_bb =  { 0,  0, 32, 32, 16 };  // Bounding box for monster sprite
BSHAPE player_bb =   { 0,  0, 32, 32, 16 };  // Bounding box for player sprite
BSHAPE pickup_bb =   {12, 16,  8, 16, 16 };  // Bounding box for item pickup
BSHAPE hit_bb =      { 8,  0, 16, 32, 16 };  // Bounding box for body hits
BSHAPE move_bb =     {12, 16,  8, 16, 16 };  // Bounding box for wall collisions
BSHAPE item_bb =     { 0,  0, 16, 16,  8 };  // Bounding box for (small) items
BSHAPE tile_bb =     { 0,  0, 32, 32, 16 };  // Bounding box for tiles
BSHAPE snake_bb =    { 0,  0, 16, 16,  8 };  // Bounding box for Serpentile
BSHAPE bat_bb =      { 8,  0, 16, 16, 16 };  // Bounding box for bats
BSHAPE kingbat_bb =  {10, 16, 64, 44, 16 };  // Bounding box for King Bat
BSHAPE arrow_bb =    { 1,  1, 14, 14,  8 };  // Bounding box for arrows
BSHAPE melee_bb =    {-4, -4, 24, 24, 24 };  // Bounding box for melee weapons
BSHAPE explosion_bb ={15, 15, 72, 72, 50 };  // Bounding box for explosion

#define MAX_BSHAPES     4096
static BSHAPE *bbox_chunk = NULL;
static BSHAPE **bbox_stack = NULL;
static int bbox_stack_counter = 0;

BSHAPE *alloc_bshape(void)
{
   assert(bbox_stack_counter<MAX_BSHAPES);
   assert(bbox_stack);
   
   /* return the address of the last free BSHAPE in the list */
   return bbox_stack[bbox_stack_counter++];
}

void free_bshape(BSHAPE *l)
{
   assert(bbox_stack_counter);
   assert(bbox_stack);
   
   bbox_stack[--bbox_stack_counter]=l;
}

int get_bshape_count(void)
{
   return bbox_stack_counter;
}

int init_boxes(void)
{
   int c;

   bbox_chunk = realloc(bbox_chunk, sizeof *bbox_chunk * MAX_BSHAPES);
   bbox_stack = realloc(bbox_stack, sizeof *bbox_stack * MAX_BSHAPES);
   
   bbox_stack_counter = 0;
   for (c=0; c<MAX_BSHAPES; c++)
      bbox_stack[c] = &(bbox_chunk[c]);
      
   return (sizeof(BSHAPE)+sizeof(BSHAPE *))*MAX_BSHAPES;
}

void free_boxes(void)
{
   free(bbox_chunk);
   free(bbox_stack);
   
   bbox_chunk = NULL;
   bbox_stack = NULL;
   bbox_stack_counter = 0;
}

int collide_box(int x1, int y1, BSHAPE *b1, int x2, int y2, BSHAPE *b2)
{
   return rect_overlap(x1+b1->dx, y1+b1->dy, b1->w-1, b1->h-1, 
                       x2+b2->dx, y2+b2->dy, b2->w-1, b2->h-1);
}

int collide_circle(int x1, int y1, BSHAPE *b1, int x2, int y2, BSHAPE *b2)
{
   return hypot(x1+b1->dx - x2+b2->dx, y1+b1->dy - y2+b2->dy) < b1->r+b2->r;
}
