#ifndef VM_H
#define VM_H

#include "script.h"

typedef int (*CPOPCODE)(void *obj, SCRIPT *script, int *loop);

extern CPOPCODE opcode_implementation[256];

extern void vm_init(void);
extern void vm_shutdown(void);

extern void register_opcode(CPOPCODE func, const int opcode);

extern int running_script(void *obj);

extern SCRIPT *run_script(void *obj, SCRIPT *script);
extern void update_active_scripts(void);

#endif
