#ifndef PLAYER_H
#define PLAYER_H

#include "monster.h"

typedef struct HERO {
   /* Animation variables */
   int x, y;
   int dx, dy;
   double velocity;
   double angle;
   unsigned int direction;
   unsigned int anim;
   
   /* Gameplay specific variables - reset on continuation */
   unsigned int score;
   int health;

   unsigned int action;

   /* Selected weapon */
   unsigned int weapon;
   unsigned int select_timeout;
   unsigned int weapon_cooldown;
   unsigned int max_cooldown;
   unsigned int weapon_buildup;
   
   unsigned int def;          /* Defence - calculated from inventory */
   unsigned int invc;         /* Counter - player is briefly invulnerable */

   MONSTER *target;
   unsigned int target_x;
   unsigned int target_y;
   
   int current_room;

   int next_level;
   
   /* Saved data */
   unsigned int level;        /* Maximum: 31...?     5      */
   int max_health;            /* Maximum: 20 +QH     5 +2   */

   unsigned int inventory;    /* Bitflags            32     */
   unsigned int keys;         /* Maximum: 127...?    7      */
   unsigned int bombs;        /* Maximum: 127...?    7      */
   unsigned int arrows;       /* Maximum: 127...?    7      */
                              /* Total:              65 bits*/
} HERO;

#endif
