#ifndef MAP_H
#define MAP_H

#include "linked.h"
#include "bbox.h"

/* Map dimensions, in tiles */
#define MAP_WIDTH    25
#define MAP_HEIGHT   61

#define MAP_FLOOR    0
#define MAP_WALL     1
#define MAP_CEILING  2
#define MAP_DOOR     4

/* Door states */
#define MAP_DOOR_OPEN      0
#define MAP_DOOR_LOCKED    1
#define MAP_DOOR_BLOCKED   2
#define MAP_DOOR_SWITCH    3     /* Open when switch is pressed down */
#define MAP_DOOR_NONE      4
#define MAP_DOOR_SWITCH2   5     /* Close when switch is pressed down */
#define MAP_DOOR_CREATUREL 8     /* Left wall, open when no creatures in room */
#define MAP_DOOR_CREATURER 16    /* Right wall, open when no creatures in room */
#define MAP_DOOR_CREATURE  24    /* Open when no creatures in room */

#define TILE_INDEX(x,y) ((x)+(y)*MAP_WIDTH)

extern void map_init(void);
extern void unload_map(void);

extern void load_level(int num);
extern void get_connected_mask(BITMAP *bmp, const int room);
extern void get_connected_map(BITMAP *bmp, const int room, int x, int y);

extern int get_start_x(void);
extern int get_start_y(void);
extern int get_start_room(void);
extern int *get_tilemap(int roomnumber);
extern int get_num_rooms(void) ;

extern int tile_is_door(const int room, const int x, const int y);
extern int tile_passable(const int room, const int x, const int y);
extern int tile_is_locked_door(const int room, const int x, const int y);

extern int *get_left_doors(int roomnumber);
extern int *get_right_doors(int roomnumber);

extern LINK *get_monster_list(const int room);
extern void set_monster_list(const int room, LINK *list);
extern LINK *get_item_list(const int room);
extern void set_item_list(const int room, LINK *list);
extern LINK *get_projectile_list(const int room);
extern void set_projectile_list(const int room, LINK *list);
extern LINK *get_particle_list(const int room);
extern void set_particle_list(const int room, LINK *list);

extern void calculate_geometry_bbox(const int room);
extern LINK *get_geometry_boundingbox(int room);
extern int collide_geometry(int room, int x, int y, BSHAPE *bbox);

extern int get_switch_state(void);
extern void toggle_switch_state(void);
#endif
