#ifndef ITEMS_H
#define ITEMS_H

#include "bbox.h"

#define ITEM_NONE       -1
/* Items that can fit in bit-wise inventory are stored as powers of 2 */
#define ITEM_BOW            1
#define ITEM_CROSSBOW       2
#define ITEM_CLUB           4
#define ITEM_MACE           8
#define ITEM_DAGGER        16
#define ITEM_DAGGER2       32
#define ITEM_SWORD         64
#define ITEM_SWORD2       128
#define ITEM_SHIELD       256
#define ITEM_RINGREGEN    512
#define ITEM_TELLRING    1024
#define ITEM_OWLFIG      2048
#define ITEM_CATFIG      4096
#define ITEM_SNAKEFIG    8192
#define ITEM_CHAINMAIL  16384
#define ITEM_HELMET     32768
#define ITEM_SARROW     65536

/* Normal items that can be picked up */
#define ITEM_ARROW       3
#define ITEM_FARROW      6
#define ITEM_BOMB        7
#define ITEM_QHEART      9
#define ITEM_HEARTC      10
#define ITEM_KEY         11
#define ITEM_POTION      12
#define ITEM_HEART       13
#define ITEM_EXIT        14
#define ITEM_CANDLEHOLD  15
#define ITEM_CHALICE     17
#define ITEM_GEM         18
#define ITEM_POISON      19
#define ITEM_TRAP        20
#define ITEM_SWITCHUP    21
#define ITEM_SWITCHDN    22
#define ITEM_SWITCHWGHTU 23      /* A switch that is only down while it is touched */
#define ITEM_SWITCHWGHTD 24      /* A switch that is only down while it is touched */
#define ITEM_BOSSGATE    25
#define ITEM_BOSSEXIT    26
#define ITEM_PORTAL      27
#define ITEM_CHESTOPEN   28
#define ITEM_CHESTCLOSED 29
#define ITEM_BLOCK       30
#define ITEM_BLOCKCRACK  31
#define ITEM_BLOCKLOCKED 33

/* Door and teleporter-like objects */
#define ITEM_TELEPORTER  34
#define ITEM_LOCKEDTELEP 35
#define ITEM_BOSSGATETOP 36

#define ITEM_STATUE      37

typedef struct ITEM {
   int x, y;
   unsigned int sound;
   unsigned int type;
   unsigned int anim;
   unsigned int lifetime;

   unsigned int flags;

   /* Teleporter-type variables */
   int tx, ty, troom;

   struct ITEM *child;
} ITEM;

/* Projectil types */
#define PROJECTILE_ARROW      1
#define PROJECTILE_CROSSARROW 2
#define PROJECTILE_BOMB       3
#define PROJECTILE_DEATH      4
#define PROJECTILE_EXPLOSION  5
#define PROJECTILE_SWORD      6
#define PROJECTILE_DAGGER     7
#define PROJECTILE_CLUB       8
#define PROJECTILE_BOSS_DEATH 9
#define PROJECTILE_BOSS_EXPLO 10
#define PROJECTILE_E_FIREBALL 11
#define PROJECTILE_ITEM       12

/* Weapon cooldown */
#define SWORD_COOLDOWN         6
#define MACE_COOLDOWN         20
#define DAGGER_COOLDOWN        2
#define BOW_COOLDOWN           2

typedef struct PROJECTILE {
   int x, y;
   unsigned int type;
   unsigned int sub_type;
   unsigned int anim;
   unsigned int damage;
   double angle;
   int speed;
} PROJECTILE;

/* 
   Projectile damage
    - Amount
      The standard bow does (say) 2d8 damage (9 avg)     1d4 (2.5)
      First upgrade makes it      4d4 (10 avg)           2d2 (3)
      Second upgrade makes it     8d2 (12 avg)           4d2 (6)
    - Types of damage
      Piercing damage            zombies
      Impact damage              skeletons
      Cutting/slashing damage    skeletons(less), zombies(less), wraiths(less)
      Elemental damage           all(a lot)
*/

extern ITEM *alloc_item(void);
extern void free_item(ITEM *l);
extern int get_item_count(void);

extern PROJECTILE *alloc_projectile(void);
extern void free_projectile(PROJECTILE *l);
extern int get_projectile_count(void);

extern int init_objects(void);
extern void free_objects(void);

extern char *get_item_name(int id);
extern char *get_item_desc(int id);
extern int get_item_id(char *name);
extern int get_item_sound(int id);

extern int item_blocks(int id);
extern int get_item_lifetime(int id);

extern BSHAPE *get_item_bbox(int id);

#endif
