#ifndef FLOATWIN_H
#define FLOATWIN_H
/* Floating window flags */
#define FWIN_STICKMAP  1     /* When set, the (x,y) are taken to be map coordinates */
#define FWIN_FADETPDN  2     /* Fade from top to bottom (gouraud) */
#define FWIN_TRANS     4     /* Transparent floatwin */
#define FWIN_HIDDEN    8     /* Hidden floatwin, not drawn */
#define FWIN_DIRTY    16     /* Floatwin must be redrawn */
#define FWIN_CUSTOM0  32     /* Flag fields that are undefined and free to use */

/* Floating windows */
typedef struct FLOATWIN {
   int x, y;
   int w, h;
   int flags;
   int timeleft;
   BITMAP *bg;
   BITMAP *content;
   BITMAP *bbuffer;
} FLOATWIN;

/* Floating windows draw list */
typedef struct FLOATWIN_LIST {
   FLOATWIN *win;
   struct FLOATWIN_LIST *next;
   struct FLOATWIN_LIST *prev;
} FLOATWIN_LIST;

extern FLOATWIN_LIST *flwin;

extern void set_flwin_border (BITMAP **blst);
extern BITMAP *text_boxed (int maxw, int bgcolor, int textcolor, const FONT *textfont, int center, char *msg, ...);

extern void push_floatwin (FLOATWIN *flw);
extern void kill_floatwin(FLOATWIN *flw);
extern void destroy_floatwin (FLOATWIN *flw);
extern void destroy_all_floatwins (void);

extern FLOATWIN *make_floatwin (int x, int y, int w, int h, int flags, int lifetime, BITMAP *bg, BITMAP *content);
extern FLOATWIN *make_floatmsg (int bgcolor, int textcolor, const FONT *textfont, int center, int lifetime, char *msg,...);
extern FLOATWIN *make_floatmsg_fit (int bgcolor, int textcolor, const FONT *textfont, int center, int lifetime, char *msg,...);
extern FLOATWIN *make_floattext (int x, int y, int bgcolor, int fgcolor, int flags, int lifetime, const FONT *textfont, char *msg,...);
extern FLOATWIN *find_floatwin(int flag);

extern void set_lifetime(FLOATWIN *flw, int lifetime);
extern int get_lifetime(FLOATWIN *flw);

extern void draw_floatwin(FLOATWIN *flw);
extern void draw_floatwins(void);
extern void undraw_floatwin(FLOATWIN *flw);
extern void undraw_floatwins(void);
#endif
