#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "password.h"
#include "player.h"

/* 6bits/character */
static char *passwordchars = "BCDFGHJKLMNPQRSTVWXZ*123456789+-"
                             "bcdfghjklmnpqrstvwxzAEUIOYaeuioy" ;

char *generate_password(const HERO *hero)
{
   char *s;
   unsigned int w[3];
   unsigned int crc;
   unsigned int c[21];
   int n;   
   /* Word 1: level, health,    CRC - 5+7=12 bits + 20 */
   /* Word 2: keys,bombs,arrows CRC - 3*7=21 bits      */
   /* Word 3: inventory             -     32 bits      */
   
   w[0] = hero->level | (hero->max_health/8)<<5 | ((hero->max_health%8)/2)<<10;
   w[1] = hero->keys | (127-hero->bombs)<<7| (hero->arrows^hero->bombs)<<14;
   w[2] = hero->inventory;
   //printf("Decoded: w[0]=%x\tw[1]=%x\tw[2]=%x\n", w[0], w[1], w[2]);
   /* Shift lower 8 bits of inventory to w[1] */
   w[1] = (w[1]<<8)^w[2];
   w[2] = (w[2]>>8)^w[0];
   
   crc = ((w[0]^w[1])^w[2]) & ((1<<20)-1);

   //printf("Encoded: w[0]=%x\tw[1]=%x\tw[2]=%x\n", w[0]^(crc<<12), w[1], w[2]);

   w[0]^=(crc<<12);

   //printf("crc: %x\t%x\n", crc, (w[0]>>12) & ((1<<20) - 1));

   //w[0]^=0x12934712;
   //w[1]^=0x246679FA;
   //w[2]^=0xBD34CAF0;
   
   /* Now split those 3x32 = 96 bits into chunks of 6 and print the password */
   /* We need 96/6=16 characters */
   for (n=0; n<6; n++) {
      c[n] = (w[0]>>(n*6)) & 63;
      c[6+n] = ((w[1]>>(n*6)) & 63);
      c[12+n] = (w[2]>>(n*6)) & 63;
   }
   for (n=0; n<15; n++) {
      c[n+1]^=(c[0]^n);
   }
   
   s = malloc(21*sizeof *s);
   s[0] = '\0';
   for(n=0; n<16; n++)
      sprintf(s,"%s%c", s, passwordchars[c[n]]);
   
   //printf("Password: %s\n", s);
   
   return s;
}

/* Returns TRUE if the password is ok */
int decode_password(char *password, HERO *hero)
{
   unsigned int w[3];
   unsigned int crc;
   unsigned int c[21];
   int n;   

   /* Decode password */
   for (n=0; n<16; n++) {
      c[n] = strchr(passwordchars, password[n])-passwordchars;
   }
   w[0] = w[1] = w[2] = 0;

   for (n=0; n<15; n++) {
      c[n+1]^=(c[0]^n);
   }
   
   for (n=0; n<6; n++) {
      w[0] |= (c[n]&63)<<(n*6);
      w[1] |= (c[n+6]&63)<<(n*6);
   }
   for (n=0; n<4; n++) {
      w[2] |= (c[n+12]&63)<<(n*6);
   }

   //printf("Decoded: w[0]=%x\tw[1]=%x\tw[2]=%x\n", w[0], w[1], w[2]);

   /* Get crc */
   crc = (w[0]>>12) & ((1<<20) - 1);
   //printf("crc: %x\n", crc);
   
   /* Unmask crc bits */
   w[0]^=(crc<<12);
   
   /* Check if CRC's are equal, return 0 if not */
   if (crc != (((w[0]^w[1])^w[2]) & ((1<<20)-1))) {
      return 0;
   }

   //printf("Stored crc: %x\tread crc: %x\n", crc, ((w[0]^w[1])^w[2]) & ((1<<20)-1));

   /* Decode the packed data */
   w[2] = (w[2]^w[0])<<8;
   w[2] = w[2]|(w[1] & ((1<<8)-1));
   w[1] = (w[1]^w[2])>>8;

   //printf("Decoded: w[0]=%x\tw[1]=%x\tw[2]=%x\n", w[0], w[1], w[2]);

   //w[0] = hero->level | (hero->max_health/8)<<5 | (hero->max_health%8)<<10;
   hero->level = w[0] & ((1<<5)-1);
   hero->max_health = 8*((w[0]>>5) & ((1<<5)-1)) + 2*((w[0]>>10) & ((1<<2)-1));
   hero->keys = w[1] & ((1<<7)-1);
   hero->bombs = 127-( (w[1]>>7) & ((1<<7)-1) );
   hero->arrows = ((w[1]>>14) & ((1<<7)-1))^(hero->bombs);
   hero->inventory = w[2];
   
   /* Shift lower 8 bits of inventory to w[1] */
   //crc = ((w[0]^w[1])^w[2])&(w[1]) & ((1<<20)-1);
  
   return 1;
}
