/**********************************************/
/* Evert Glebbeek 2005                        */
/* eglebbk@dds.nl                             */
/**********************************************/
#include <stdlib.h>
#include "particle.h"

#define MAX_PARTICLES    (128*1024)

static PARTICLE *particle_chunk = NULL;
static PARTICLE **particle_stack = NULL;
static int particle_stack_counter = 0;

PARTICLE *alloc_particle(void)
{
   /* return the address of the last free particle in the list */
   return particle_stack[particle_stack_counter++];
}

void free_particle(PARTICLE *l)
{
   particle_stack[--particle_stack_counter]=l;
}

int get_particle_count(void)
{
   return particle_stack_counter;
}

int init_particles(void)
{
   int c;

   particle_chunk = realloc(particle_chunk, sizeof *particle_chunk *MAX_PARTICLES);
   particle_stack = realloc(particle_stack, sizeof *particle_stack *MAX_PARTICLES);
   
   particle_stack_counter = 0;
   for (c=0; c<MAX_PARTICLES; c++)
      particle_stack[c] = &(particle_chunk[c]);

   return (sizeof(PARTICLE)+sizeof(PARTICLE *))*MAX_PARTICLES;
}

void free_particles(void)
{
   free(particle_chunk);
   free(particle_stack);
   
   particle_chunk = NULL;
   particle_stack = NULL;
   particle_stack_counter = 0;
}
